/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.inventorio.mixin;

import com.mojang.authlib.GameProfile;
import me.lizardofoz.inventorio.player.InventorioScreenHandler;
import me.lizardofoz.inventorio.player.PlayerAddonSerializer;
import me.lizardofoz.inventorio.player.PlayerInventoryAddon;
import me.lizardofoz.inventorio.util.MixinHelpers;
import me.lizardofoz.inventorio.util.PlayerDuck;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
implements PlayerDuck {
    @Unique
    public PlayerInventoryAddon inventorioAddon;

    @Shadow
    public abstract class_1661 method_31548();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void inventorioCreateAddon(class_1937 world, class_2338 pos, float yaw, GameProfile profile, CallbackInfo ci) {
        class_1657 thisPlayer = (class_1657)this;
        this.inventorioAddon = new PlayerInventoryAddon(thisPlayer);
    }

    @Inject(method={"getEquippedStack"}, at={@At(value="HEAD")}, cancellable=true)
    private void inventorioDisplayOffhand(class_1304 slot, CallbackInfoReturnable<class_1799> cir) {
        if (slot == class_1304.field_6171) {
            cir.setReturnValue((Object)this.inventorioAddon.getDisplayedOffHandStack());
        }
    }

    @Redirect(method={"equipStack"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/collection/DefaultedList;set(ILjava/lang/Object;)Ljava/lang/Object;", ordinal=0))
    private <E> E inventorioEquipMainHand(class_2371<E> defaultedList, int index, E stack) {
        class_1799 itemStack = (class_1799)stack;
        if (this.inventorioAddon.getSwappedHands()) {
            this.inventorioAddon.setSelectedUtilityStack(itemStack);
        } else {
            this.method_31548().field_7547.set(this.method_31548().field_7545, (Object)itemStack);
        }
        return null;
    }

    @Redirect(method={"equipStack"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/collection/DefaultedList;set(ILjava/lang/Object;)Ljava/lang/Object;", ordinal=1))
    private <E> E inventorioEquipOffhand(class_2371<E> defaultedList, int index, E stack) {
        class_1799 itemStack = (class_1799)stack;
        if (this.inventorioAddon.getSwappedHands()) {
            this.inventorioAddon.setSelectedHotbarStack(itemStack);
        } else {
            this.inventorioAddon.setSelectedUtilityStack(itemStack);
        }
        return null;
    }

    @Inject(method={"equipStack"}, at={@At(value="RETURN")})
    private void inventorioOnEquipArmor(class_1304 slot, class_1799 stack, CallbackInfo ci) {
        if (slot.method_5925() == class_1304.class_1305.field_6178) {
            MixinHelpers.withScreenHandler((class_1657)this, InventorioScreenHandler::updateDeepPocketsCapacity);
        }
    }

    @Inject(method={"getArrowType"}, at={@At(value="RETURN")}, cancellable=true)
    private void inventorioGetArrowType(class_1799 bowStack, CallbackInfoReturnable<class_1799> cir) {
        if (!((class_1799)cir.getReturnValue()).method_7960()) {
            return;
        }
        class_1799 arrowStack = this.inventorioAddon.getActiveArrowType(bowStack);
        if (arrowStack != null) {
            cir.setReturnValue((Object)arrowStack);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")})
    private void inventorioPreAttack(class_1297 target, CallbackInfo ci) {
        if (target.method_5732()) {
            this.inventorioAddon.prePlayerAttack();
        }
    }

    @Inject(method={"attack"}, at={@At(value="RETURN")})
    private void inventorioPostAttack(class_1297 target, CallbackInfo ci) {
        if (target.method_5732()) {
            this.inventorioAddon.postPlayerAttack();
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="RETURN")})
    private void inventorioDeserializePlayerAddon(class_2487 tag, CallbackInfo ci) {
        PlayerAddonSerializer.INSTANCE.deserialize(this.inventorioAddon, tag.method_10562("Inventorio"));
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="RETURN")})
    private void inventorioSerializePlayerAddon(class_2487 tag, CallbackInfo ci) {
        class_2487 inventorioTag = new class_2487();
        PlayerAddonSerializer.INSTANCE.serialize(this.inventorioAddon, inventorioTag);
        tag.method_10566("Inventorio", (class_2520)inventorioTag);
    }

    @Inject(method={"tickMovement"}, at={@At(value="RETURN")})
    private void inventorioEmptyMainHandDisplayTool(CallbackInfo ci) {
        this.inventorioAddon.tick();
    }

    @Override
    @Nullable
    public PlayerInventoryAddon getInventorioAddon() {
        return this.inventorioAddon;
    }
}

