/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.inventorio.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import me.lizardofoz.inventorio.config.SettingsEntry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0015\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R0\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lme/lizardofoz/inventorio/config/AbstractSettings;", "", "()V", "configFile", "Ljava/io/File;", "<set-?>", "", "Lme/lizardofoz/inventorio/config/SettingsEntry;", "entries", "getEntries", "()Ljava/util/List;", "setEntries", "(Ljava/util/List;)V", "anyChanges", "", "jsonObject", "Lcom/google/gson/JsonObject;", "asJson", "fromJson", "load", "", "save", "inventorio"})
public abstract class AbstractSettings {
    private File configFile;
    @NotNull
    private List<? extends SettingsEntry> entries = CollectionsKt.emptyList();

    @NotNull
    public final List<SettingsEntry> getEntries() {
        return this.entries;
    }

    protected final void setEntries(@NotNull List<? extends SettingsEntry> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.entries = list;
    }

    @NotNull
    public final JsonObject asJson() {
        JsonObject configRoot = new JsonObject();
        Iterable $this$forEach$iv = this.entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SettingsEntry it = (SettingsEntry)element$iv;
            boolean bl = false;
            configRoot.add(it.configKey, (JsonElement)it.valueAsElement.invoke(it.getValue()));
        }
        return configRoot;
    }

    public final boolean fromJson(@NotNull JsonObject jsonObject) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
            Iterable $this$any$iv = this.entries;
            boolean bl2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SettingsEntry it = (SettingsEntry)element$iv;
                    boolean bl22 = false;
                    if (!(!jsonObject.has(it.configKey))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean missingEntries = bl;
        for (SettingsEntry settingsEntry : this.entries) {
            settingsEntry.setValue(settingsEntry.tryElementAsValue(jsonObject.get(settingsEntry.configKey)));
        }
        return missingEntries;
    }

    public final boolean anyChanges(@NotNull JsonObject jsonObject) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
            Iterable $this$any$iv = this.entries;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SettingsEntry option = (SettingsEntry)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)option.getValue(), (Object)option.tryElementAsValue(jsonObject.get(option.configKey))))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save() {
        try {
            Object object = this.configFile;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"configFile");
                throw null;
            }
            object = new FileWriter((File)object);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                FileWriter it = (FileWriter)object;
                boolean bl3 = false;
                new Gson().toJson((JsonElement)this.asJson(), (Appendable)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void load(@NotNull File configFile) {
        block10: {
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            try {
                this.configFile = configFile;
                if (configFile.exists()) {
                    boolean bl;
                    Closeable closeable = new FileReader(configFile);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Throwable throwable = null;
                    try {
                        FileReader it = (FileReader)closeable;
                        boolean bl4 = false;
                        Object object = new Gson().fromJson((Reader)it, JsonObject.class);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"Gson().fromJson(it, JsonObject::class.java)");
                        bl = this.fromJson((JsonObject)object);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    if (!bl) break block10;
                }
                this.save();
            }
            catch (Exception ignored) {
                this.save();
            }
        }
    }
}

