import bpy
import time
import random
import math
import pickle
# from .general import DirectionalPoint2d, Rect2d, DirectionalPoints2dCollection
# from ..utils import définirPixel
from bpy.types import Node
from .. import CityNodeTreeNode


class Instancer3dInstanciateOperator(bpy.types.Operator):
	bl_idname = 'node.instancer3d_generate'
	bl_label = 'Instanciate all'
	bl_description = ''
	source_node_path = bpy.props.StringProperty()

	def execute(self, context):
		source_node = eval(self.source_node_path)
		return {'FINISHED'}


class Instancer3dDeleteInstancesOperator(bpy.types.Operator):
	bl_idname = 'node.instancer3d_delete_instances'
	bl_label = 'Delete all'
	bl_description = ''
	source_node_path = bpy.props.StringProperty()

	def execute(self, context):
		source_node = eval(self.source_node_path)
		return {'FINISHED'}


class Instancer3dNode(Node, CityNodeTreeNode):
	bl_label = 'Instancer 3d'

	name_prefix = bpy.props.StringProperty(
		name='Name prefix',
		description='',
		default='SC instance ')

	custom_assets_selection_expr = bpy.props.StringProperty(
		name='Asset selector',
		description='',
		default='')

	mesh_datablocks_instanciation_method = bpy.props.EnumProperty(
		name='DATA_Mesh instanciation',
		description='DATA_Mesh sc_bldata_list instanciation method',
		items=[
			('OBJECTS_INSTANCES', 'Full object instances', '', 1),
			('DUPLI_VERTS', 'Duplication at vertices', '', 2),
			('MERGED_MESHES', 'Merged meshes', '', 3),
		])

	other_datablocks_instancing_method = bpy.props.EnumProperty(
		name='Other sc_bldata_list instanciation',
		description='Other sc_bldata_list instanciation method',
		items=[
			('OBJECTS_INSTANCES', 'Full object instances', '', 1),
			('DUPLI_VERTS', 'Duplication at vertices', '', 2),
		])

	existing_instances_overwrite_option = bpy.props.EnumProperty(
		name='Previous instances',
		description='What to do with existing instances from previous instanciations',
		items=[
			('DELETE_EXISTING_INSTANCES', 'Delete', '', 1),
			('KEEP_EXISTING_INSTANCES', 'Keep', '', 2),
		])

	parent_object = bpy.props.StringProperty(
		name='Parent object',
		description='',
		default='')

	pickled_building = bpy.props.StringProperty()

	def init(self, context):
		self.width = 300
		self.inputs.new('AssetInstancesSocket', 'Asset instances')

	def draw_buttons(self, context, layout):
		row = layout.row()
		row.prop(self, 'parent_object', icon='MATCUBE')
		row = layout.row()
		row.prop(self, 'name_prefix')
		row = layout.row()
		row.prop(self, 'custom_assets_selection_expr')
		row = layout.row()
		row.prop(self, 'mesh_datablocks_instanciation_method')
		row = layout.row()
		row.prop(self, 'other_datablocks_instancing_method')
		row = layout.row()
		row.prop(self, 'existing_instances_overwrite_option')
		row = layout.row()
		op = row.operator('node.instancer3d_generate')
		op.source_node_path = 'bpy.data.node_groups["' + self.id_data.name + '"].' + self.path_from_id()
		row = layout.row()
		op = row.operator('node.instancer3d_delete_instances')
		op.source_node_path = 'bpy.data.node_groups["' + self.id_data.name + '"].' + self.path_from_id()

	def update(self):
		pass
