# from pathlib import Path <= NON car conflit de nom avec ma classe Path
import pathlib
import os
import bpy, nodeitems_utils
from . import maps, terrains, SC_NodeCategory, meshes, SC_NodeTree
from .. import my_globals
from nodeitems_utils import NodeCategory, NodeItem, NodeItemCustom
from . import *


class MonNodeItem(NodeItem):
	# def __init__(self, nodetype):
	# 	super().__init__(nodetype)

	# self.bl_rna = bpy.types.Node.bl_rna_get_subclass(self.nodetype)

	@staticmethod
	def draw(self, layout, _context):
		# props = layout.operator("node.add_node", icon='MESH_DATA', text=self.label, text_ctxt=self.translation_context)
		bl_rna = bpy.types.Node.bl_rna_get_subclass(self.nodetype)
		props = layout.operator("node.add_node",
			icon=bl_rna.bl_icon if hasattr(bl_rna, 'bl_icon') else 'BLANK1',
			text=bl_rna.bl_label,
			text_ctxt=self.translation_context)
		props.type = self.nodetype
		props.use_transform = True

		for setting in self.settings.items():
			ops = props.settings.add()
			ops.name = setting[0]
			ops.value = setting[1]


def d(nodeClass):
	def f(node, layout, context):
		op = layout.operator('node.add_node', icon='MESH_DATA', text=nodeClass.bl_label)
		op.type = nodeClass.bl_idname
		op.use_transform = True
		# op.label = 'Toto'
		return op

	return f


# layout.label(text='Hello')
# row = layout.row()
# row.label(text='', icon='MESH_DATA')


# all categories in a list
nodes_categories = [
	# identifier, label, items list
	SC_NodeCategory('OtherNodes', 'Other', items=[
		MonNodeItem('sc_node_ntf3w6ud3pjju9j2c3pa'),  # ExecuteNode
	]),
	SC_NodeCategory('ObjectsNodes', 'Objects', items=[
		MonNodeItem('sc_node_8exb13f4t44x2p1o0cu9'),  # Get_Object
		MonNodeItem('sc_node_mbj38dsx39vnfxn3l1el'),  # MeshObjectOpSelectionInvert
		MonNodeItem('sc_node_zsht359pqmwl9cusqcdi'),  # CreateObjectNode
		MonNodeItem('sc_node_mweep2jn1g9royfmc86z'),  # ObjectsInstancerNode
		MonNodeItem('sc_node_jwctdyts73476clpvu8k'),  # ObjectsGetterNode
		MonNodeItem('sc_node_ivnjovu5ig46drimgrkt'),  # Objects Add
		MonNodeItem('sc_node_g3bjhixwvmdlvup3wc75'),  # Blender Objects Repeated Along Curves
		MonNodeItem('sc_node_4028bwgsec44ntetvhr3'),  # Curves To Blender Objects
		MonNodeItem('sc_node_2lrckpp4sv0sjtvc0eu1'),  # TODEL old meshes and oject instancer node
	]),
	SC_NodeCategory('MapNodes', 'Maps', items=[
		MonNodeItem('sc_node_ar7avrp9ry1xn6kdtpr8'),  # Procedural Map
		MonNodeItem('sc_node_b83miruo9bfz1f11sn72'),  # Map From Image
		MonNodeItem('sc_node_573yb2i51cukrtt62gsf'),  # Map Math
		MonNodeItem('sc_node_2v279dqodgmwg4hgiwtw'),  # Constant Value Map
		MonNodeItem('sc_node_9oky0iu7986j8zssr69e'),  # Scale Map
		MonNodeItem('sc_node_akqqrxx1dvkj755hdzft'),  # Translation Map
	]),
	SC_NodeCategory('TerrainsNodes', 'Terrains', items=[
		# MonNodeItem(terrains.Terrain1.bl_idname),
		# MonNodeItem(terrains.Biome.bl_idname),
		MonNodeItem('sc_node_aj0j1s891gsrcnlahx36'),  # Terrain Shape From Map
		MonNodeItem('sc_node_ue1d6v2aa3zdvy30qw5m'),  # Terrain Grid Mesh
	]),
	SC_NodeCategory('MeshNodes', 'Meshes', items=[
		# NodeItemCustom(draw=d(meshes.Get_Mesh)),
		MonNodeItem(meshes.Get_Mesh.bl_idname),
		# NodeItemCustom(draw=d(meshes.Shade_smooth_flat)),
		MonNodeItem(meshes.Shade_smooth_flat.bl_idname),
		MonNodeItem('sc_node_61wbnimfbn6oawafqv31'),  # GeometriesToMeshNode
		# NodeItem('sc_node_61wbnimfbn6oawafqv31'),  # GeometriesToMeshNode
		MonNodeItem('sc_node_pisrr9se0amvwnf7ph2h'),  # MeshGenerateDisconnectIntersections
		MonNodeItem('sc_node_jfx5qu6s2csmzgc25w1f'),  # Mesh_Edges_From_Curves
		MonNodeItem('sc_node_bgz72b3lt42kxtifmt8d'),  # MeshMaterialCreateSlots
		MonNodeItem('sc_node_tl9r5gez9k7e7hzg4hpu'),  # MeshMaterialAssign
		MonNodeItem('sc_node_wu7jley323ypjtayaare'),  # Mesh_Select
		MonNodeItem('sc_node_y6t81ue4wgfr05z1sul4'),  # Mesh_Inset
		MonNodeItem('sc_node_wb085uc00jakrsv2kzjw'),  # Mesh_Assign_Material_Slot_To_Selection
		MonNodeItem('sc_node_sy8kcvp35wlvixs49r8r'),  # Mesh_Extrude_Selection
		MonNodeItem('sc_node_5aewo220o0z364tomfw6'),  # Mesh_Grouping
		MonNodeItem('sc_node_4j5pt7wajwdkqv6ethdu'),  # Copy_Verts_Z_From_Input_1_to_2
		MonNodeItem('sc_node_x8ib99s96soyg58yng37'),  # Procedural Cube Mesh
		MonNodeItem('sc_node_4onu51z8meeevirb2129'),  # BL Mesh to mesh data
	]),
	SC_NodeCategory('UVNodes', 'UVs', items=[
		MonNodeItem('sc_node_86z2o3k739hezbdqz5kw'),  # QuadsAndTrisLoopsUnwrapNode
		MonNodeItem('sc_node_ks0c4cv8shhh5ytsuf1n'),  # MeshStandardUnwrap
	]),
	SC_NodeCategory('PathNodes', 'Curves & paths', items=[
		MonNodeItem('sc_node_tcrk153cxuc1ho45g22l'),  # Get_Curves
		MonNodeItem('sc_node_97my6l1msh0pbhz5ecbr'),  # MeshEdgesToBezierCurvesNode
		MonNodeItem('sc_node_6z7nsdwvd4l76nuijlr3'),  # Path Generator Node
		MonNodeItem('sc_node_5ze6mj424209utuafm54'),  # Paths To Curves
	]),
	SC_NodeCategory('GridNodes', 'Grids', items=[
		MonNodeItem('sc_node_r4uhwrd61uxtkqtr900e'),  # GridNode
	]),

	SC_NodeCategory('GeometriesNodes', '2D Geometries', items=[
		MonNodeItem('sc_node_wg5dbmeadtyro0wuyfe5'),  # MeshToGeometriesNode
		MonNodeItem('sc_node_6j4jr18gnscd7frx6ji1'),  # Set_Geometries_Name
		MonNodeItem('sc_node_7y4g725avnqoluu2ek48'),  # BufferGeometriesNode
		MonNodeItem('sc_node_cfkzcuhmkvo8khnoyeuu'),  # UnionGeometriesNode
		MonNodeItem('sc_node_0y26ls3ioeplg28qg8q7'),  # SimplifyGeometriesNode
		MonNodeItem('sc_node_8zuchkdncphjebgukt7w'),  # DifferenceGeometriesNode
		MonNodeItem('sc_node_tep47g5kgbi7t1njx4ty'),  # CurvesToGeometriesNode

		# MonNodeItem('sc_node_yv8gzr2k1az8zsskwpmg'),  # AppendGeometriesNode
		# MonNodeItem('ThickenEdgesNode'),
	]),
	SC_NodeCategory('TexturesNodes', 'Texture sets', items=[
		MonNodeItem('sc_node_54kap20qek58q9dxzy0a'),  # New Texture Set
		MonNodeItem('sc_node_6al9ea8zfk04dvfyc6rd'),  # Blender Images To Texture Set
		MonNodeItem('sc_node_seu8ldunyjveppp53fzw'),  # Simple Windows Drawer
		MonNodeItem('sc_node_0b12uumr39cc6rd9tdvu'),  # Random Rectangles Drawer
	]),
	SC_NodeCategory('ImagesNodes', 'Images', items=[
		MonNodeItem('sc_node_v2afgdv6fre205cylj7q'),  # Texture Set To Blender Images
		MonNodeItem('sc_node_yxtbovx2dcew34ozmkl1'),  # Grid To Blender Image
		MonNodeItem('sc_node_ffxli2xzx5km3oysmh7b'),  # Map To Blender Image
		MonNodeItem('sc_node_2oeepxhcdeyiputfhnig'),  # Get Image
	]),
	# SC_NodeCategory('MaterialsNodes', 'Materials', items=[
	# 	MonNodeItem('sc_node_49dd4wznqwcew6w0z98e'),  # Get material
	# 	MonNodeItem('sc_node_r1mro9b04dnf33crlh85'),  # Stack materials
	# ]),
	SC_NodeCategory('CityLayoutNodes', 'City layouts', items=[
		MonNodeItem('sc_node_kzohhse4hspmua3h73a0'),  # Simple Buildings Layout
		MonNodeItem('sc_node_hc5jdkpxyxph1zzvb28b'),  # Non Overlapping Boxes Layout
	]),
	SC_NodeCategory('CityRoadsNodes', 'City roads', items=[
		MonNodeItem('sc_node_cbhb5rdfg4n6n958bi7p'),  # Static Road Portion
		MonNodeItem('sc_node_uc92jz4qe5xjcs5wkeld'),  # Road Portions Instancer
		MonNodeItem('sc_node_dki7t7nc5kgnd5fo4uex'),  # Road Portions Collection
	]),
	SC_NodeCategory('CityBuildingsNodes', 'City buildings', items=[
		MonNodeItem('sc_node_r5qa266fpxijq70wv0c2'),  # StaticBuildingNode
		MonNodeItem('sc_node_aw5hal03wfjm6cjj8ldk'),  # BuildingsCollectionNode
		MonNodeItem('sc_node_x6skxcvg4a6e72ay3dwg'),  # BuildingsInstancerNode
	]),
	SC_NodeCategory('ExportNodes', 'Exports', items=[
		MonNodeItem('sc_node_n86eptw9jpfjkehp8xfr'),  # GeometriesToSVGNode
		MonNodeItem('sc_node_8dcby5vhf82ucfnh2n70'),  # Objects Transforms To JSON Node
	]),
]


def drawMenu(self, context):
	if context.space_data.tree_type != SC_NodeTree.bl_idname:
		return

	layout = self.layout
	layout.operator_context = 'INVOKE_DEFAULT'

	# if drawNodeTreeChooser(layout, context):
	# 	return

	# layout.operator("an.node_search", text="Search", icon="VIEWZOOM")
	# layout.separator()
	# layout.menu(meshes.Get_Mesh.bl_idname, text=meshes.Get_Mesh.bl_label, icon=meshes.Get_Mesh.icon)
	# layout.menu(meshes.Get_Mesh.bl_idname, text='meshes.Get_Mesh.bl_label')

	# layout.menu(MapNodesMenu.__name__, text='Number', icon="LINENUMBERS_ON")
	# insertMenu(layout, MapNodesMenu)
	# layout.separator()
	# insertMenu(layout, MapNodesMenu)
	# insertMenu(layout, TerrainNodesMenu)
	# layout.menu(MeshMenu.bl_idname, text="Meshes", icon="MESH_DATA")
	layout.menu(MeshMenu.bl_idname, text="Meshes", icon_value=my_globals.icônes['tick'].icon_id)


# layout.menu(MeshMenu.bl_idname)


class MeshMenu(bpy.types.Menu):
	bl_idname = "SC_MT_mesh_menu"
	bl_label = "Mesh Menu"

	def draw(self, context):
		layout = self.layout
		insertNode(layout, meshes.Get_Mesh)


def insertMenu(layout, menu_class, icon='NONE'):
	layout.menu(menu_class.__name__, text=menu_class.bl_label, icon=icon)


def insertNode(layout, node_class, settings={}, icon='NONE'):
	operator = layout.operator('node.add_node', text=node_class.bl_label, icon=icon, icon_value=utils.get_icon_value("logo"))
	# operator.type = node_class.__name__
	operator.type = node_class.bl_idname
	operator.use_transform = True
	for name, value in settings.items():
		item = operator.settings.add()
		item.name = name
		item.value = value
	return operator


class MapNodesMenu(bpy.types.Menu):
	bl_label = 'Maps'

	def draw(self, context):
		layout = self.layout
		insertNode(layout, maps.ProceduralMapNode)
		insertNode(layout, maps.MapToBlenderImageNode)
		insertNode(layout, maps.MapFromImageNode)
		insertNode(layout, maps.MapMathNode)
		insertNode(layout, maps.ConstantValueMapNode)
		insertNode(layout, maps.ScaleMapNode)
		insertNode(layout, maps.TranslationMapNode)


class TerrainNodesMenu(bpy.types.Menu):
	bl_label = 'Terrains'

	def draw(self, context):
		layout = self.layout
		insertNode(layout, terrains.TerrainShapeFromMapNode)
		insertNode(layout, terrains.TerrainGridMeshNode)


def drawNodeTreeChooser(layout, context):
	if len(get_city_node_trees()) == 0:
		col = layout.column()
		col.scale_y = 1.6
		col.operator('sc.create_node_tree', text='Create new blank city', icon='PLUS')
		return True
	return False


#
#
# class SCCreateNodeTree(bpy.types.Operator):
# 	bl_idname = 'sc.create_node_tree'
# 	bl_description = 'Creates a new blank city node tree. For easier starts, consider starting from existing city trees that you link or append'
# 	bl_label = 'Create new blank city node tree'
#
# 	def execute(self, context):
# 		tree = bpy.data.node_groups.new('New city', 'SC_NodeTree')
# 		bpy.context.space_data.node_tree = tree
# 		return {'FINISHED'}
#
#
def get_city_node_trees(skipLinkedTrees=True):
	nodeTrees = []
	for nodeTree in bpy.data.node_groups:
		if nodeTree.bl_idname != 'SC_NodeTree': continue
		if skipLinkedTrees and nodeTree.library is not None: continue
		nodeTrees.append(nodeTree)
	return nodeTrees


def link_or_append_assets(should_link=True):
	# collections_names = [
	# 	'SceneCity high-poly assets',
	# 	'SceneCity high-poly assets instances',
	# 	'SceneCity low-poly assets',
	# ]
	# bpy.ops.wm.link(directory=os.path.join(os.path.dirname(os.path.realpath(__file__)), 'models', 'library.blend', 'Collection'),
	# 	link=should_link,
	# 	relative_path=False,
	# 	instance_collections=False,
	# 	files=[{'name': collections_names[0]}, {'name': collections_names[1]}, {'name': collections_names[2]}, ])
	# for collection_name in collections_names:
	# 	bpy.context.view_layer.layer_collection.children[collection_name].exclude = True
	#
	# bpy.ops.wm.link(directory=os.path.join(os.path.dirname(os.path.realpath(__file__)), 'models', 'library.blend', 'Object'),
	# 	link=should_link,
	# 	relative_path=False,
	# 	instance_collections=False,
	# 	files=[
	# 		{'name': 'Scatter city'},
	# 		{'name': 'Terrain below scatter city'},
	# 		{'name': 'Roads input edges'},
	# 	])

	'''
	directory_str = str(Path(__file__).parent.parent / 'models' / 'library.blend' / 'Collection')
	bpy.ops.wm.link(
		# directory=os.path.join(os.path.dirname(os.path.realpath(__file__)), 'models', 'library.blend', 'Collection'),
		directory=directory_str,
		link=should_link, relative_path=False, instance_collections=False, active_collection=False,
		files=[
			{'name': 'SceneCity assets and collections'},
		])
	bpy.context.view_layer.layer_collection.children['SceneCity assets and collections'].exclude = True
	bpy.ops.wm.link(
		# directory=os.path.join(os.path.dirname(os.path.realpath(__file__)), 'models', 'library.blend', 'Collection'),
		directory=directory_str,
		link=True, relative_path=False, instance_collections=False, active_collection=False,
		files=[
			{'name': 'SceneCity presets helper objects'},
		])
	bpy.context.view_layer.layer_collection.children['SceneCity presets helper objects'].exclude = False

	# for collection_name in ['SceneCity high-poly assets', 'SceneCity high-poly assets instances', 'SceneCity low-poly assets']:
	# 	bpy.context.view_layer.layer_collection.children['SceneCity assets and collections'].children[collection_name].exclude = True

	bpy.ops.wm.link(
		# directory=os.path.join(os.path.dirname(os.path.realpath(__file__)), 'models', 'library.blend', 'Image'),
		directory=str(Path(__file__).parent.parent / 'models' / 'library.blend' / 'Image'),
		link=False,
		relative_path=False,
		instance_collections=False,
		files=[
			{'name': 'example mountain 1k.exr'},
		])
	bpy.data.images['example mountain 1k.exr'].use_fake_user = True'''
	# with bpy.data.libraries.load(str(pathlib.Path(__file__).parent.parent / 'models' / 'library.blend'), link=should_link) as (data_from, data_to):
	with bpy.data.libraries.load(str(utils.get_city_data_dir() / 'models' / 'library.blend'), link=should_link) as (data_from, data_to):
		data_to.collections = ['SceneCity assets and collections']
	bpy.context.view_layer.layer_collection.collection.children.link(bpy.data.collections['SceneCity assets and collections'])
	bpy.context.view_layer.layer_collection.children['SceneCity assets and collections'].exclude = True
	# with bpy.data.libraries.load(str(pathlib.Path(__file__).parent.parent / 'models' / 'library.blend'), link=False) as (data_from, data_to):
	with bpy.data.libraries.load(str(utils.get_city_data_dir() / 'models' / 'library.blend'), link=False) as (data_from, data_to):
		data_to.collections = ['SceneCity presets helper objects']
		data_to.node_groups = [
			'Free-form roads',
			'Scatter city',
			'Scatter city over terrain',
			'Grid city',
			'Terrain from image',
			'Terrain procedural',
			'Terrain from image + procedural',
		]
		data_to.images = ['example mountain 1k.exr']  # temporaire, nécessaire pour le terrain preset from image
	bpy.context.view_layer.layer_collection.collection.children.link(bpy.data.collections['SceneCity presets helper objects'])
	bpy.context.view_layer.layer_collection.children['SceneCity presets helper objects'].exclude = False
	for obj in bpy.context.view_layer.layer_collection.children['SceneCity presets helper objects'].collection.objects:
		# obj.hide_viewport = True
		obj.hide_set(True)
	bpy.data.images['example mountain 1k.exr'].use_fake_user = True


class SC_OT_append_assets(bpy.types.Operator):
	bl_idname = 'scene.sc_op_append_assets'
	bl_label = 'Append city assets and presets from library'
	bl_description = "Get started with ready-to-use roads, buildings, materials, and presets. The assets will be local to this file. " \
					 "Append only once to avoid creating duplicates. " \
					 "The library file resides in the addon folder"
	bl_options = {'REGISTER', 'UNDO'}

	def execute(self, context):
		link_or_append_assets(should_link=False)
		return {'FINISHED'}


class SC_OT_link_assets(bpy.types.Operator):
	bl_idname = 'scene.sc_op_link_assets'
	bl_label = 'Link city assets and presets from library'
	bl_description = "Get started with ready-to-use roads, buildings, materials, and presets. The assets won't be local to this file, except for the presets. " \
					 "The library file resides in the addon folder"
	bl_options = {'REGISTER', 'UNDO'}

	def execute(self, context):
		link_or_append_assets(should_link=True)
		return {'FINISHED'}


class SC_OT_append_template_cities(bpy.types.Operator):
	bl_idname = 'scene.sc_ot_append_template_cities'
	bl_label = '2. Append preset city graphs (link assets FIRST!)'
	bl_description = 'Append node graphs of template cities. Best way to get started, then you can adapt the cities to your needs.'
	bl_options = {'REGISTER', 'UNDO'}

	def execute(self, context):
		bpy.ops.wm.link(
			directory=str(Path(__file__).parent.parent / 'models' / 'library.blend' / 'NodeTree'),
			link=False,
			relative_path=False,
			files=[
				{'name': 'Scatter city'},
				{'name': 'Scatter city over terrain'},
				{'name': 'Grid city'},
				{'name': 'Terrain from image'},
				{'name': 'Terrain procedural'},
				{'name': 'Terrain from image + procedural'},
				{'name': 'Free-form roads'},
			])
		return {'FINISHED'}


class SC_MT_NodeTreeCityMenu(bpy.types.Menu):
	bl_idname = 'SC_MT_NodeTreeCityMenu'
	bl_label = 'SceneCity'

	def draw(self, context):
		layout = self.layout
		# layout.label(text='Hello 2')

		# layout.operator('scene.sc_op_link_assets', icon='LINK_BLEND')
		layout.operator(SC_OT_link_assets.bl_idname, icon='LINK_BLEND')
		layout.operator(SC_OT_append_assets.bl_idname, icon='APPEND_BLEND')


# layout.separator()
# layout.operator(SC_OT_append_template_cities.bl_idname, icon='APPEND_BLEND')


def nodeeditor_sc_menu_callback(self, context):
	if context.space_data.tree_type != SC_NodeTree.bl_idname:
		return
	self.layout.menu(SC_MT_NodeTreeCityMenu.bl_idname)


#############################################################################################################
# _node_categories = {}
_node_categories = nodeitems_utils._node_categories


def register_node_categories(identifier, cat_list):
	if identifier in _node_categories:
		raise KeyError("Node categories list '%s' already registered" % identifier)
		return

	# works as draw function for menus
	def draw_node_item(self, context):
		# print('draw_node_item')
		layout = self.layout
		col = layout.column()
		for item in self.category.items(context):
			item.draw(item, col, context)

	menu_types = []
	for cat in cat_list:
		menu_type = type("NODE_MT_category_" + cat.identifier, (bpy.types.Menu,), {
			"bl_space_type": 'NODE_EDITOR',
			"bl_label": cat.name,
			"category": cat,
			"poll": cat.poll,
			"draw": draw_node_item,
		})

		# print(dir(menu_type))
		menu_types.append(menu_type)

		bpy.utils.register_class(menu_type)
	# print('registered')

	def draw_add_menu(self, context):
		# print("ok")
		# print(_node_categories)
		if context.space_data.tree_type != SC_NodeTree.bl_idname:
			return
		# print('draw_add_menu')
		layout = self.layout

		# layout.label(text='Bonjour')
		# layout.separator()
		# layout.operator(MonNodeItem(terrains.Terrain1.bl_idname))
		# props = layout.operator("node.add_node",
		# 	icon='BLANK1',
		# 	text=terrains.Terrain1.bl_label,
		# 	# text_ctxt=self.translation_context
		# )
		# props.nodetype = terrains.Terrain1.bl_idname
		# layout.menu_item(MonNodeItem(terrains.Terrain1.bl_idname))
		insertNode(layout, terrains.Terrain1)

		for cat in cat_list:
			if cat.poll(context):
				# layout.menu("NODE_MT_category_%s" % cat.identifier, icon='MESH_DATA')
				layout.menu("NODE_MT_category_%s" % cat.identifier)

	# stores: (categories list, menu draw function, submenu types)
	_node_categories[identifier] = (cat_list, draw_add_menu, menu_types)


# def node_categories_iter(context):
# 	print('node_categories_iter')
# 	for cat_type in _node_categories.values():
# 		for cat in cat_type[0]:
# 			if cat.poll and ((context is None) or cat.poll(context)):
# 				yield cat
#
#
# def node_items_iter(context):
# 	print('node_items_iter')
# 	for cat in node_categories_iter(context):
# 		for item in cat.items(context):
# 			yield item


# def unregister_node_cat_types(cats):
# 	print('unregister_node_cat_types')
# 	for mt in cats[2]:
# 		bpy.utils.unregister_class(mt)
# 		print('unregistered')
#
#
# def unregister_node_categories(identifier=None):
# 	print('unregister_node_categories')
# 	# unregister existing UI classes
# 	if identifier:
# 		cat_types = _node_categories.get(identifier, None)
# 		if cat_types:
# 			unregister_node_cat_types(cat_types)
# 		del _node_categories[identifier]
#
# 	else:
# 		for cat_types in _node_categories.values():
# 			unregister_node_cat_types(cat_types)
# 		_node_categories.clear()


# def draw_node_categories_menu(self, context):
# 	print('draw_node_categories_menu')
# 	for cats in _node_categories.values():
# 		cats[1](self, context)


#############################################################################################################


classes_to_register = (
	SC_OT_link_assets,
	SC_OT_append_assets,
	SC_OT_append_template_cities,
	SC_MT_NodeTreeCityMenu,
)


def register():
	for c in classes_to_register:
		bpy.utils.register_class(c)
	bpy.types.NODE_MT_editor_menus.append(nodeeditor_sc_menu_callback)
	# nodeitems_utils.register_node_categories('SceneCity_nodes', nodes_categories, True)
	register_node_categories('SceneCity_nodes', nodes_categories)


# Cette technique ne permet pas la recherche dans le menu d'ajout de nouveaux nodes
# mais permet d'ajouter des separators, des icônes (même custom), et d'avoir des sous-menus
# bpy.types.NODE_MT_add.append(drawMenu)


def unregister():
	# unregister_node_categories('SceneCity_nodes')
	nodeitems_utils.unregister_node_categories('SceneCity_nodes')
	bpy.types.NODE_MT_editor_menus.remove(nodeeditor_sc_menu_callback)
	for c in reversed(classes_to_register):
		bpy.utils.unregister_class(c)

#

# bpy.types.NODE_MT_add.remove(drawMenu)
