import bpy
import time
import random
import math
import pickle
# from .general import DirectionalPoint2d, Rect2d, DirectionalPoints2dCollection
# from ..utils import définirPixel
from bpy.types import Node
from .. import CityNodeTreeNode


class NonOverlappingBuildingsLayoutNode(Node, CityNodeTreeNode):
	bl_label = 'Non overlapping buildings layout'

	buildings_params = bpy.props.StringProperty(
		name='Buildings params',
		description='Parameters to send to the buildings', )

	buildings_amount_percent = bpy.props.FloatProperty(
		name='Amount of buildings',
		description='In percent',
		default=10, min=0, max=100)

	asset_group_choice = bpy.props.StringProperty(
		name='Asset tags to use',
		description='Formula returning the tags to choose among the asset groups, depending on parameters of your choice', )

	city_grid_input_limit = bpy.props.StringProperty(
		name='City grid mask',
		description='Boolean to choose what city grid cells can be used, and those that must be left untouched', )

	city_grid_output = bpy.props.StringProperty(
		name='City grid output',
		description='Tags to store in the city grid cells affected by this layout', )

	random_seed = bpy.props.IntProperty(
		name='Seed',
		description='Random seed',
		min=0, )

	pickled_building = bpy.props.StringProperty()

	def init(self, context):
		self.width = 350
		self.outputs.new('AssetInstancesSocket', 'Asset instances')
		self.inputs.new('AssetInstancesSocket', 'Asset instances')
		self.inputs.new('CityDefSocket', 'City def')
		self.outputs.new('CityDefSocket', 'City def')
		self.random_seed = random.randint(0, 9e5)

	def draw_buttons(self, context, layout):
		row = layout.row()
		row.prop(self, 'buildings_amount_percent')
		row = layout.row()
		row.prop(self, 'buildings_params')
		row = layout.row()
		row.prop(self, 'asset_group_choice')
		row = layout.row()
		row.prop(self, 'city_grid_input_limit')
		row = layout.row()
		row.prop(self, 'city_grid_output')
		row = layout.row()
		row.prop(self, 'random_seed')
		op = row.operator('node.randomize_seed_operator')
		op.source_node_path = 'bpy.data.node_groups["' + self.id_data.name + '"].' + self.path_from_id()
		# row = layout.row()
		# row.prop(self, 'custom_choice_condition')
		row = layout.row()
		op = row.operator('node.add_asset_group_socket')
		op.source_node_path = 'bpy.data.node_groups["' + self.id_data.name + '"].' + self.path_from_id()

	def update(self):
		pass
