import bpy
import time
import random
import math
import pickle
# from .general import DirectionalPoint2d, Rect2d, DirectionalPoints2dCollection
# from ..utils import définirPixel
from bpy.types import Node
from .. import CityNodeTreeNode


class SidewalkPortionNodeAddDatablockSocketOperator(bpy.types.Operator):
	bl_idname = 'node.sidewalk_portion_node_add_datablock_socket'
	bl_label = 'Add datablock'
	bl_description = 'Add a datablock to this sidewalk portion, such as a mesh or object group'
	source_node_path = bpy.props.StringProperty()

	def execute(self, context):
		source_node = eval(self.source_node_path)
		random_string = time.time()
		source_node.inputs.new('OptionalDatablockSocket', str(random_string))
		return {'FINISHED'}


class SidewalkPortionNode(Node, CityNodeTreeNode):
	bl_label = 'Sidewalk portion'

	sidewalk_portion_type = bpy.props.EnumProperty(
		name='Type',
		description='',
		items=[
			('MIDDLE', 'Middle', '', 1),
			('BORDER_1_SIDE', 'Border on 1 side (+x)', '', 2),
			('BORDER_2_SIDES_OPPOSITE', 'Border on opposite side (-x and +x)', '', 3),
			('BORDER_2_SIDES_TOUCHING', 'Border on touching sides (+x and +y)', '', 4),
			('BORDER_3_SIDES', 'Border on 3 sides (-x, +x, and +y)', '', 5),
			('BORDER_4_SIDES', 'Border on all 4 sides', '', 6),
		])

	size_grid = bpy.props.IntVectorProperty(
		name='Size',
		description='On x and y, in city grid cells', default=(1, 1), size=2)

	user_data = bpy.props.StringProperty(
		name='Tags',
		description='Set your custom data here. They act like tags, and can be used by various algorithms further down in the graph hierarchy. Check the doc '
					'for more information.', )

	pickled_building = bpy.props.StringProperty()

	def init(self, context):
		self.width = 300
		# self.inputs.new('DatablockSocket', 'Datablock')
		self.outputs.new('CityAssetSocket', 'Sidewalk portion')

	def draw_buttons(self, context, layout):
		row = layout.row()
		row.prop(self, 'size_grid')
		row = layout.row()
		row.prop(self, 'sidewalk_portion_type')
		row = layout.row()
		row.prop(self, 'user_data')
		op = layout.operator('node.building_node_add_datablock_socket')
		op.source_node_path = 'bpy.data.node_groups["' + self.id_data.name + '"].' + self.path_from_id()

	# row = layout.row()
	# row.prop(self, 'datablock_name')
	# row = layout.row()
	# row.prop(self, 'user_data')

	def update(self):
		pass
# datablock = Datablock()
# datablock.type = self.datablock_type
# datablock.name = self.datablock_name
# datablock.user_data_string = self.user_data
# ne pas évaluer le user data maintenant, à cause du random.seed qui pourra être ainsi défini plus tard si besoin
# pickled_Datablock = str(pickle.dumps(datablock))
