import bpy
import time
import random
import math
import pickle
# from .general import DirectionalPoint2d, Rect2d, DirectionalPoints2dCollection
# from ..utils import définirPixel
from bpy.types import Node
from .. import CityNodeTreeNode


class CityAssetGroup():
	'''Un ensemble de bâtiments, rues etc..., on peut en demander un avec des critères comme la taille par exemple, et laisser le user spécifier d'autres
	conditions aussi'''

	def __init__(self):
		pass

	def get_bâtiment(self, **kwargs):
		pass

	def get_rue(self, **kwargs):
		pass


class CityAssetGroupNodeAddAssetSocketOperator(bpy.types.Operator):
	bl_idname = 'node.city_asset_group_node_add_asset_socket'
	bl_label = 'Add asset'
	bl_description = 'Add a building, road portion, etc... to this group'
	source_node_path = bpy.props.StringProperty()

	def execute(self, context):
		source_node = eval(self.source_node_path)
		random_string = time.time()
		source_node.inputs.new('OptionalWeightedCityAssetSocket', str(random_string))
		return {'FINISHED'}


class CityAssetGroupNode(Node, CityNodeTreeNode):
	bl_label = 'City asset group'
	custom_choice_condition = bpy.props.StringProperty(
		name='Custom choice',
		description='An expression returning an integer, to let you decide which asset to choose.', )
	user_data = bpy.props.StringProperty(
		name='Tags',
		description='Set your custom data here. They act like tags, and can be used by various algorithms further down in the graph hierarchy. Check the doc '
					'for more information.', )
	pickled_building = bpy.props.StringProperty()

	def init(self, context):
		self.width = 300
		# self.inputs.new('DatablockSocket', 'Datablock')
		self.outputs.new('CityAssetSocket', 'City asset')

	def draw_buttons(self, context, layout):
		# row = layout.row()
		# row.prop(self, 'taille_type')
		# if self.taille_type == 'FIXED':
		# 	row = layout.row()
		# 	row.prop(self, 'taille_fixe_mètres')
		# else:
		# 	row = layout.row()
		# 	row.prop(self, 'taille_min_mètres')
		# 	row = layout.row()
		# 	row.prop(self, 'taille_max_mètres')
		row = layout.row()
		row.prop(self, 'user_data')
		# row = layout.row()
		# row.prop(self, 'custom_choice_condition')
		row = layout.row()
		op = row.operator('node.city_asset_group_node_add_asset_socket')
		op.source_node_path = 'bpy.data.node_groups["' + self.id_data.name + '"].' + self.path_from_id()

	def update(self):
		pass
