/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.gen;

import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.world.gen.WorldGenHunterCamp;
import de.teamlapen.vampirism.world.gen.WorldGenVampireDungeon;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomePlains;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class VampirismWorldGen
implements IWorldGenerator {
    public static boolean debug = false;
    private final WorldGenHunterCamp hunterCamp = new WorldGenHunterCamp();
    private final WorldGenVampireDungeon vampireDungeon = new WorldGenVampireDungeon();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.getDimension()) {
            case -1: {
                this.generateNether(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                break;
            }
            case 0: {
                this.generateOverworld(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                break;
            }
            case 1: {
                this.generateEnd(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
                break;
            }
        }
    }

    public void generateEnd(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    public void generateNether(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
    }

    public void generateOverworld(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        boolean mapFeatures = world.func_72912_H().func_76089_r();
        Biome biome = world.func_180494_b(new BlockPos((chunkX << 4) + 8, 0, (chunkZ << 4) + 8));
        if (mapFeatures) {
            if (!ModBiomes.vampireForest.getRegistryName().equals((Object)biome.getRegistryName())) {
                int chance = random.nextInt(1000);
                int trees = biome.field_76760_I.field_76832_z;
                float bh = biome.func_185355_j() + biome.func_185360_m();
                float prop = 1.0f;
                prop += (float)Math.min(trees, 8);
                prop += bh * 3.0f;
                if (biome instanceof BiomePlains) {
                    prop *= 0.8f;
                }
                if (world.func_175624_G().equals(WorldType.field_77138_c)) {
                    prop = 0.2f;
                }
                if ((float)chance < (float)Balance.general.HUNTER_CAMP_SPAWN_CHANCE * prop) {
                    BlockPos pos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
                    float temp = biome.func_180626_a(pos = world.func_175645_m(pos));
                    if (this.hunterCamp.isValidTemperature(temp) && world.func_175714_ae().func_176056_a(pos, 20) == null) {
                        this.hunterCamp.func_180709_b(world, random, pos.func_177984_a());
                    }
                }
            }
            for (int j2 = 0; j2 < 5; ++j2) {
                BlockPos pos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
                int i3 = random.nextInt(16) + 8;
                int l3 = random.nextInt(256);
                int l1 = random.nextInt(16) + 8;
                this.vampireDungeon.func_180709_b(world, random, pos.func_177982_a(i3, l3, l1));
            }
        }
    }
}

