/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.EnumGarlicStrength;
import de.teamlapen.vampirism.api.IGarlicBlock;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class Helper {
    public static void spawnParticlesAroundEntity(EntityLivingBase e, EnumParticleTypes particle, double maxDistance, int amount) {
    }

    public static boolean gettingSundamge(EntityLivingBase entity) {
        if (entity.field_70170_p != null) {
            BlockPos pos;
            float angle;
            entity.field_70170_p.field_72984_F.func_76320_a("vampirism_checkSundamage");
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_175149_v()) {
                return false;
            }
            if (VampirismAPI.sundamageRegistry().getSundamageInDim(entity.field_70170_p.field_73011_w.getDimension()) && !entity.field_70170_p.func_72896_J() && ((double)(angle = entity.field_70170_p.func_72826_c(1.0f)) > 0.78 || (double)angle < 0.24) && entity.field_70170_p.func_175710_j(pos = new BlockPos(entity.field_70165_t + 0.5, entity.field_70163_u + 0.0, entity.field_70161_v + 0.5))) {
                ResourceLocation biomeID = null;
                try {
                    biomeID = entity.field_70170_p.func_180494_b(pos).getRegistryName();
                    if (VampirismAPI.sundamageRegistry().getSundamageInBiome(biomeID)) {
                        entity.field_70170_p.field_72984_F.func_76319_b();
                        return true;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            entity.field_70170_p.field_72984_F.func_76319_b();
        }
        return false;
    }

    public static EnumGarlicStrength getGarlicStrength(BlockPos pos) {
        return EnumGarlicStrength.NONE;
    }

    public static EnumGarlicStrength gettingGarlicDamage(EntityLivingBase entity) {
        if (entity.field_70170_p == null) {
            return EnumGarlicStrength.NONE;
        }
        entity.field_70170_p.field_72984_F.func_76320_a("vampirism_checkGarlic");
        EnumGarlicStrength max = EnumGarlicStrength.NONE;
        BlockPos middle = entity.func_180425_c();
        int dist = Balance.general.GARLIC_CHECK_RANGE;
        int minX = middle.func_177958_n() - dist;
        int minY = middle.func_177956_o() - Balance.general.GARLIC_CHECK_VERTICAL_RANGE;
        if (minY < 0) {
            minY = 0;
        }
        int minZ = middle.func_177952_p() - dist;
        int maxX = middle.func_177958_n() + dist + 1;
        int maxY = middle.func_177956_o() + Balance.general.GARLIC_CHECK_VERTICAL_RANGE + 1 + 1;
        int maxZ = middle.func_177952_p() + dist + 1;
        BlockPos.MutableBlockPos blockpos = new BlockPos.MutableBlockPos();
        for (int x = minX; x < maxX; ++x) {
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    if (!(entity.field_70170_p.func_180495_p((BlockPos)blockpos.func_181079_c(x, y, z)).func_177230_c() instanceof IGarlicBlock) || (max = ((IGarlicBlock)entity.field_70170_p.func_180495_p((BlockPos)blockpos).func_177230_c()).getGarlicStrength((IBlockAccess)entity.field_70170_p, (BlockPos)blockpos)) != EnumGarlicStrength.STRONG) continue;
                    entity.field_70170_p.field_72984_F.func_76319_b();
                    return max;
                }
            }
        }
        entity.field_70170_p.field_72984_F.func_76319_b();
        return max;
    }

    public static boolean canBecomeVampire(EntityPlayer player) {
        return FactionPlayerHandler.get(player).canJoin(VReference.VAMPIRE_FACTION);
    }

    public static boolean isVampire(EntityPlayer player) {
        return FactionPlayerHandler.get(player).isInFaction(VReference.VAMPIRE_FACTION);
    }

    public static boolean isHunter(EntityPlayer player) {
        return FactionPlayerHandler.get(player).isInFaction(VReference.HUNTER_FACTION);
    }

    public static boolean areSkillsEnabled(ISkillHandler skillHandler, ISkill ... skills) {
        for (ISkill skill : skills) {
            if (skillHandler.isSkillEnabled(skill)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEntityInVampireBiome(Entity e) {
        if (e == null || e.field_70170_p == null) {
            return false;
        }
        try {
            return ModBiomes.vampireForest.getRegistryName().equals((Object)e.field_70170_p.func_180494_b(e.func_180425_c()).getRegistryName());
        }
        catch (NullPointerException e1) {
            VampirismMod.log.e("Helper", e1, "Nullpointer when checking biome. This is strange and should not happen", new Object[0]);
            return false;
        }
    }

    public static boolean canUseFactionItem(ItemStack stack, IFactionLevelItem item, IFactionPlayerHandler playerHandler) {
        IPlayableFaction usingFaction = item.getUsingFaction(stack);
        ISkill requiredSkill = item.getRequiredSkill(stack);
        int reqLevel = item.getMinLevel(stack);
        if (usingFaction != null && !playerHandler.isInFaction(usingFaction)) {
            return false;
        }
        if (playerHandler.getCurrentLevel() < reqLevel) {
            return false;
        }
        return requiredSkill == null || playerHandler.getCurrentFactionPlayer() != null && playerHandler.getCurrentFactionPlayer().getSkillHandler().isSkillEnabled(requiredSkill);
    }
}

