/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class DaySleepHelper {
    private static final Map<Integer, Boolean> allPlayersAsleep = new HashMap<Integer, Boolean>();

    public static void updateAllPlayersSleeping(World world) {
        DaySleepHelper.updateAllPlayersSleeping(world, 0);
    }

    public static void updateAllPlayersSleeping(World world, int ignorePlayers) {
        if (!world.field_73010_i.isEmpty()) {
            int i = 0;
            int j = 0;
            for (EntityPlayer entityplayer : world.field_73010_i) {
                if (entityplayer.func_175149_v()) {
                    ++i;
                    continue;
                }
                if (!VampirePlayer.get(entityplayer).isPlayerSleeping()) continue;
                ++j;
            }
            boolean all = j > 0 && j >= world.field_73010_i.size() - i - ignorePlayers;
            allPlayersAsleep.put(world.field_73011_w.getDimension(), all);
        }
    }

    public static void checkSleepWorld(World world) {
        if (allPlayersAsleep.get(world.field_73011_w.getDimension()) == Boolean.TRUE) {
            int sleeping = 0;
            int total = 0;
            for (EntityPlayer entityplayer : world.field_73010_i) {
                if (entityplayer.func_175149_v()) continue;
                ++total;
                if (!VampirePlayer.get(entityplayer).isPlayerFullyAsleep()) continue;
                ++sleeping;
            }
            if ((float)sleeping / (float)total * 100.0f < (float)Configs.coffin_sleep_percentage) {
                return;
            }
            if (world.func_82736_K().func_82766_b("doDaylightCycle")) {
                long i = world.func_72912_H().func_76073_f() + 24000L;
                world.func_72912_H().func_76068_b(i - i % 24000L + 12700L);
            }
            DaySleepHelper.wakeAllPlayers(world);
        }
    }

    public static void wakeAllPlayers(World world) {
        allPlayersAsleep.put(world.field_73011_w.getDimension(), false);
        for (EntityPlayer entityplayer : world.field_73010_i) {
            VampirePlayer vampirePlayer = VampirePlayer.get(entityplayer);
            if (!vampirePlayer.isPlayerSleeping()) continue;
            vampirePlayer.wakeUpPlayer(false, false, true);
        }
        if (!world.field_72995_K) {
            world.field_73011_w.resetRainAndThunder();
        }
    }
}

