/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tileentity;

import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.inventory.InventoryHelper;
import de.teamlapen.lib.lib.inventory.InventorySlot;
import de.teamlapen.lib.lib.tile.InventoryTileEntity;
import de.teamlapen.lib.lib.util.ValuedObject;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.blocks.BlockAltarPillar;
import de.teamlapen.vampirism.client.render.particle.ModParticles;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileAltarInfusion
extends InventoryTileEntity
implements ITickable {
    private static final String TAG = "TEAltarInfusion";
    private static final Item[] items = new Item[]{ModItems.pureBlood, ModItems.humanHeart, ModItems.vampireBook};
    private final int DURATION_TICK = 450;
    private EntityPlayer player;
    private BlockPos[] tips;
    private int runningTick;
    private int targetLevel;

    public TileAltarInfusion() {
        super(new InventorySlot[]{new InventorySlot(items[0], 44, 34), new InventorySlot(items[1], 80, 34), new InventorySlot(items[2], 116, 34)});
    }

    public PHASE getCurrentPhase() {
        if (this.runningTick < 1) {
            return PHASE.NOT_RUNNING;
        }
        if (this.runningTick == 1) {
            return PHASE.CLEAN_UP;
        }
        if (this.runningTick > 350) {
            return PHASE.PARTICLE_SPREAD;
        }
        if (this.runningTick < 290 && this.runningTick >= 250) {
            return PHASE.BEAM1;
        }
        if (this.runningTick < 250 && this.runningTick > 50) {
            return PHASE.BEAM2;
        }
        if (this.runningTick == 50) {
            return PHASE.LEVELUP;
        }
        if (this.runningTick < 50) {
            return PHASE.ENDING;
        }
        return PHASE.WAITING;
    }

    public String func_70005_c_() {
        return "tile.vampirism.altarInfusion.name";
    }

    public EntityPlayer getPlayer() {
        if (this.runningTick <= 1) {
            return null;
        }
        return this.player;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public int getRunningTick() {
        return this.runningTick;
    }

    public BlockPos[] getTips() {
        if (this.runningTick <= 1) {
            return null;
        }
        return this.tips;
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onActivated(EntityPlayer player) {
        if (this.runningTick > 0) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_70170_p.func_72935_r()) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.ritual_night_only", new Object[0]));
            return;
        }
        this.targetLevel = VampirePlayer.get(player).getLevel() + 1;
        int requiredLevel = this.checkRequiredLevel();
        if (requiredLevel == -1) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.ritual_level_wrong", new Object[0]));
        } else if (!this.checkStructureLevel(requiredLevel)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.ritual_structure_wrong", new Object[0]));
        } else if (this.checkItemRequirements(player)) {
            this.player = player;
            this.runningTick = 450;
            if (!this.field_145850_b.field_72995_K) {
                IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
                this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
            }
            player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 450, 10));
            this.func_70296_d();
            return;
        }
        this.tips = null;
        this.runningTick = 0;
        this.player = null;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        int tick = tagCompound.func_74762_e("tick");
        if (tick > 0 && this.player == null) {
            try {
                this.player = (EntityPlayer)this.field_145850_b.func_73045_a(tagCompound.func_74762_e("playerId"));
                this.runningTick = tick;
                this.targetLevel = VampirePlayer.get(this.player).getLevel() + 1;
            }
            catch (NullPointerException e) {
                VampirismMod.log.w(TAG, "Failed to find player %d", tagCompound.func_74762_e("playerId"));
            }
        }
        if (this.player == null) {
            this.runningTick = 0;
            this.tips = null;
        } else {
            this.checkStructureLevel(this.checkRequiredLevel());
        }
    }

    public void func_73660_a() {
        --this.runningTick;
        if (this.runningTick <= 0) {
            return;
        }
        if (this.player == null || this.player.field_70128_L) {
            this.runningTick = 1;
        } else {
            this.player.field_70159_w = 0.0;
            this.player.field_70181_x = this.player.field_70181_x >= 0.0 ? 0.0 : (this.player.field_70181_x /= 2.0);
            this.player.field_70179_y = 0.0;
        }
        PHASE phase = this.getCurrentPhase();
        if (this.field_145850_b.field_72995_K) {
            if (phase.equals((Object)PHASE.PARTICLE_SPREAD) && this.runningTick % 15 == 0) {
                BlockPos pos = this.func_174877_v();
                for (int i = 0; i < this.tips.length; ++i) {
                    BlockPos pTip = this.tips[i];
                    VampLib.proxy.getParticleHandler().spawnParticles(this.field_145850_b, ModParticles.FLYING_BLOOD, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5, 0.1, new Random(), (double)pTip.func_177958_n() + 0.5, (double)pTip.func_177956_o() + 0.3, (double)pTip.func_177952_p() + 0.5, 60);
                }
            }
            if (this.runningTick == 250 && VampirismMod.proxy.isPlayerThePlayer(this.getPlayer())) {
                VampirismMod.proxy.renderScreenFullColor(200, 50, 0xFF0000);
            }
        }
        if (phase.equals((Object)PHASE.CLEAN_UP)) {
            this.player = null;
            this.tips = null;
            this.func_70296_d();
        }
        if (phase.equals((Object)PHASE.LEVELUP)) {
            if (!this.field_145850_b.field_72995_K) {
                FactionPlayerHandler handler = FactionPlayerHandler.get(this.player);
                if (handler.getCurrentLevel(VReference.VAMPIRE_FACTION) != this.targetLevel - 1) {
                    VampirismMod.log.w(TAG, "Player %s changed level while the ritual was running. Cannot levelup.", this.player);
                    return;
                }
                handler.setFactionLevel(VReference.VAMPIRE_FACTION, handler.getCurrentLevel(VReference.VAMPIRE_FACTION) + 1);
            } else {
                this.field_145850_b.func_184134_a(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f) * 0.7f, true);
                this.field_145850_b.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, 1.0, 0.0, 0.0, new int[0]);
            }
            this.player.func_70690_d(new PotionEffect(ModPotions.saturation, 400, 2));
            this.player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 400, 2));
            this.player.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 400, 2));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbt = super.func_189515_b(compound);
        nbt.func_74768_a("tick", this.runningTick);
        if (this.player != null) {
            nbt.func_74768_a("playerId", this.player.func_145782_y());
        }
        return nbt;
    }

    private ItemStack checkAndRemoveItems(int bloodMeta, int blood, int heart, int par3) {
        ItemStack missing = InventoryHelper.checkItems(this, items, new int[]{blood, heart, par3}, new int[]{bloodMeta == 0 ? Integer.MIN_VALUE : -bloodMeta, Integer.MIN_VALUE, Integer.MIN_VALUE});
        if (missing == null) {
            InventoryHelper.removeItems(this, new int[]{blood, heart, par3});
        }
        return missing;
    }

    private boolean checkItemRequirements(EntityPlayer player) {
        int newLevel = this.targetLevel;
        ItemStack missing = null;
        switch (newLevel) {
            case 5: {
                missing = this.checkAndRemoveItems(0, 0, 5, 1);
                break;
            }
            case 6: {
                missing = this.checkAndRemoveItems(0, 1, 5, 1);
                break;
            }
            case 7: {
                missing = this.checkAndRemoveItems(0, 1, 10, 1);
                break;
            }
            case 8: {
                missing = this.checkAndRemoveItems(1, 1, 10, 1);
                break;
            }
            case 9: {
                missing = this.checkAndRemoveItems(1, 1, 10, 1);
                break;
            }
            case 10: {
                missing = this.checkAndRemoveItems(2, 1, 15, 1);
                break;
            }
            case 11: {
                missing = this.checkAndRemoveItems(2, 1, 15, 1);
                break;
            }
            case 12: {
                missing = this.checkAndRemoveItems(3, 1, 20, 1);
                break;
            }
            case 13: {
                missing = this.checkAndRemoveItems(3, 2, 20, 1);
                break;
            }
            case 14: {
                missing = this.checkAndRemoveItems(4, 2, 25, 1);
                break;
            }
            default: {
                VampirismMod.log.w(TAG, "Checking for level %d, but this altar cannot be used at that level", newLevel);
            }
        }
        if (missing != null) {
            TextComponentTranslation item = missing.func_77973_b().equals((Object)ModItems.pureBlood) ? ModItems.pureBlood.getDisplayName(missing) : new TextComponentTranslation(missing.func_77977_a() + ".name", new Object[0]);
            TextComponentTranslation main = new TextComponentTranslation("text.vampirism.ritual_missing_items", new Object[]{missing.field_77994_a, item});
            player.func_146105_b((ITextComponent)main);
            return false;
        }
        return true;
    }

    private int checkRequiredLevel() {
        int newLevel = this.targetLevel;
        if (newLevel < 5 || newLevel > 14) {
            return -1;
        }
        int t = (newLevel - 4) / 2;
        return (int)(8.0f + (float)(46 * t) / 5.0f);
    }

    private boolean checkStructureLevel(int required) {
        int i;
        int v;
        BlockPos[] tips = this.findTips();
        ValuedObject[] valuedTips = new ValuedObject[tips.length];
        for (int i2 = 0; i2 < tips.length; ++i2) {
            IBlockState temp;
            BlockPos pPos = tips[i2];
            int j = 0;
            BlockAltarPillar.EnumPillarType type = null;
            while ((temp = this.func_145831_w().func_180495_p(pPos.func_177982_a(0, -j - 1, 0))).func_177230_c().equals((Object)ModBlocks.altarPillar)) {
                BlockAltarPillar.EnumPillarType t = (BlockAltarPillar.EnumPillarType)((Object)temp.func_177229_b(BlockAltarPillar.typeProperty));
                if (type == null) {
                    type = t;
                    ++j;
                    continue;
                }
                if (!type.equals((Object)t)) break;
                ++j;
            }
            int value = (int)((float)(10 * Math.min(j, 3)) * (type == null ? 0.0f : type.getValue()));
            valuedTips[i2] = new ValuedObject<BlockPos>(tips[i2], value);
        }
        Arrays.sort(valuedTips, ValuedObject.getInvertedComparator());
        int found = 0;
        for (i = 0; found < required * 10 && i < valuedTips.length && i < 9 && (v = valuedTips[i].value) != 0; found += v, ++i) {
        }
        valuedTips = Arrays.copyOfRange(valuedTips, 0, i);
        this.tips = ValuedObject.extract(BlockPos.class, valuedTips);
        return found >= required * 10;
    }

    private BlockPos[] findTips() {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x = this.func_174877_v().func_177958_n() - 4; x < this.func_174877_v().func_177958_n() + 5; ++x) {
            for (int y = this.func_174877_v().func_177956_o() + 1; y < this.func_174877_v().func_177956_o() + 4; ++y) {
                for (int z = this.func_174877_v().func_177952_p() - 4; z < this.func_174877_v().func_177952_p() + 5; ++z) {
                    if (!this.func_145831_w().func_180495_p((BlockPos)pos.func_181079_c(x, y, z)).func_177230_c().equals((Object)ModBlocks.altarTip)) continue;
                    list.add(new BlockPos(x, y, z));
                }
            }
        }
        return list.toArray(new BlockPos[list.size()]);
    }

    public static enum PHASE {
        NOT_RUNNING,
        PARTICLE_SPREAD,
        BEAM1,
        BEAM2,
        WAITING,
        LEVELUP,
        ENDING,
        CLEAN_UP;

    }
}

