/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.tests;

import de.teamlapen.lib.lib.util.FluidLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.fluids.BloodHelper;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class Tests {
    public static void runTests(World world, EntityPlayer player) {
        Tests.sendMsg(player, "Starting tests");
        Tests.log("Clearing area", new Object[0]);
        Tests.clearArea(world);
        boolean test1 = false;
        try {
            test1 = Tests.bloodFluidHandler(world, new BlockPos(-20, 2, -20));
        }
        catch (Throwable e) {
            Tests.log("bloodFluidHandler test failed with exception %s", e);
        }
        Tests.sendMsg(player, "bloodFluidHandler test " + (test1 ? "\u00a72was successful\u00a7r" : "\u00a74failed\u00a7r"));
        Tests.log("Finished tests -> teleporting player", new Object[0]);
        player.func_184595_k(0.0, 5.0, 0.0);
        Tests.sendMsg(player, "Finished tests");
    }

    private static boolean bloodFluidHandler(World world, BlockPos pos) throws Throwable {
        world.func_175656_a(pos, ModBlocks.bloodContainer.func_176223_P());
        TileEntity t = world.func_175625_s(pos);
        IFluidHandler handler = (IFluidHandler)t.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.func_176741_a((Random)world.field_73012_v));
        handler.fill(new FluidStack(ModFluids.blood, 10000000), true);
        int blood = BloodHelper.getBlood(handler);
        assert (blood > 0) : "Could not fill blood container";
        ItemStack bloodBottle1 = new ItemStack((Item)ModItems.bloodBottle);
        ItemStack bloodBottle2 = new ItemStack((Item)ModItems.bloodBottle);
        FluidLib.drainContainerIntoTank(handler, (IFluidHandler)bloodBottle1.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
        FluidLib.drainContainerIntoTank(handler, (IFluidHandler)bloodBottle2.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
        assert (BloodHelper.getBlood(handler) < blood) : "Failed to train from container into bottles";
        FluidLib.drainContainerIntoTank((IFluidHandler)bloodBottle1.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null), handler);
        Tests.log("%d %d", BloodHelper.getBlood(handler), blood);
        assert (BloodHelper.getBlood(handler) == blood) : "Lost blood somewhere";
        return true;
    }

    private static void log(String msg, Object ... format) {
        VampirismMod.log.w("TEST", msg, format);
    }

    private static void sendMsg(EntityPlayer player, String msg) {
        player.func_146105_b((ITextComponent)new TextComponentString("\u00a71[V-TEST]\u00a7r " + msg));
    }

    private static void clearArea(World world) {
        for (int x = -21; x < 22; ++x) {
            for (int y = 1; y < 22; ++y) {
                for (int z = -21; z < 22; ++z) {
                    IBlockState s = y == 1 || x == -21 || x == 21 || z == -21 || z == 21 || y == 21 ? Blocks.field_150348_b.func_176223_P() : Blocks.field_150350_a.func_176223_P();
                    world.func_175656_a(new BlockPos(x, y, z), s);
                }
            }
        }
    }
}

