/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire.actions;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.player.vampire.DefaultVampireAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.entity.EntityAreaParticleCloud;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;

public class TeleportVampireAction
extends DefaultVampireAction {
    public TeleportVampireAction() {
        super(null);
    }

    @Override
    public boolean canBeUsedBy(IVampirePlayer vampire) {
        return !vampire.getActionHandler().isActionActive(VampireActions.batAction);
    }

    @Override
    public int getCooldown() {
        return Balance.vpa.TELEPORT_COOLDOWN * 20;
    }

    @Override
    public int getMinU() {
        return 112;
    }

    @Override
    public int getMinV() {
        return 0;
    }

    @Override
    public String getUnlocalizedName() {
        return "action.vampirism.vampire.teleport";
    }

    @Override
    public boolean isEnabled() {
        return Balance.vpa.TELEPORT_ENABLED;
    }

    @Override
    public boolean onActivated(IVampirePlayer vampire) {
        EntityPlayer player = vampire.getRepresentingPlayer();
        RayTraceResult target = UtilLib.getPlayerLookingSpot(player, Balance.vpa.TELEPORT_MAX_DISTANCE);
        double ox = player.field_70165_t;
        double oy = player.field_70163_u;
        double oz = player.field_70161_v;
        if (target == null) {
            player.func_184185_a(SoundEvents.field_187679_dF, 1.0f, 1.0f);
            return false;
        }
        BlockPos pos = null;
        if (player.field_70170_p.func_180495_p(target.func_178782_a()).func_185904_a().func_76230_c()) {
            pos = target.func_178782_a().func_177984_a();
        }
        if (pos != null) {
            player.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
            if (!player.field_70170_p.func_147461_a(player.func_174813_aQ()).isEmpty() || player.field_70170_p.func_72953_d(player.func_174813_aQ())) {
                pos = null;
            }
        }
        if (pos == null) {
            player.func_70107_b(ox, oy, oz);
            player.func_184185_a(SoundEvents.field_187676_dE, 1.0f, 1.0f);
            return false;
        }
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMp = (EntityPlayerMP)player;
            playerMp.func_71123_m();
            playerMp.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
        }
        EntityAreaParticleCloud particleCloud = new EntityAreaParticleCloud(player.field_70170_p);
        particleCloud.func_70107_b(ox, oy, oz);
        particleCloud.setRadius(0.7f);
        particleCloud.setHeight(player.field_70131_O);
        particleCloud.setDuration(5);
        particleCloud.setSpawnRate(15.0f);
        player.field_70170_p.func_72838_d((Entity)particleCloud);
        player.field_70170_p.func_184134_a(ox, oy, oz, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        player.field_70170_p.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
        return true;
    }
}

