/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.vampire;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.EnumGarlicStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampireVision;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.Achievements;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.core.ModSounds;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.items.ItemHunterCoat;
import de.teamlapen.vampirism.player.LevelAttributeModifier;
import de.teamlapen.vampirism.player.VampirismPlayer;
import de.teamlapen.vampirism.player.actions.ActionHandler;
import de.teamlapen.vampirism.player.skills.SkillHandler;
import de.teamlapen.vampirism.player.vampire.BloodStats;
import de.teamlapen.vampirism.player.vampire.VampirePlayerDefaultImpl;
import de.teamlapen.vampirism.player.vampire.VampirePlayerSpecialAttributes;
import de.teamlapen.vampirism.player.vampire.actions.BatVampireAction;
import de.teamlapen.vampirism.potion.FakeNightVisionPotionEffect;
import de.teamlapen.vampirism.potion.PotionSanguinare;
import de.teamlapen.vampirism.util.DaySleepHelper;
import de.teamlapen.vampirism.util.GeneralRegistryImpl;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.Permissions;
import de.teamlapen.vampirism.util.REFERENCE;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketAnimation;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VampirePlayer
extends VampirismPlayer<IVampirePlayer>
implements IVampirePlayer {
    @CapabilityInject(value=IVampirePlayer.class)
    public static final Capability<IVampirePlayer> CAP = null;
    private static final String TAG = "VampirePlayer";
    private final BloodStats bloodStats;
    private final String KEY_EYE = "eye_type";
    private final String KEY_FANGS = "fang_type";
    private final String KEY_SPAWN_BITE_PARTICLE = "bite_particle";
    private final String KEY_VISION = "vision";
    private final ActionHandler<IVampirePlayer> actionHandler;
    private final SkillHandler<IVampirePlayer> skillHandler;
    private final VampirePlayerSpecialAttributes specialAttributes = new VampirePlayerSpecialAttributes();
    private boolean sundamage_cache = false;
    private EnumGarlicStrength garlic_cache = EnumGarlicStrength.NONE;
    private int biteCooldown = 0;
    private int eyeType = 0;
    private int fangType = 0;
    private int ticksInSun = 0;
    private boolean sleepingInCoffin = false;
    private int sleepTimer = 0;
    private boolean wasDead = false;
    private List<IVampireVision> unlockedVisions = new ArrayList<IVampireVision>();
    private IVampireVision activatedVision = null;

    public static VampirePlayer get(EntityPlayer player) {
        return (VampirePlayer)player.getCapability(CAP, null);
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IVampirePlayer.class, (Capability.IStorage)new Storage(), VampirePlayerDefaultImpl.class);
    }

    public static ICapabilityProvider createNewCapability(final EntityPlayer player) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            IVampirePlayer inst;
            {
                this.inst = new VampirePlayer(player);
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (NBTBase)nbt);
            }

            public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                return (T)(CAP.equals(capability) ? CAP.cast((Object)this.inst) : null);
            }

            public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                return CAP.equals(capability);
            }

            public NBTTagCompound serializeNBT() {
                return (NBTTagCompound)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }
        };
    }

    public VampirePlayer(EntityPlayer player) {
        super(player);
        this.applyEntityAttributes();
        this.bloodStats = new BloodStats(player);
        this.actionHandler = new ActionHandler<VampirePlayer>(this);
        this.skillHandler = new SkillHandler<VampirePlayer>(this);
    }

    @Override
    public void activateVision(@Nullable IVampireVision vision) {
        if (vision != null && !this.isRemote() && ((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getIdOfVision(vision) == -1) {
            throw new IllegalArgumentException("You have to register the vision first: " + vision);
        }
        if (!Objects.equals(this.activatedVision, vision)) {
            if (this.activatedVision != null) {
                this.activatedVision.onDeactivated(this);
            }
            this.activatedVision = vision;
            if (vision != null) {
                vision.onActivated(this);
            }
            if (!this.isRemote()) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("vision", this.activatedVision == null ? -1 : ((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getIdOfVision(this.activatedVision));
                this.sync(nbt, false);
            }
        }
    }

    public void addExhaustion(float p_71020_1_) {
        if (!this.player.field_71075_bZ.field_75102_a && this.getLevel() > 0 && !this.isRemote()) {
            this.bloodStats.addExhaustion(p_71020_1_);
        }
    }

    public void biteEntity(int entityId) {
        Entity e = this.player.field_70170_p.func_73045_a(entityId);
        if (this.player.func_175149_v()) {
            VampirismMod.log.w(TAG, "Player can't bite in spectator mode", new Object[0]);
            return;
        }
        if (e != null && e instanceof EntityLivingBase) {
            if ((double)e.func_70032_d((Entity)this.player) <= ((EntityPlayerMP)this.player).field_71134_c.getBlockReachDistance() + 2.0) {
                this.biteEntity((EntityLivingBase)e);
            } else {
                VampirismMod.log.w(TAG, "Entity sent by client is not in reach " + entityId, new Object[0]);
            }
        }
    }

    @Override
    public boolean canBeBitten(IVampire biter) {
        return !this.player.func_175149_v() && !this.player.func_184812_l_();
    }

    @Override
    public boolean canLeaveFaction() {
        return true;
    }

    @Override
    public IVampirePlayer.BITE_TYPE determineBiteType(EntityLivingBase entity) {
        if (entity instanceof IBiteableEntity && ((IBiteableEntity)entity).canBeBitten(this)) {
            return IVampirePlayer.BITE_TYPE.SUCK_BLOOD;
        }
        if (entity instanceof EntityCreature) {
            if (ExtendedCreature.get((EntityCreature)entity).canBeBitten(this)) {
                return IVampirePlayer.BITE_TYPE.SUCK_BLOOD_CREATURE;
            }
        } else if (entity instanceof EntityPlayer) {
            if (((EntityPlayer)entity).field_71075_bZ.field_75098_d || !Permissions.getPermission("pvp", this.player)) {
                return IVampirePlayer.BITE_TYPE.NONE;
            }
            boolean hunter = Helper.isHunter(this.player);
            if (!UtilLib.canReallySee(entity, (EntityLivingBase)this.player, false) && VampirePlayer.get((EntityPlayer)entity).canBeBitten(this)) {
                return hunter ? IVampirePlayer.BITE_TYPE.SUCK_BLOOD_HUNTER_PLAYER : IVampirePlayer.BITE_TYPE.SUCK_BLOOD_PLAYER;
            }
            return hunter ? IVampirePlayer.BITE_TYPE.ATTACK_HUNTER : IVampirePlayer.BITE_TYPE.ATTACK;
        }
        return IVampirePlayer.BITE_TYPE.ATTACK;
    }

    @Override
    public boolean doesResistGarlic(EnumGarlicStrength strength) {
        return false;
    }

    @Override
    public void drinkBlood(int amt, float saturationMod) {
        int left = this.bloodStats.addBlood(amt, saturationMod);
        if (left > 0) {
            this.handleSpareBlood(left);
        }
    }

    @Override
    public IActionHandler<IVampirePlayer> getActionHandler() {
        return this.actionHandler;
    }

    @Override
    @Nullable
    public IVampireVision getActiveVision() {
        return this.activatedVision;
    }

    @Override
    public int getBloodLevel() {
        return this.bloodStats.getBloodLevel();
    }

    @Override
    public float getBloodSaturation() {
        return (float)Balance.vp.PLAYER_BLOOD_SATURATION;
    }

    public BloodStats getBloodStats() {
        return this.bloodStats;
    }

    @Override
    public ResourceLocation getCapKey() {
        return REFERENCE.VAMPIRE_PLAYER_KEY;
    }

    @Override
    @Nullable
    public IFaction getDisguisedAs() {
        return this.isDisguised() ? this.specialAttributes.disguisedAs : this.getFaction();
    }

    public int getEyeType() {
        return this.eyeType;
    }

    @Override
    public IPlayableFaction<IVampirePlayer> getFaction() {
        return VReference.VAMPIRE_FACTION;
    }

    public int getFangType() {
        return this.fangType;
    }

    @Override
    public Predicate<? super Entity> getNonFriendlySelector(boolean otherFactionPlayers, boolean ignoreDisguise) {
        if (otherFactionPlayers) {
            return Predicates.alwaysTrue();
        }
        return VampirismAPI.factionRegistry().getPredicate(this.getFaction(), ignoreDisguise);
    }

    @Override
    public ISkillHandler<IVampirePlayer> getSkillHandler() {
        return this.skillHandler;
    }

    public VampirePlayerSpecialAttributes getSpecialAttributes() {
        return this.specialAttributes;
    }

    @Override
    public int getTicksInSun() {
        return this.ticksInSun;
    }

    @Override
    public boolean isAutoFillEnabled() {
        return false;
    }

    @Override
    public boolean isDisguised() {
        return this.specialAttributes.disguised;
    }

    @Override
    public EnumGarlicStrength isGettingGarlicDamage() {
        return this.isGettingGarlicDamage(false);
    }

    @Override
    public EnumGarlicStrength isGettingGarlicDamage(boolean forcerefresh) {
        if (forcerefresh) {
            this.garlic_cache = Helper.gettingGarlicDamage((EntityLivingBase)this.player);
        }
        return this.garlic_cache;
    }

    @Override
    public boolean isGettingSundamage(boolean forcerefresh) {
        if (forcerefresh) {
            this.sundamage_cache = Helper.gettingSundamge((EntityLivingBase)this.player);
        }
        return this.sundamage_cache;
    }

    @Override
    public boolean isGettingSundamage() {
        return this.isGettingSundamage(false);
    }

    @Override
    public boolean isIgnoringSundamage() {
        return false;
    }

    public boolean isPlayerFullyAsleep() {
        return this.sleepingInCoffin && this.sleepTimer >= 100;
    }

    public boolean isPlayerSleeping() {
        return this.sleepingInCoffin;
    }

    @Override
    public boolean isVampireLord() {
        return false;
    }

    public void loadData(NBTTagCompound nbt) {
        this.bloodStats.readNBT(nbt);
        this.eyeType = nbt.func_74762_e("eye_type");
        this.fangType = nbt.func_74762_e("fang_type");
        this.actionHandler.loadFromNbt(nbt);
        this.skillHandler.loadFromNbt(nbt);
        VampirismMod.log.t("Loaded from nbt", new Object[0]);
    }

    @Override
    public int onBite(IVampire biter) {
        float perc;
        float f = perc = biter instanceof EntityPlayer ? 1.0f : 0.4f;
        if (this.getLevel() == 0) {
            int amt = this.player.func_71024_bL().func_75116_a();
            int sucked = (int)((float)amt * perc);
            this.player.func_71024_bL().func_75114_a(amt - sucked);
            this.player.func_71020_j(1000.0f);
            if (!this.player.func_70644_a(ModPotions.sanguinare) && (!(biter instanceof EntityPlayer) || Permissions.canPlayerTurnPlayer((EntityPlayer)biter)) && Helper.canBecomeVampire(this.player)) {
                PotionSanguinare.addRandom((EntityLivingBase)this.player, true);
            }
            return sucked;
        }
        int amt = this.getBloodStats().getBloodLevel();
        int sucked = (int)((float)amt * perc);
        this.getBloodStats().consumeBlood(amt - sucked);
        this.sync(this.getBloodStats().writeUpdate(new NBTTagCompound()), false);
        return sucked;
    }

    @Override
    public void onChangedDimension(int from, int to) {
    }

    @Override
    public void onDeath(DamageSource src) {
        this.actionHandler.deactivateAllActions();
        this.wasDead = true;
    }

    @Override
    public boolean onEntityAttacked(DamageSource src, float amt) {
        if (this.isPlayerSleeping()) {
            this.wakeUpPlayer(true, true, false);
        }
        return false;
    }

    @Override
    public void onJoinWorld() {
        if (this.getLevel() > 0) {
            this.actionHandler.onActionsReactivated();
            this.ticksInSun = 0;
            if (this.wasDead) {
                if (Loader.isModLoaded((String)"sponge")) {
                    int level = this.getLevel();
                    this.onLevelChanged(level, level);
                }
                this.player.func_70690_d(new PotionEffect(ModPotions.sunscreen, 400, 4));
                this.player.func_70606_j(this.player.func_110138_aP());
                this.bloodStats.getClass();
                this.bloodStats.setBloodLevel(20);
            }
        }
    }

    @Override
    public void onLevelChanged(int newLevel, int oldLevel) {
        if (!this.isRemote()) {
            this.checkAttributes(VReference.bloodExhaustion);
            LevelAttributeModifier.applyModifier(this.player, SharedMonsterAttributes.field_111263_d, "Vampire", this.getLevel(), Balance.vp.SPEED_LCAP, Balance.vp.SPEED_MAX_MOD, Balance.vp.SPEED_TYPE, 2, false);
            LevelAttributeModifier.applyModifier(this.player, SharedMonsterAttributes.field_111264_e, "Vampire", this.getLevel(), Balance.vp.STRENGTH_LCAP, Balance.vp.STRENGTH_MAX_MOD, Balance.vp.STRENGTH_TYPE, 2, false);
            LevelAttributeModifier.applyModifier(this.player, SharedMonsterAttributes.field_111267_a, "Vampire", this.getLevel(), Balance.vp.HEALTH_LCAP, Balance.vp.HEALTH_MAX_MOD, Balance.vp.HEALTH_TYPE, 0, true);
            if (this.player.func_110143_aJ() > this.player.func_110138_aP()) {
                this.player.func_70606_j(this.player.func_110138_aP());
            }
            LevelAttributeModifier.applyModifier(this.player, VReference.bloodExhaustion, "Vampire", this.getLevel(), this.getMaxLevel(), Balance.vp.EXAUSTION_MAX_MOD, Balance.vp.EXHAUSTION_TYPE, 2, false);
            if (newLevel > 0) {
                if (this.player instanceof EntityPlayerMP && ((EntityPlayerMP)this.player).field_71135_a != null) {
                    this.player.func_71064_a((StatBase)Achievements.becomingAVampire, 1);
                }
                if (oldLevel == 0) {
                    this.skillHandler.enableRootSkill();
                }
            } else {
                this.actionHandler.resetTimers();
                this.skillHandler.disableAllSkills();
            }
        } else if (oldLevel == 0) {
            if (this.player.func_70644_a(MobEffects.field_76439_r)) {
                this.player.func_184589_d(MobEffects.field_76439_r);
            }
        } else if (newLevel == 0) {
            if (this.player.func_70660_b(MobEffects.field_76439_r) instanceof FakeNightVisionPotionEffect) {
                this.player.func_184589_d(MobEffects.field_76439_r);
            }
            this.actionHandler.resetTimers();
        }
    }

    @Override
    public void onPlayerLoggedIn() {
    }

    @Override
    public void onPlayerLoggedOut() {
    }

    public void onSanguinareFinished() {
        if (Helper.canBecomeVampire(this.player) && !this.isRemote()) {
            FactionPlayerHandler handler = FactionPlayerHandler.get(this.player);
            handler.joinFaction((IPlayableFaction)this.getFaction());
            this.player.func_70690_d(new PotionEffect(MobEffects.field_76429_m, 300));
        }
    }

    @Override
    public void onUpdate() {
        int level = this.getLevel();
        if (level > 0) {
            if (this.player.field_70173_aa % 8 == 1) {
                this.isGettingSundamage(true);
            }
            if (this.player.field_70173_aa % 40 == 6) {
                this.isGettingGarlicDamage(true);
            }
        } else {
            this.sundamage_cache = false;
            this.garlic_cache = EnumGarlicStrength.NONE;
        }
        if (this.isPlayerSleeping()) {
            this.player.field_70145_X = true;
            this.player.field_70179_y = 0.0;
            this.player.field_70181_x = 0.0;
            this.player.field_70159_w = 0.0;
            ++this.sleepTimer;
            if (this.sleepTimer > 100) {
                this.sleepTimer = 100;
            }
            if (!this.player.field_70170_p.field_72995_K) {
                IBlockState state = this.player.field_70170_p.func_180495_p(this.player.field_71081_bT);
                boolean bed = state.func_177230_c().isBed(state, (IBlockAccess)this.player.field_70170_p, this.player.field_71081_bT, (Entity)this.player);
                if (!bed) {
                    this.player.func_70999_a(true, true, false);
                } else if (!this.player.field_70170_p.func_72935_r()) {
                    this.player.func_70999_a(false, true, true);
                }
            }
        } else if (this.sleepTimer > 0) {
            ++this.sleepTimer;
            if (this.sleepTimer >= 110) {
                this.sleepTimer = 0;
            }
        }
        if (this.activatedVision != null) {
            this.activatedVision.onUpdate(this);
        }
        if (!this.isRemote()) {
            if (level > 0) {
                boolean sync = false;
                boolean syncToAll = false;
                NBTTagCompound syncPacket = new NBTTagCompound();
                if (this.biteCooldown > 0) {
                    --this.biteCooldown;
                }
                if (this.isGettingSundamage()) {
                    this.handleSunDamage();
                } else if (this.ticksInSun > 0) {
                    --this.ticksInSun;
                }
                if (this.isGettingGarlicDamage() != EnumGarlicStrength.NONE) {
                    this.handleGarlicDamage();
                }
                if (this.actionHandler.updateActions()) {
                    sync = true;
                    syncToAll = true;
                    this.actionHandler.writeUpdateForClient(syncPacket);
                }
                if (this.skillHandler.isDirty()) {
                    sync = true;
                    this.skillHandler.writeUpdateForClient(syncPacket);
                }
                if (sync) {
                    this.sync(syncPacket, syncToAll);
                }
            } else {
                this.ticksInSun = 0;
            }
        } else if (level > 0) {
            this.actionHandler.updateActions();
            if (this.isGettingSundamage()) {
                this.handleSunDamage();
            } else if (this.ticksInSun > 0) {
                --this.ticksInSun;
            }
        } else {
            this.ticksInSun = 0;
        }
    }

    @Override
    public void onUpdatePlayer(TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.END) {
            if (this.getLevel() > 0 && !this.player.field_70170_p.field_72995_K && this.bloodStats.onUpdate()) {
                this.sync(this.bloodStats.writeUpdate(new NBTTagCompound()), false);
            }
            if (this.getSpecialAttributes().bat) {
                BatVampireAction.updatePlayerBatSize(this.player);
            }
            if (this.sleepingInCoffin) {
                this.setEntitySize(0.2f, 0.2f);
            }
        }
    }

    public void saveData(NBTTagCompound nbt) {
        this.bloodStats.writeNBT(nbt);
        nbt.func_74768_a("eye_type", this.eyeType);
        nbt.func_74768_a("fang_type", this.fangType);
        this.actionHandler.saveToNbt(nbt);
        this.skillHandler.saveToNbt(nbt);
    }

    public boolean setEntitySize(float width, float height) {
        try {
            Method mSetSize = ReflectionHelper.findMethod(Entity.class, (Object)this.player, (String[])new String[]{"setSize", "func_70105_a"}, (Class[])new Class[]{Float.TYPE, Float.TYPE});
            mSetSize.invoke((Object)this.player, Float.valueOf(width), Float.valueOf(height));
            return true;
        }
        catch (Exception e) {
            VampirismMod.log.e(TAG, e, "Could not change players size! ", new Object[0]);
            return false;
        }
    }

    public boolean setEyeType(int eyeType) {
        if (eyeType >= 7 || eyeType < 0) {
            return false;
        }
        if (eyeType != this.eyeType) {
            this.eyeType = eyeType;
            if (!this.isRemote()) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("eye_type", eyeType);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public boolean setFangType(int fangType) {
        if (fangType >= 6 || fangType < 0) {
            return false;
        }
        if (fangType != this.fangType) {
            this.fangType = fangType;
            if (!this.isRemote()) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74768_a("fang_type", fangType);
                this.sync(nbt, true);
            }
        }
        return true;
    }

    public void switchVision() {
        int id = -1;
        if (this.activatedVision != null) {
            id = this.unlockedVisions.indexOf(this.activatedVision);
        }
        if (++id > this.unlockedVisions.size() - 1) {
            id = -1;
        }
        this.activateVision(id == -1 ? null : this.unlockedVisions.get(id));
    }

    @Override
    public EntityPlayer.SleepResult trySleep(BlockPos bedLocation) {
        if (!this.player.field_70170_p.field_72995_K) {
            if (this.player.func_70608_bn() || !this.player.func_70089_S()) {
                return EntityPlayer.SleepResult.OTHER_PROBLEM;
            }
            if (!this.player.field_70170_p.field_73011_w.func_76569_d()) {
                return EntityPlayer.SleepResult.NOT_POSSIBLE_HERE;
            }
            if (!this.player.field_70170_p.func_72935_r()) {
                return EntityPlayer.SleepResult.NOT_POSSIBLE_NOW;
            }
            if (Math.abs(this.player.field_70165_t - (double)bedLocation.func_177958_n()) > 3.0 || Math.abs(this.player.field_70163_u - (double)bedLocation.func_177956_o()) > 2.0 || Math.abs(this.player.field_70161_v - (double)bedLocation.func_177952_p()) > 3.0) {
                return EntityPlayer.SleepResult.TOO_FAR_AWAY;
            }
            double d0 = 8.0;
            double d1 = 5.0;
            List list = this.player.field_70170_p.func_72872_a(EntityMob.class, new AxisAlignedBB((double)bedLocation.func_177958_n() - d0, (double)bedLocation.func_177956_o() - d1, (double)bedLocation.func_177952_p() - d0, (double)bedLocation.func_177958_n() + d0, (double)bedLocation.func_177956_o() + d1, (double)bedLocation.func_177952_p() + d0));
            if (!list.isEmpty()) {
                return EntityPlayer.SleepResult.NOT_SAFE;
            }
        }
        if (this.player.func_184218_aH()) {
            this.player.func_184210_p();
        }
        if (!this.setEntitySize(0.2f, 0.2f)) {
            return EntityPlayer.SleepResult.OTHER_PROBLEM;
        }
        IBlockState state = null;
        if (this.player.field_70170_p.func_175667_e(bedLocation)) {
            state = this.player.field_70170_p.func_180495_p(bedLocation);
        }
        if (state != null && state.func_177230_c().isBed(state, (IBlockAccess)this.player.field_70170_p, bedLocation, (Entity)this.player)) {
            EnumFacing enumfacing = state.func_177230_c().getBedDirection(state, (IBlockAccess)this.player.field_70170_p, bedLocation);
            float f = 0.5f;
            float f1 = 0.5f;
            switch (enumfacing) {
                case SOUTH: {
                    f1 = 0.9f;
                    break;
                }
                case NORTH: {
                    f1 = 0.1f;
                    break;
                }
                case WEST: {
                    f = 0.1f;
                    break;
                }
                case EAST: {
                    f = 0.9f;
                    break;
                }
            }
            try {
                Method mSetSize = ReflectionHelper.findMethod(EntityPlayer.class, (Object)this.player, (String[])new String[]{"setRenderOffsetForSleep", "func_175139_a"}, (Class[])new Class[]{EnumFacing.class});
                mSetSize.invoke((Object)this.player, enumfacing);
            }
            catch (Exception e) {
                VampirismMod.log.e(TAG, e, "Could set render offset for sleep! ", new Object[0]);
                return EntityPlayer.SleepResult.OTHER_PROBLEM;
            }
            this.player.func_70107_b((double)((float)bedLocation.func_177958_n() + f), (double)((float)bedLocation.func_177956_o() + 0.6875f), (double)((float)bedLocation.func_177952_p() + f1));
        } else {
            this.player.func_70107_b((double)((float)bedLocation.func_177958_n() + 0.5f), (double)((float)bedLocation.func_177956_o() + 0.6875f), (double)((float)bedLocation.func_177952_p() + 0.5f));
        }
        this.sleepTimer = 0;
        this.sleepingInCoffin = true;
        this.player.field_70145_X = true;
        this.player.field_71081_bT = bedLocation;
        this.player.field_70181_x = 0.0;
        this.player.field_70179_y = 0.0;
        this.player.field_70159_w = 0.0;
        if (!this.player.field_70170_p.field_72995_K) {
            DaySleepHelper.updateAllPlayersSleeping(this.player.field_70170_p);
        }
        if (this.player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)this.player;
            SPacketUseBed packet = new SPacketUseBed(this.player, bedLocation);
            playerMP.func_71121_q().func_73039_n().func_151247_a((Entity)playerMP, (Packet)packet);
            playerMP.field_71135_a.func_147364_a(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, this.player.field_70177_z, this.player.field_70125_A);
            playerMP.field_71135_a.func_147359_a((Packet)packet);
        }
        return EntityPlayer.SleepResult.OK;
    }

    @Override
    public void unUnlockVision(@Nonnull IVampireVision vision) {
        if (vision.equals(this.activatedVision)) {
            this.activateVision(null);
        }
        this.unlockedVisions.remove(vision);
    }

    @Override
    public void unlockVision(@Nonnull IVampireVision vision) {
        if (((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getIdOfVision(vision) == -1) {
            throw new IllegalArgumentException("You have to register the vision first: " + vision);
        }
        this.unlockedVisions.add(vision);
    }

    @Override
    public void wakeUpPlayer(boolean immediately, boolean updateWorldFlag, boolean setSpawn) {
        VampirismMod.log.d(TAG, "Waking up player", new Object[0]);
        if (this.isPlayerSleeping() && this.player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.player).func_71121_q().func_73039_n().func_151248_b((Entity)this.player, (Packet)new SPacketAnimation((Entity)this.player, 2));
        }
        this.player.func_70999_a(immediately, false, setSpawn);
        this.sleepingInCoffin = false;
        this.player.field_70145_X = true;
        if (updateWorldFlag) {
            DaySleepHelper.updateAllPlayersSleeping(this.player.field_70170_p);
        }
        if (this.player instanceof EntityPlayerMP && ((EntityPlayerMP)this.player).field_71135_a != null) {
            ((EntityPlayerMP)this.player).field_71135_a.func_147364_a(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, this.player.field_70177_z, this.player.field_70125_A);
        }
    }

    protected void checkAttributes(IAttribute ... attributes) {
        for (IAttribute attribute : attributes) {
            if (this.player.func_110148_a(attribute) != null) continue;
            this.applyEntityAttributes();
            return;
        }
    }

    @Override
    protected VampirismPlayer copyFromPlayer(EntityPlayer old) {
        VampirePlayer oldVampire = VampirePlayer.get(old);
        NBTTagCompound nbt = new NBTTagCompound();
        oldVampire.saveData(nbt);
        this.loadData(nbt);
        this.wasDead = oldVampire.wasDead;
        return oldVampire;
    }

    @Override
    protected int getMaxLevel() {
        return 14;
    }

    @Override
    protected void loadUpdate(NBTTagCompound nbt) {
        if (nbt.func_74764_b("eye_type")) {
            this.setEyeType(nbt.func_74762_e("eye_type"));
        }
        if (nbt.func_74764_b("fang_type")) {
            this.setFangType(nbt.func_74762_e("fang_type"));
        }
        if (nbt.func_74764_b("bite_particle")) {
            this.spawnBiteParticle(nbt.func_74762_e("bite_particle"));
        }
        this.bloodStats.loadUpdate(nbt);
        this.actionHandler.readUpdateFromServer(nbt);
        this.skillHandler.readUpdateFromServer(nbt);
        if (nbt.func_74764_b("vision")) {
            IVampireVision vision;
            int id = nbt.func_74762_e("vision");
            if (id == -1) {
                vision = null;
            } else {
                vision = ((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getVisionOfId(id);
                if (vision == null) {
                    VampirismMod.log.w(TAG, "Failed to find vision with id %d", id);
                }
            }
            this.activateVision(vision);
        }
    }

    @Override
    protected void writeFullUpdate(NBTTagCompound nbt) {
        nbt.func_74768_a("eye_type", this.getEyeType());
        nbt.func_74768_a("fang_type", this.getFangType());
        this.bloodStats.writeUpdate(nbt);
        this.actionHandler.writeUpdateForClient(nbt);
        this.skillHandler.writeUpdateForClient(nbt);
        nbt.func_74768_a("vision", this.activatedVision == null ? -1 : ((GeneralRegistryImpl)VampirismAPI.vampireVisionRegistry()).getIdOfVision(this.activatedVision));
    }

    private void applyEntityAttributes() {
        if (this.player.func_110140_aT().func_111151_a(VReference.sunDamage) == null) {
            this.player.func_110140_aT().func_111150_b(VReference.sunDamage).func_111128_a(Balance.vp.SUNDAMAGE_DAMAGE);
        }
        if (this.player.func_110140_aT().func_111151_a(VReference.bloodExhaustion) == null) {
            this.player.func_110140_aT().func_111150_b(VReference.bloodExhaustion).func_111128_a(Balance.vp.BLOOD_EXHAUSTION_BASIC_MOD);
        }
        if (this.player.func_110140_aT().func_111151_a(VReference.biteDamage) == null) {
            this.player.func_110140_aT().func_111150_b(VReference.biteDamage).func_111128_a((double)Balance.vp.BITE_DMG);
        }
        if (this.player.func_110140_aT().func_111150_b(VReference.garlicDamage) == null) {
            this.player.func_110140_aT().func_111150_b(VReference.garlicDamage).func_111128_a(Balance.vp.GARLIC_DAMAGE);
        }
    }

    private void biteEntity(EntityLivingBase entity) {
        if (this.isRemote()) {
            return;
        }
        if (this.getLevel() == 0) {
            return;
        }
        if (this.biteCooldown > 0) {
            return;
        }
        int blood = 0;
        float saturationMod = 1.0f;
        IVampirePlayer.BITE_TYPE type = this.determineBiteType(entity);
        if (type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_CREATURE) {
            blood = ExtendedCreature.get((EntityCreature)entity).onBite(this);
            saturationMod = ExtendedCreature.get((EntityCreature)entity).getBloodSaturation();
        } else if (type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_PLAYER || type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_HUNTER_PLAYER) {
            blood = VampirePlayer.get((EntityPlayer)entity).onBite(this);
            saturationMod = VampirePlayer.get((EntityPlayer)entity).getBloodSaturation();
            if (type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_HUNTER_PLAYER) {
                this.player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 15, 2));
            }
        } else if (type == IVampirePlayer.BITE_TYPE.SUCK_BLOOD) {
            blood = ((IBiteableEntity)entity).onBite(this);
            saturationMod = ((IBiteableEntity)entity).getBloodSaturation();
        } else if (type == IVampirePlayer.BITE_TYPE.ATTACK || type == IVampirePlayer.BITE_TYPE.ATTACK_HUNTER) {
            this.checkAttributes(VReference.biteDamage);
            float damage = this.getSpecialAttributes().bat ? 0.1f : (float)this.player.func_110148_a(VReference.biteDamage).func_111126_e();
            entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)this.player), damage);
            if (entity.func_70662_br() && this.player.func_70681_au().nextInt(4) == 0) {
                this.player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 60));
            } else if (type == IVampirePlayer.BITE_TYPE.ATTACK_HUNTER && entity instanceof EntityPlayer && ItemHunterCoat.isFullyEquipped((EntityPlayer)entity)) {
                this.player.func_70097_a(DamageSource.func_92087_a((Entity)entity), damage);
            }
            if (this.specialAttributes.poisonous_bite) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76436_u, (int)((float)(Balance.vps.POISONOUS_BITE_DURATION * 20) * (this.getSpecialAttributes().bat ? 0.2f : 1.0f)), 1));
            }
        } else if (type == IVampirePlayer.BITE_TYPE.NONE) {
            return;
        }
        this.biteCooldown = Balance.vp.BITE_COOLDOWN;
        if (blood > 0) {
            this.drinkBlood(blood, saturationMod);
            this.player.func_71064_a((StatBase)Achievements.suckingBlood, 1);
            NBTTagCompound updatePacket = this.bloodStats.writeUpdate(new NBTTagCompound());
            updatePacket.func_74768_a("bite_particle", entity.func_145782_y());
            this.sync(updatePacket, true);
        }
    }

    private void handleGarlicDamage() {
        VReference.garlicDamage.func_111110_b();
    }

    private void handleSpareBlood(int amt) {
        BloodHelper.fillBloodIntoInventory(this.player, amt * 100);
    }

    private void handleSunDamage() {
        int sunscreen;
        PotionEffect potionEffect = this.player.func_70660_b(ModPotions.sunscreen);
        int n = sunscreen = potionEffect == null ? -1 : potionEffect.func_76458_c();
        if (this.ticksInSun < 100) {
            ++this.ticksInSun;
        }
        if (sunscreen >= 5 && this.ticksInSun > 50) {
            this.ticksInSun = 50;
        }
        if (this.player.field_71075_bZ.field_75098_d || this.player.field_71075_bZ.field_75102_a) {
            return;
        }
        if (Balance.vp.SUNDAMAGE_NAUSEA && this.getLevel() >= Balance.vp.SUNDAMAGE_NAUSEA_MINLEVEL && this.player.field_70173_aa % 300 == 1 && this.ticksInSun > 50 && sunscreen == -1) {
            this.player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 180));
        }
        if (this.getLevel() >= Balance.vp.SUNDAMAGE_WEAKNESS_MINLEVEL && this.player.field_70173_aa % 150 == 3 && sunscreen < 5) {
            this.player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 152, 0));
        }
        if (this.getLevel() >= Balance.vp.SUNDAMAGE_MINLEVEL && this.ticksInSun >= 100 && this.player.field_70173_aa % 40 == 5) {
            this.checkAttributes(VReference.sunDamage);
            float damage = (float)this.player.func_110148_a(VReference.sunDamage).func_111126_e();
            if (damage > 0.0f) {
                this.player.func_70097_a(VReference.SUNDAMAGE, damage);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnBiteParticle(int entityId) {
        Entity entity = this.player.field_70170_p.func_73045_a(entityId);
        if (entity != null) {
            UtilLib.spawnParticles(this.player.field_70170_p, EnumParticleTypes.CRIT_MAGIC, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, this.player.field_70165_t - entity.field_70165_t, this.player.field_70163_u - entity.field_70163_u, this.player.field_70161_v - entity.field_70161_v, 10, new int[0]);
        }
        for (int j = 0; j < 16; ++j) {
            Vec3d vec3 = new Vec3d(((double)this.player.func_70681_au().nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.func_178789_a(-this.player.field_70125_A * (float)Math.PI / 180.0f);
            vec3 = vec3.func_178785_b(-this.player.field_70177_z * (float)Math.PI / 180.0f);
            double d0 = (double)(-this.player.func_70681_au().nextFloat()) * 0.6 - 0.3;
            Vec3d vec31 = new Vec3d(((double)this.player.func_70681_au().nextFloat() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.func_178789_a(-this.player.field_70125_A * (float)Math.PI / 180.0f);
            vec31 = vec31.func_178785_b(-this.player.field_70177_z * (float)Math.PI / 180.0f);
            vec31 = vec31.func_72441_c(this.player.field_70165_t, this.player.field_70163_u + (double)this.player.func_70047_e(), this.player.field_70161_v);
            this.player.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, vec31.field_72450_a, vec31.field_72448_b, vec31.field_72449_c, vec3.field_72450_a, vec3.field_72448_b + 0.05, vec3.field_72449_c, new int[]{Item.func_150891_b((Item)Items.field_151034_e)});
        }
        this.player.field_70170_p.func_184134_a(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, ModSounds.player_bite, SoundCategory.PLAYERS, 1.0f, 1.0f, false);
    }

    private static class Storage
    implements Capability.IStorage<IVampirePlayer> {
        private Storage() {
        }

        public void readNBT(Capability<IVampirePlayer> capability, IVampirePlayer instance, EnumFacing side, NBTBase nbt) {
            ((VampirePlayer)instance).loadData((NBTTagCompound)nbt);
        }

        public NBTBase writeNBT(Capability<IVampirePlayer> capability, IVampirePlayer instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            ((VampirePlayer)instance).saveData(nbt);
            return nbt;
        }
    }
}

