/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillRegistry;
import de.teamlapen.vampirism.api.entity.player.skills.SkillNode;
import de.teamlapen.vampirism.player.skills.VampirismSkill;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SkillRegistry
implements ISkillRegistry {
    private final Map<IPlayableFaction, SkillNode> rootNodes = new HashMap<IPlayableFaction, SkillNode>();
    private final Map<IPlayableFaction, BiMap<String, ISkill>> skillMap = new HashMap<IPlayableFaction, BiMap<String, ISkill>>();
    private final Map<IPlayableFaction, Integer[]> skillNodeSizeMap = new HashMap<IPlayableFaction, Integer[]>();

    public void addSkills(IPlayableFaction faction, List list) {
        for (String s : this.skillMap.get(faction).keySet()) {
            list.add(s);
        }
    }

    public void finish() {
        for (final IPlayableFaction faction : VampirismAPI.factionRegistry().getPlayableFactions()) {
            SkillNode rootNode = this.rootNodes.get(faction);
            if (rootNode == null) {
                rootNode = new SkillNode(faction, (ISkill)new VampirismSkill(){

                    @Override
                    public String getID() {
                        return faction.getKey() + "_dummy";
                    }

                    @Override
                    public int getMinU() {
                        return 0;
                    }

                    @Override
                    public int getMinV() {
                        return 0;
                    }

                    @Override
                    public String getUnlocalizedName() {
                        return faction.getUnlocalizedName();
                    }
                });
                this.rootNodes.put(faction, rootNode);
            }
            if (!this.skillMap.containsKey(faction)) {
                this.skillMap.put(faction, (BiMap<String, ISkill>)HashBiMap.create());
            }
            if (!FMLCommonHandler.instance().getSide().isClient()) continue;
            this.skillNodeSizeMap.put(faction, this.createDisplayInfo(rootNode));
            this.setRenderPos(rootNode, 0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Integer[] getDisplayInfo(IPlayableFaction faction) {
        return this.skillNodeSizeMap.get(faction);
    }

    @Override
    public String getID(IPlayableFaction faction, ISkill skill) {
        return (String)this.skillMap.get(faction).inverse().get((Object)skill);
    }

    @Override
    public SkillNode getRootSkillNode(IPlayableFaction faction) {
        return this.rootNodes.get(faction);
    }

    @Override
    public ISkill getSkill(IPlayableFaction faction, String id) {
        return (ISkill)this.skillMap.get(faction).get((Object)id);
    }

    public void printSkills(IPlayableFaction faction, ICommandSender sender) {
        for (Map.Entry e : this.skillMap.get(faction).entrySet()) {
            sender.func_145747_a((ITextComponent)new TextComponentString("ID: " + e.getKey() + " Skill: " + e.getValue()));
        }
    }

    @Override
    public void registerNode(SkillNode node) {
        ISkill[] skills;
        HashBiMap map = this.skillMap.get(node.getFaction());
        if (map == null) {
            map = HashBiMap.create();
            this.skillMap.put(node.getFaction(), (BiMap<String, ISkill>)map);
        }
        for (ISkill skill : skills = node.getElements()) {
            if (map.put((Object)skill.getID(), (Object)skill) == null) continue;
            throw new IllegalArgumentException("There already is a skill registered for " + skill.getID() + " ");
        }
    }

    @Override
    public SkillNode setRootSkill(IPlayableFaction faction, ISkill skill) {
        SkillNode s = new SkillNode(faction, skill);
        this.rootNodes.put(faction, s);
        return s;
    }

    private int calculateEndPoints(SkillNode start) {
        if (start.getChildren().size() == 0) {
            return 1;
        }
        int count = 0;
        for (SkillNode node : start.getChildren()) {
            count += this.calculateEndPoints(node);
        }
        return count;
    }

    private int calculateMaxSkillDepth(SkillNode start) {
        int max = start.getDepth();
        for (SkillNode node : start.getChildren()) {
            int n = this.calculateMaxSkillDepth(node);
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    private int calculateMaxSkillsPerNode(SkillNode start) {
        int max = start.getElements().length;
        for (SkillNode node : start.getChildren()) {
            int n = this.calculateMaxSkillsPerNode(node);
            if (n <= max) continue;
            max = n;
        }
        return max;
    }

    private Integer[] createDisplayInfo(SkillNode root) {
        Integer[] info = new Integer[]{this.calculateEndPoints(root), this.calculateMaxSkillsPerNode(root), this.calculateMaxSkillDepth(root) + 1};
        return info;
    }

    private void setRenderPos(SkillNode base, int column) {
        int i;
        int left = -(base.getElements().length * 2 - 1) / 2;
        for (ISkill skill : base.getElements()) {
            skill.setRenderPos(base.getDepth() * 2, column + left);
            left += 2;
        }
        int[] widths = new int[base.getChildren().size()];
        int total = 0;
        for (i = 0; i < widths.length; ++i) {
            SkillNode node = base.getChildren().get(i);
            widths[i] = this.calculateMaxSkillsPerNode(node) * this.calculateEndPoints(node) * 2;
            total += widths[i];
        }
        left = -total / 2;
        for (i = 0; i < widths.length; ++i) {
            this.setRenderPos(base.getChildren().get(i), column + left + widths[i] / 2);
            left += widths[i];
        }
    }
}

