/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player.skills;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.entity.player.skills.SkillNode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class SkillHandler<T extends IFactionPlayer>
implements ISkillHandler<T> {
    private static final String TAG = "SkillHandler";
    private final ArrayList<ISkill> enabledSkills = new ArrayList();
    private final T player;
    private boolean dirty = false;

    public SkillHandler(T player) {
        this.player = player;
    }

    @Override
    public ISkillHandler.Result canSkillBeEnabled(ISkill skill) {
        if (this.isSkillEnabled(skill)) {
            return ISkillHandler.Result.ALREADY_ENABLED;
        }
        SkillNode node = VampirismAPI.skillRegistry().getRootSkillNode(this.player.getFaction());
        if ((node = this.findSkillNode(node, skill)) != null) {
            if (node.isRoot() || this.isNodeEnabled(node.getParent())) {
                if (this.getLeftSkillPoints() > 0) {
                    return this.isNodeEnabled(node) ? ISkillHandler.Result.OTHER_NODE_SKILL : ISkillHandler.Result.OK;
                }
                return ISkillHandler.Result.NO_POINTS;
            }
            return ISkillHandler.Result.PARENT_NOT_ENABLED;
        }
        VampirismMod.log.w(TAG, "Node for skill %s could not be found", skill);
        return ISkillHandler.Result.NOT_FOUND;
    }

    public void disableAllSkills() {
        for (ISkill skill : this.enabledSkills) {
            skill.onDisable(this.player);
        }
        this.enabledSkills.clear();
        this.dirty = true;
    }

    @Override
    public void disableSkill(ISkill skill) {
        if (this.enabledSkills.remove(skill)) {
            skill.onDisable(this.player);
            this.dirty = true;
        }
    }

    public void enableRootSkill() {
        this.enableSkill(VampirismAPI.skillRegistry().getRootSkillNode(this.player.getFaction()).getElements()[0]);
    }

    @Override
    public void enableSkill(ISkill skill) {
        if (!this.enabledSkills.contains(skill)) {
            skill.onEnable(this.player);
            this.enabledSkills.add(skill);
            this.dirty = true;
        }
    }

    public SkillNode findSkillNode(SkillNode base, ISkill skill) {
        for (ISkill s : base.getElements()) {
            if (!s.equals(skill)) continue;
            return base;
        }
        for (SkillNode child : base.getChildren()) {
            SkillNode node = this.findSkillNode(child, skill);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public int getLeftSkillPoints() {
        return this.player.getLevel() - this.enabledSkills.size();
    }

    public IFactionPlayer<T> getPlayer() {
        return this.player;
    }

    public SkillNode getRootNode() {
        return VampirismAPI.skillRegistry().getRootSkillNode(this.player.getFaction());
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isNodeEnabled(SkillNode node) {
        for (ISkill s : this.enabledSkills) {
            if (!node.containsSkill(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSkillEnabled(ISkill skill) {
        return this.enabledSkills.contains(skill);
    }

    public void loadFromNbt(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("skills")) {
            return;
        }
        for (String id : nbt.func_74775_l("skills").func_150296_c()) {
            ISkill skill = VampirismAPI.skillRegistry().getSkill(this.player.getFaction(), id);
            if (skill == null) {
                VampirismMod.log.w(TAG, "Skill %s does not exist anymore", id);
                continue;
            }
            this.enableSkill(skill);
        }
    }

    public void readUpdateFromServer(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("skills")) {
            return;
        }
        List old = (List)this.enabledSkills.clone();
        for (String id : nbt.func_74775_l("skills").func_150296_c()) {
            ISkill skill = VampirismAPI.skillRegistry().getSkill(this.player.getFaction(), id);
            if (skill == null) {
                VampirismMod.log.e(TAG, "Skill %s does not exist on client!!!", id);
                continue;
            }
            if (old.contains(skill)) {
                old.remove(skill);
                continue;
            }
            this.enableSkill(skill);
        }
        for (ISkill skill : old) {
            this.disableSkill(skill);
        }
    }

    @Override
    public void resetSkills() {
        this.disableAllSkills();
        this.enableRootSkill();
    }

    public void saveToNbt(NBTTagCompound nbt) {
        NBTTagCompound skills = new NBTTagCompound();
        for (ISkill skill : this.enabledSkills) {
            skills.func_74757_a(skill.getID(), true);
        }
        nbt.func_74782_a("skills", (NBTBase)skills);
    }

    public void writeUpdateForClient(NBTTagCompound nbt) {
        NBTTagCompound skills = new NBTTagCompound();
        for (ISkill skill : this.enabledSkills) {
            skills.func_74757_a(skill.getID(), true);
        }
        nbt.func_74782_a("skills", (NBTBase)skills);
        this.dirty = false;
    }
}

