/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.player;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.blocks.BlockAltarInspiration;
import de.teamlapen.vampirism.blocks.BlockBloodContainer;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.util.REFERENCE;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModPlayerEventHandler {
    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityPlayer) {
            event.addCapability(REFERENCE.FACTION_PLAYER_HANDLER_KEY, FactionPlayerHandler.createNewCapability((EntityPlayer)event.getEntity()));
            event.addCapability(REFERENCE.VAMPIRE_PLAYER_KEY, VampirePlayer.createNewCapability((EntityPlayer)event.getEntity()));
            event.addCapability(REFERENCE.HUNTER_PLAYER_KEY, HunterPlayer.createNewCapability((EntityPlayer)event.getEntity()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackEntity(AttackEntityEvent event) {
        if (VampirePlayer.get(event.getEntityPlayer()).getActionHandler().isActionActive(VampireActions.batAction)) {
            event.setCanceled(true);
        }
        if (!this.checkItemUsePerm(event.getEntityPlayer().func_184614_ca(), event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockPlaced(BlockEvent.PlaceEvent event) {
        try {
            if (VampirePlayer.get(event.getPlayer()).getActionHandler().isActionActive(VampireActions.batAction)) {
                event.setCanceled(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (VampirePlayer.get(event.getEntityPlayer()).getActionHandler().isActionActive(VampireActions.batAction)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onItemRightClick(PlayerInteractEvent.RightClickItem event) {
        if (!this.checkItemUsePerm(event.getItemStack(), event.getEntityPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity() instanceof EntityPlayer && VampirePlayer.get((EntityPlayer)event.getEntityLiving()).getActionHandler().isActionActive(VampireActions.batAction)) {
            event.setCanceled(true);
        }
        if (event.getEntity() instanceof EntityPlayer && !this.checkItemUsePerm(event.getItem(), (EntityPlayer)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !FactionPlayerHandler.get((EntityPlayer)event.getEntity()).onEntityAttacked(event.getSource(), event.getAmount())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingFall(LivingFallEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            event.setDistance(event.getDistance() - (float)VampirePlayer.get((EntityPlayer)event.getEntity()).getSpecialAttributes().getJumpBoost());
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            event.getEntity().field_70181_x += (double)((float)VampirePlayer.get((EntityPlayer)event.getEntity()).getSpecialAttributes().getJumpBoost() * 0.1f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.getEntityPlayer().field_70170_p.field_72995_K) {
            FactionPlayerHandler.get(event.getEntityPlayer()).copyFrom(event.getOriginal());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (Configs.autoConvertGlasBottles && event.getWorld().func_175723_af().func_177746_a(event.getPos()) && event.getItemStack() != null && event.getItemStack().func_77973_b() != null && event.getItemStack().func_77973_b().equals(Items.field_151069_bo) && event.getItemStack().field_77994_a == 1) {
            Block block = event.getWorld().func_180495_p(event.getPos()).func_177230_c();
            boolean flag = false;
            if (block instanceof IFluidTank) {
                VampirismMod.log.d("Fluid", "Found block that is instanceof IFluidTank %s", block.getClass());
                if (ModFluids.blood.equals(((IFluidTank)block).getFluid())) {
                    flag = true;
                }
            } else if (block instanceof ITileEntityProvider) {
                IFluidHandler fluidHandler;
                FluidStack drain;
                TileEntity entity = event.getWorld().func_175625_s(event.getPos());
                if (entity != null && entity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, event.getFace()) && (drain = (fluidHandler = (IFluidHandler)entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, event.getFace())).drain(new FluidStack(ModFluids.blood, 1000), false)) != null && drain.amount >= 100) {
                    flag = true;
                }
                if (flag && block instanceof BlockAltarInspiration) {
                    flag = false;
                }
                if (flag && block instanceof BlockBloodContainer) {
                    flag = event.getEntityPlayer().func_70093_af();
                }
            }
            if (flag) {
                event.getItemStack().deserializeNBT(new ItemStack((Item)ModItems.bloodBottle).serializeNBT());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerName(PlayerEvent.NameFormat event) {
        if (event.getEntityPlayer() != null && !Configs.disable_factionDisplayChat) {
            IFaction f;
            IFactionPlayer fp = FactionPlayerHandler.get(event.getEntityPlayer()).getCurrentFactionPlayer();
            IFaction iFaction = f = fp == null ? null : fp.getDisguisedAs();
            if (f != null) {
                event.setDisplayname(f.getChatColor() + event.getDisplayname());
                if (fp instanceof IVampirePlayer && !fp.isDisguised() && ((IVampirePlayer)fp).isVampireLord()) {
                    event.setDisplayname(TextFormatting.RED + "[" + UtilLib.translate("text.vampirism.lord") + "] " + TextFormatting.RESET + event.getDisplayname());
                }
            }
        }
    }

    private boolean checkItemUsePerm(ItemStack stack, EntityPlayer player) {
        boolean message;
        boolean bl = message = !player.field_70170_p.field_72995_K;
        if (stack != null && stack.func_77973_b() instanceof IFactionLevelItem) {
            IFactionPlayer factionPlayer;
            IFactionLevelItem item = (IFactionLevelItem)stack.func_77973_b();
            FactionPlayerHandler handler = FactionPlayerHandler.get(player);
            IPlayableFaction usingFaction = item.getUsingFaction(stack);
            ISkill requiredSkill = item.getRequiredSkill(stack);
            if (usingFaction != null && !handler.isInFaction(usingFaction)) {
                if (message) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.can_only_be_used_by", new Object[]{new TextComponentTranslation(usingFaction.getUnlocalizedNamePlural(), new Object[0])}));
                }
                return false;
            }
            if (handler.getCurrentLevel() < item.getMinLevel(stack)) {
                if (message) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.can_only_be_used_by_level", new Object[]{new TextComponentTranslation(usingFaction == null ? "text.vampirism.all" : usingFaction.getUnlocalizedNamePlural(), new Object[0]), item.getMinLevel(stack)}));
                }
                return false;
            }
            if (!(requiredSkill == null || (factionPlayer = handler.getCurrentFactionPlayer()) != null && factionPlayer.getSkillHandler().isSkillEnabled(requiredSkill))) {
                if (message) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.can_only_be_used_with_skill", new Object[]{new TextComponentTranslation(requiredSkill.getUnlocalizedName(), new Object[0])}));
                }
                return false;
            }
        }
        return true;
    }
}

