/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.jei;

import de.teamlapen.vampirism.client.gui.GuiHunterWeaponTable;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.inventory.HunterWeaponCraftingManager;
import de.teamlapen.vampirism.inventory.HunterWeaponTableContainer;
import de.teamlapen.vampirism.modcompat.jei.HunterWeaponRecipeCategory;
import de.teamlapen.vampirism.modcompat.jei.ShapedHunterWeaponRecipesHandler;
import de.teamlapen.vampirism.modcompat.jei.ShapelessHunterWeaponRecipeHandler;
import javax.annotation.Nonnull;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferRegistry;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class VampirismJEIPlugin
extends BlankModPlugin {
    public static final String HUNTER_WEAPON_RECIPE_UID = "vampirism.hunter_weapon";

    public void register(@Nonnull IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Block)ModBlocks.fluidBlood));
        jeiHelpers.getItemBlacklist().addItemToBlacklist(new ItemStack((Item)ModItems.bloodPotion, 1, Short.MAX_VALUE));
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new HunterWeaponRecipeCategory(guiHelper)});
        registry.addRecipeHandlers(new IRecipeHandler[]{new ShapedHunterWeaponRecipesHandler()});
        registry.addRecipeHandlers(new IRecipeHandler[]{new ShapelessHunterWeaponRecipeHandler()});
        registry.addRecipeClickArea(GuiHunterWeaponTable.class, 113, 46, 28, 23, new String[]{HUNTER_WEAPON_RECIPE_UID});
        registry.addRecipeCategoryCraftingItem(new ItemStack((Block)ModBlocks.weaponTable), new String[]{HUNTER_WEAPON_RECIPE_UID});
        registry.addRecipes(HunterWeaponCraftingManager.getInstance().getRecipes());
        IRecipeTransferRegistry recipeTransferRegistry = registry.getRecipeTransferRegistry();
        recipeTransferRegistry.addRecipeTransferHandler(HunterWeaponTableContainer.class, HUNTER_WEAPON_RECIPE_UID, 1, 16, 17, 36);
        this.registerNBTSubtypes(jeiHelpers.getSubtypeRegistry());
    }

    private void registerNBTSubtypes(ISubtypeRegistry registry) {
        registry.useNbtForSubtypes(new Item[]{ModItems.armorOfSwiftness_boots, ModItems.armorOfSwiftness_chest, ModItems.armorOfSwiftness_helmet, ModItems.armorOfSwiftness_legs});
        registry.useNbtForSubtypes(new Item[]{ModItems.hunterAxe});
        registry.useNbtForSubtypes(new Item[]{ModItems.hunterCoat_boots, ModItems.hunterCoat_chest, ModItems.hunterCoat_helmet, ModItems.hunterCoat_legs});
    }
}

