/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide.pages;

import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.GuiHelper;
import amerifrance.guideapi.gui.GuiBase;
import amerifrance.guideapi.gui.GuiEntry;
import com.google.common.collect.Lists;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.modcompat.guide.GuideBook;
import de.teamlapen.vampirism.modcompat.guide.client.GuiLinkedEntry;
import java.net.URI;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PageHolderWithLinks
implements IPage {
    private final IPage page;
    private final List<ResourceLocation> lateLinks = Lists.newArrayList();
    private final List<Link> links = Lists.newArrayList();
    private long lastLinkClick = 0L;

    public PageHolderWithLinks(IPage page) {
        this.page = page;
    }

    public PageHolderWithLinks addLink(EntryAbstract entry) {
        this.links.add(new EntryLink(entry));
        return this;
    }

    public PageHolderWithLinks addLink(ResourceLocation entry) {
        this.lateLinks.add(entry);
        return this;
    }

    public PageHolderWithLinks addLink(URLLink link) {
        this.links.add(link);
        return this;
    }

    public PageHolderWithLinks addLink(String resourceLocation) {
        this.addLink(new ResourceLocation(resourceLocation));
        return this;
    }

    public boolean canSee(Book book, CategoryAbstract category, EntryAbstract entry, EntityPlayer player, ItemStack bookStack, GuiEntry guiEntry) {
        return this.page.canSee(book, category, entry, player, bookStack, guiEntry);
    }

    public void draw(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRendererObj) {
        this.page.draw(book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
    }

    public void drawExtras(Book book, CategoryAbstract category, EntryAbstract entry, int guiLeft, int guiTop, int mouseX, int mouseY, GuiBase guiBase, FontRenderer fontRendererObj) {
        int ll = guiLeft + guiBase.xSize - 5;
        int y = guiTop + 10;
        for (Link l : this.links) {
            fontRendererObj.func_175063_a(l.getDisplayName(), (float)ll, (float)y, 0xFFFFFF);
            if (l.width == 0) {
                l.width = fontRendererObj.func_78256_a(l.getDisplayName());
            }
            y += 20;
        }
        this.page.drawExtras(book, category, entry, guiLeft, guiTop, mouseX, mouseY, guiBase, fontRendererObj);
    }

    public void onInit(Book book, CategoryAbstract category, EntryAbstract entry, EntityPlayer player, ItemStack bookStack, GuiEntry guiEntry) {
        while (this.lateLinks.size() > 0) {
            ResourceLocation s = this.lateLinks.remove(0);
            EntryAbstract e = GuideBook.getLinkedEntry(s);
            if (e == null) {
                VampirismMod.log.w("GuideBook", "Failed to find linked entry %s", s);
                continue;
            }
            this.addLink(e);
        }
        this.page.onInit(book, category, entry, player, bookStack, guiEntry);
    }

    public void onLeftClicked(Book book, CategoryAbstract category, EntryAbstract entry, int mouseX, int mouseY, EntityPlayer player, GuiEntry guiEntry) {
        long lastClock;
        if (mouseX > guiEntry.guiLeft + guiEntry.xSize && (lastClock = System.currentTimeMillis() / 4L) != this.lastLinkClick) {
            this.lastLinkClick = lastClock;
            for (int i = 0; i < this.links.size(); ++i) {
                if (!GuiHelper.isMouseBetween((int)mouseX, (int)mouseY, (int)(guiEntry.guiLeft + guiEntry.xSize), (int)(guiEntry.guiTop + 10 + 20 * i), (int)this.links.get((int)i).width, (int)20)) continue;
                this.links.get(i).onClicked(book, category, entry, player, guiEntry.bookStack, guiEntry.pageNumber);
                return;
            }
        }
        this.page.onLeftClicked(book, category, entry, mouseX, mouseY, player, guiEntry);
    }

    public void onRightClicked(Book book, CategoryAbstract category, EntryAbstract entry, int mouseX, int mouseY, EntityPlayer player, GuiEntry guiEntry) {
        this.page.onRightClicked(book, category, entry, mouseX, mouseY, player, guiEntry);
    }

    private class EntryLink
    extends Link {
        private final EntryAbstract linkedEntry;

        private EntryLink(EntryAbstract entry) {
            this.linkedEntry = entry;
        }

        @Override
        public String getDisplayName() {
            return this.linkedEntry.getLocalizedName();
        }

        @Override
        public void onClicked(Book book, CategoryAbstract category, EntryAbstract entry, EntityPlayer player, ItemStack bookStack, int page) {
            this.openLinkedEntry(book, category, this.linkedEntry, player, bookStack, entry, page);
        }

        @SideOnly(value=Side.CLIENT)
        private void openLinkedEntry(Book book, CategoryAbstract category, EntryAbstract entry, EntityPlayer player, ItemStack bookStack, EntryAbstract from, int fromPage) {
            GuiLinkedEntry screen = new GuiLinkedEntry(book, category, entry, player, bookStack, from, fromPage);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)screen);
        }
    }

    public static class URLLink
    extends Link {
        private final String name;
        private final URI link;

        public URLLink(String name, URI link) {
            this.name = name;
            this.link = link;
        }

        @Override
        public String getDisplayName() {
            return this.name;
        }

        @Override
        public void onClicked(Book book, CategoryAbstract category, EntryAbstract entry, EntityPlayer player, ItemStack bookStack, int page) {
            try {
                Class<?> oclass = Class.forName("java.awt.Desktop");
                Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                oclass.getMethod("browse", URI.class).invoke(object, this.link);
            }
            catch (Throwable throwable1) {
                Throwable throwable = throwable1.getCause();
                VampirismMod.log.e("GuideBook", throwable, "Couldn't open link: {%s}", this.link);
                player.func_146105_b(ForgeHooks.newChatWithLinks((String)("Couldn't open link: " + this.link.toString())));
            }
        }
    }

    private static abstract class Link {
        public int width;

        private Link() {
        }

        public abstract String getDisplayName();

        public abstract void onClicked(Book var1, CategoryAbstract var2, EntryAbstract var3, EntityPlayer var4, ItemStack var5, int var6);
    }
}

