/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide;

import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.entry.EntryItemStack;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.modcompat.guide.GuideHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemInfoBuilder {
    private final ItemStack stack;
    private final boolean block;
    private String name;
    private Object[] formats = new Object[0];
    private Object[] links = null;
    private GuideHelper.RECIPE_TYPE recipe_type = null;
    private ItemStack[] craftableStacks = null;
    private boolean ignoreMissingRecipes = false;
    private boolean customName;

    public ItemInfoBuilder(ItemStack stack, boolean block) {
        this.stack = stack;
        this.block = block;
        this.name = stack.func_77973_b().getRegistryName().func_110623_a();
    }

    public ItemInfoBuilder(Item item) {
        this(new ItemStack(item), false);
    }

    public ItemInfoBuilder(Block block) {
        this(new ItemStack(block), true);
    }

    public void build(Map<ResourceLocation, EntryAbstract> entries) {
        ArrayList<IPage> pages = new ArrayList<IPage>();
        String base = "guide.vampirism." + (this.block ? "blocks" : "items") + "." + this.name;
        pages.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + ".text", this.formats), this.stack));
        if (this.links != null) {
            GuideHelper.addLinks(pages, this.links);
        }
        if (this.recipe_type != null) {
            if (this.craftableStacks == null) {
                this.craftableStacks = new ItemStack[]{this.stack};
            }
            for (ItemStack s : this.craftableStacks) {
                IPage p = GuideHelper.getRecipePage(s, this.recipe_type);
                if (p != null) {
                    pages.add(p);
                    continue;
                }
                if (this.ignoreMissingRecipes) continue;
                VampirismMod.log.e("GuideBook", "Failed to find %s recipe for %s", new Object[]{this.recipe_type, s});
            }
        }
        entries.put(new ResourceLocation(base), (EntryAbstract)new EntryItemStack(pages, this.customName ? base : this.stack.func_77977_a() + ".name", this.stack));
    }

    public ItemInfoBuilder craftable(GuideHelper.RECIPE_TYPE type) {
        this.recipe_type = type;
        return this;
    }

    public ItemInfoBuilder craftableStacks(ItemStack ... craftableStacks) {
        this.craftableStacks = craftableStacks;
        return this;
    }

    public ItemInfoBuilder craftableStacks(List<ItemStack> craftableStacks) {
        this.craftableStacks = craftableStacks.toArray(new ItemStack[craftableStacks.size()]);
        return this;
    }

    public ItemInfoBuilder craftableStacks(Item ... craftableItems) {
        ItemStack[] stacks = new ItemStack[craftableItems.length];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = new ItemStack(craftableItems[i]);
        }
        this.craftableStacks(stacks);
        return this;
    }

    public ItemInfoBuilder customName() {
        this.customName = true;
        return this;
    }

    public ItemInfoBuilder ignoreMissingRecipes() {
        this.ignoreMissingRecipes = true;
        return this;
    }

    public ItemInfoBuilder setFormats(Object ... formats) {
        this.formats = formats;
        return this;
    }

    public ItemInfoBuilder setLinks(Object ... links) {
        this.links = links;
        return this;
    }

    public ItemInfoBuilder setName(String name) {
        this.name = name;
        return this;
    }
}

