/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide;

import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.IRecipeRenderer;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.PageHelper;
import amerifrance.guideapi.page.PageFurnaceRecipe;
import amerifrance.guideapi.page.PageIRecipe;
import amerifrance.guideapi.page.PageItemStack;
import amerifrance.guideapi.page.PageText;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IHunterWeaponRecipe;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.inventory.HunterWeaponCraftingManager;
import de.teamlapen.vampirism.inventory.ShapedHunterWeaponRecipe;
import de.teamlapen.vampirism.inventory.ShapelessHunterWeaponRecipe;
import de.teamlapen.vampirism.modcompat.guide.ItemInfoBuilder;
import de.teamlapen.vampirism.modcompat.guide.pages.BasicWeaponTableRecipeRenderer;
import de.teamlapen.vampirism.modcompat.guide.pages.PageHolderWithLinks;
import de.teamlapen.vampirism.modcompat.guide.pages.ShapedWeaponTableRecipeRenderer;
import de.teamlapen.vampirism.modcompat.guide.pages.ShapelessWeaponTableRecipeRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.text.WordUtils;

public class GuideHelper {
    public static String append(String ... unlocalized) {
        String s = "";
        for (String u : unlocalized) {
            s = s + UtilLib.translate(u) + "\n\n";
        }
        return s;
    }

    public static List<IPage> addLinks(List<IPage> pages, Object ... links) {
        ArrayList linkPages = Lists.newArrayList();
        for (IPage p : pages) {
            linkPages.add(new PageHolderWithLinks(p));
        }
        for (Object l : links) {
            if (l instanceof ResourceLocation) {
                for (PageHolderWithLinks p : linkPages) {
                    p.addLink((ResourceLocation)l);
                }
                continue;
            }
            if (l instanceof EntryAbstract) {
                for (PageHolderWithLinks p : linkPages) {
                    p.addLink((EntryAbstract)l);
                }
                continue;
            }
            if (l instanceof PageHolderWithLinks.URLLink) {
                for (PageHolderWithLinks p : linkPages) {
                    p.addLink((PageHolderWithLinks.URLLink)l);
                }
                continue;
            }
            VampirismMod.log.w("GuideHelper", "Given link object cannot be linked %s", l);
        }
        pages.clear();
        pages.addAll(linkPages);
        return pages;
    }

    public static IRecipe getRecipeForOutput(ItemStack stack) {
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            if (!GuideHelper.checkRecipeOutput(recipe, stack, true)) continue;
            return recipe;
        }
        return null;
    }

    public static IHunterWeaponRecipe getWeaponTableRecipeForOutput(ItemStack stack) {
        for (IHunterWeaponRecipe recipe : HunterWeaponCraftingManager.getInstance().getRecipes()) {
            if (!GuideHelper.checkRecipeOutput(recipe, stack, true)) continue;
            return recipe;
        }
        return null;
    }

    public static ItemStack getFurnaceRecipe(ItemStack stack) {
        for (Map.Entry e : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            if (!stack.func_77969_a((ItemStack)e.getValue())) continue;
            return (ItemStack)e.getKey();
        }
        return null;
    }

    private static boolean checkRecipeOutput(IRecipe recipe, ItemStack stack, boolean checkNBT) {
        ItemStack resultStack;
        return recipe != null && (resultStack = recipe.func_77571_b()) != null && resultStack.func_77973_b() != null && resultStack.func_77973_b() == stack.func_77973_b() && resultStack.func_77952_i() == stack.func_77952_i() && (!checkNBT || resultStack.func_77978_p() == null && stack.func_77978_p() == null || resultStack.func_77978_p() != null && resultStack.func_77978_p().equals((Object)stack.func_77978_p()));
    }

    @Nullable
    public static IPage getRecipePage(ItemStack stack, RECIPE_TYPE type) {
        try {
            switch (type) {
                case WORKBENCH: {
                    IRecipe r = (IRecipe)Preconditions.checkNotNull((Object)GuideHelper.getRecipeForOutput(stack));
                    return new PageIRecipe(r);
                }
                case FURNACE: {
                    ItemStack s = (ItemStack)Preconditions.checkNotNull((Object)GuideHelper.getFurnaceRecipe(stack));
                    return new PageFurnaceRecipe(s);
                }
                case WEAPON_TABLE: {
                    IHunterWeaponRecipe r2 = (IHunterWeaponRecipe)Preconditions.checkNotNull((Object)GuideHelper.getWeaponTableRecipeForOutput(stack));
                    BasicWeaponTableRecipeRenderer renderer = null;
                    if (r2 instanceof ShapedHunterWeaponRecipe) {
                        renderer = new ShapedWeaponTableRecipeRenderer((ShapedHunterWeaponRecipe)r2);
                    } else if (r2 instanceof ShapelessHunterWeaponRecipe) {
                        renderer = new ShapelessWeaponTableRecipeRenderer((ShapelessHunterWeaponRecipe)r2);
                    }
                    Preconditions.checkNotNull(renderer);
                    return new PageIRecipe((IRecipe)r2, (IRecipeRenderer)renderer);
                }
            }
            throw new IllegalArgumentException("Type unknown " + (Object)((Object)type));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static void addArmorWithTier(Map<ResourceLocation, EntryAbstract> entries, String name, IItemWithTier helmet, IItemWithTier chest, IItemWithTier legs, IItemWithTier boots, RECIPE_TYPE recipeType) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (IItemWithTier.TIER t : IItemWithTier.TIER.values()) {
            items.add(ModItems.createStack(helmet, t));
            items.add(ModItems.createStack(chest, t));
            items.add(ModItems.createStack(legs, t));
            items.add(ModItems.createStack(boots, t));
        }
        ItemInfoBuilder builder = new ItemInfoBuilder(ModItems.createStack(helmet, IItemWithTier.TIER.NORMAL), false);
        builder.setName(name).ignoreMissingRecipes().craftable(RECIPE_TYPE.WEAPON_TABLE).craftableStacks(items).customName();
        builder.build(entries);
    }

    public static void addItemWithTier(Map<ResourceLocation, EntryAbstract> entries, IItemWithTier item, RECIPE_TYPE recipeType) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (IItemWithTier.TIER t : IItemWithTier.TIER.values()) {
            items.add(ModItems.createStack(item, t));
        }
        ItemInfoBuilder builder = new ItemInfoBuilder(ModItems.createStack(item, IItemWithTier.TIER.NORMAL), false);
        builder.craftable(RECIPE_TYPE.WEAPON_TABLE).craftableStacks(items).ignoreMissingRecipes();
        builder.build(entries);
    }

    public static List<IPage> pagesForLongText(String locText, ItemStack stack, int length) {
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        String[] strings = WordUtils.wrap((String)locText, (int)Math.max(length - 150, 50), (String)"/cut", (boolean)false).split("/cut");
        pageList.add((IPage)new PageItemStack(strings[0], stack));
        if (strings.length > 2) {
            String s = Strings.join((String[])Arrays.copyOfRange(strings, 1, strings.length), (String)"");
            pageList.addAll(PageHelper.pagesForLongText((String)s, (int)length));
        } else if (strings.length == 2) {
            pageList.add((IPage)new PageText(strings[1]));
        }
        return pageList;
    }

    public static List<IPage> pagesForLongText(String locText, ItemStack stack) {
        return GuideHelper.pagesForLongText(locText, stack, 290);
    }

    public static enum RECIPE_TYPE {
        WORKBENCH,
        FURNACE,
        WEAPON_TABLE;

    }
}

