/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide;

import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.PageHelper;
import amerifrance.guideapi.category.CategoryItemStack;
import amerifrance.guideapi.page.PageImage;
import amerifrance.guideapi.page.PageText;
import amerifrance.guideapi.page.PageTextImage;
import com.google.common.collect.Maps;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.blocks.BlockAltarPillar;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.modcompat.guide.EntryText;
import de.teamlapen.vampirism.modcompat.guide.GuideHelper;
import de.teamlapen.vampirism.modcompat.guide.ItemInfoBuilder;
import de.teamlapen.vampirism.modcompat.guide.pages.PageHolderWithLinks;
import de.teamlapen.vampirism.modcompat.guide.pages.PageTable;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.player.vampire.VampireLevelingConf;
import java.awt.Color;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;

public class GuideBook {
    public static final String TAG = "GuideBook";
    private static final String IMAGE_BASE = "vampirismguide:textures/images/";
    public static ItemStack bookStack;
    private static Book guideBook;
    private static Map<ResourceLocation, EntryAbstract> links;

    static void initBook() {
        guideBook = new Book();
        guideBook.setTitle("guide.vampirism.title");
        guideBook.setDisplayName("guide.vampirism.name");
        guideBook.setWelcomeMessage("guide.vampirism.welcome");
        guideBook.setAuthor("Maxanier");
        guideBook.setColor(Color.getHSBColor(0.5f, 0.2f, 0.5f));
        guideBook.setRegistryName("vampirism", "guide");
        guideBook.setOutlineTexture(new ResourceLocation("vampirismguide", "textures/gui/book_violet_border.png"));
        guideBook.setSpawnWithBook(true);
        GameRegistry.register((IForgeRegistryEntry)guideBook);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            GuideAPI.setModel((Book)guideBook);
        }
        bookStack = GuideAPI.getStackFromBook((Book)guideBook);
        VampirismMod.log.i(TAG, "Registered Guide Book", new Object[0]);
    }

    static void buildCategories() {
        VampirismMod.log.d(TAG, "Building categories", new Object[0]);
        long start = System.currentTimeMillis();
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildOverview(), "guide.vampirism.overview.title", new ItemStack((Item)ModItems.vampireFang)));
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildVampire(), "guide.vampirism.vampire.title", new ItemStack((Item)ModItems.bloodBottle, 1, 9)));
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildHunter(), "guide.vampirism.hunter.title", new ItemStack((Item)ModItems.humanHeart)));
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildCreatures(), "guide.vampirism.entity.title", new ItemStack(Items.field_151144_bL)));
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildWorld(), "guide.vampirism.world.title", new ItemStack((Block)ModBlocks.cursedEarth)));
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildItems(), "guide.vampirism.items.title", new ItemStack(Items.field_151034_e)));
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildBlocks(), "guide.vampirism.blocks.title", new ItemStack((Block)ModBlocks.castleBlock)));
        VampirismMod.log.d(TAG, "Finished building categories after %d ms", System.currentTimeMillis() - start);
    }

    @Nullable
    public static EntryAbstract getLinkedEntry(ResourceLocation location) {
        return links.get(location);
    }

    private static Map<ResourceLocation, EntryAbstract> buildOverview() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.overview.";
        ArrayList<IPage> introPages = new ArrayList<IPage>();
        introPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "intro.text"), (int)340));
        PageHelper.setPagesToUnicode(introPages);
        entries.put(new ResourceLocation(base + "intro"), (EntryAbstract)new EntryText(introPages, UtilLib.translate(base + "intro")));
        ArrayList<IPage> gettingStartedPages = new ArrayList<IPage>();
        Object p = new PageText(UtilLib.translate(base + "gettingStarted.text"));
        p = new PageHolderWithLinks((IPage)p).addLink("guide.vampirism.vampire.gettingStarted").addLink("guide.vampirism.hunter.gettingStarted");
        gettingStartedPages.add((IPage)p);
        PageHelper.setPagesToUnicode(gettingStartedPages);
        entries.put(new ResourceLocation(base + "gettingStarted"), (EntryAbstract)new EntryText(gettingStartedPages, UtilLib.translate(base + "gettingStarted")));
        ArrayList<IPage> configPages = new ArrayList<IPage>();
        configPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "config.text"), (int)340));
        configPages.addAll(PageHelper.pagesForLongText((String)GuideHelper.append(base + "config.general.text", base + "config.general.examples"), (int)340));
        configPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "config.balance.text"), (int)340));
        PageHelper.setPagesToUnicode(configPages);
        entries.put(new ResourceLocation(base + "config"), (EntryAbstract)new EntryText(configPages, UtilLib.translate(base + "config")));
        ArrayList<IPage> troublePages = new ArrayList<IPage>();
        troublePages.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "trouble.text"), (int)340));
        PageHelper.setPagesToUnicode(troublePages);
        GuideHelper.addLinks(troublePages, new PageHolderWithLinks.URLLink(UtilLib.translate(base + "trouble"), URI.create("https://github.com/TeamLapen/Vampirism/wiki/Troubleshooting")));
        entries.put(new ResourceLocation(base + "trouble"), (EntryAbstract)new EntryText(troublePages, UtilLib.translate(base + "trouble")));
        ArrayList<IPage> devPages = new ArrayList<IPage>();
        PageHolderWithLinks.URLLink helpLink = new PageHolderWithLinks.URLLink("How to help", URI.create("https://github.com/TeamLapen/Vampirism/wiki#how-you-can-help"));
        devPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((String)UtilLib.translate(base + "dev.text"), (int)340), helpLink));
        PageHelper.setPagesToUnicode(devPages);
        entries.put(new ResourceLocation(base + "dev"), (EntryAbstract)new EntryText(devPages, UtilLib.translate(base + "dev")));
        ArrayList<IPage> supportPages = new ArrayList<IPage>();
        supportPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "support.text"), (int)300));
        PageHolderWithLinks.URLLink linkPatreon = new PageHolderWithLinks.URLLink("Patreon", URI.create("https://www.patreon.com/maxanier"));
        PageHolderWithLinks.URLLink linkCurseForge = new PageHolderWithLinks.URLLink("CurseForge", URI.create("https://minecraft.curseforge.com/projects/vampirism-become-a-vampire"));
        GuideHelper.addLinks(supportPages, linkPatreon, linkCurseForge, new ResourceLocation(base + "dev"));
        PageHelper.setPagesToUnicode(supportPages);
        entries.put(new ResourceLocation(base + "support"), (EntryAbstract)new EntryText(supportPages, UtilLib.translate(base + "support")));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildVampire() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.vampire.";
        ArrayList<IPage> gettingStarted = new ArrayList<IPage>();
        gettingStarted.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "gettingStarted.become"), (int)300));
        gettingStarted.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "gettingStarted.asVampire"), (int)300));
        gettingStarted.addAll(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "gettingStarted.blood", Keyboard.getKeyName((int)ModKeys.getKeyCode(ModKeys.KEY.SUCK))), (int)300));
        gettingStarted.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "gettingStarted.level"), (int)300));
        entries.put(new ResourceLocation(base + "gettingStarted"), (EntryAbstract)new EntryText(gettingStarted, UtilLib.translate(base + "gettingStarted")));
        ArrayList<IPage> bloodPages = new ArrayList<IPage>();
        bloodPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "blood.text", UtilLib.translate(ModItems.bloodBottle.func_77658_a() + ".name"), UtilLib.translate(Items.field_151069_bo.func_77658_a() + ".name")), (int)250));
        bloodPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "blood.storage", ModBlocks.bloodContainer.func_149732_F()), (int)250), new ResourceLocation("guide.vampirism.blocks.bloodContainer")));
        bloodPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((String)UtilLib.translate(base + "blood.biteableCreatures")), new PageHolderWithLinks.URLLink("Biteable Creatures", URI.create("https://github.com/TeamLapen/Vampirism/wiki/Biteable-Creatures"))));
        entries.put(new ResourceLocation(base + "blood"), (EntryAbstract)new EntryText(bloodPages, UtilLib.translate(base + "blood")));
        VampireLevelingConf levelingConf = VampireLevelingConf.getInstance();
        ArrayList<IPage> levelingPages = new ArrayList<IPage>();
        levelingPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "leveling.intro"), (int)300));
        String altarOfInspiration = "\u00a7l" + ModBlocks.altarInspiration.func_149732_F() + "\u00a7r\n\u00a7o" + UtilLib.translate(base + "leveling.inspiration.reach") + "\u00a7r\n";
        altarOfInspiration = altarOfInspiration + UtilLib.translate(base + "leveling.inspiration.text") + "\n";
        altarOfInspiration = altarOfInspiration + UtilLib.translateFormatted(base + "leveling.inspiration.requirements", levelingConf.getRequiredBloodForAltarInspiration(2), levelingConf.getRequiredBloodForAltarInspiration(3), levelingConf.getRequiredBloodForAltarInspiration(4));
        levelingPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((String)altarOfInspiration, (int)250), new ResourceLocation("guide.vampirism.blocks.altarInspiration")));
        String altarOfInfusion = "\u00a7l" + ModBlocks.altarInfusion.func_149732_F() + "\u00a7r\n\u00a7o" + UtilLib.translate(base + "leveling.infusion.reach") + "\u00a7r\n";
        altarOfInfusion = altarOfInfusion + UtilLib.translateFormatted(base + "leveling.infusion.intro", ModBlocks.altarInfusion.func_149732_F(), ModBlocks.altarPillar.func_149732_F(), ModBlocks.altarTip.func_149732_F());
        levelingPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((String)altarOfInfusion, (int)300), new ResourceLocation("guide.vampirism.blocks.altarInfusion")));
        String blocks = "";
        for (BlockAltarPillar.EnumPillarType t : BlockAltarPillar.EnumPillarType.values()) {
            if (t == BlockAltarPillar.EnumPillarType.NONE) continue;
            blocks = blocks + t.fillerBlock.func_149732_F() + "(" + t.getValue() + "),";
        }
        levelingPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "leveling.infusion.structure", blocks), (int)250));
        String items = UtilLib.translate(ModItems.humanHeart.func_77658_a() + ".name") + ", " + UtilLib.translate(ModItems.pureBlood.func_77658_a() + ".name") + ", " + UtilLib.translate(ModItems.vampireBook.func_77658_a() + ".name");
        levelingPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "leveling.infusion.items", items), (int)300), new ResourceLocation("guide.vampirism.items.humanHeart"), new ResourceLocation("guide.vampirism.items.pureBlood"), new ResourceLocation("guide.vampirism.items.vampireBook")));
        PageTable.Builder requirementsBuilder = new PageTable.Builder(5);
        requirementsBuilder.addUnlocLine("text.vampirism.level", base + "leveling.infusion.req.structurePoints", ModItems.pureBlood.func_77658_a() + ".name", base + "leveling.infusion.req.heart", base + "leveling.infusion.req.book");
        requirementsBuilder.addLine("5", "8", "0", "5", "1");
        requirementsBuilder.addLine("6", "17", "1 Purity(1)", "5", "1");
        requirementsBuilder.addLine("7", "21", "1 Purity(1)", "10", "1");
        requirementsBuilder.addLine("8", "26", "1 Purity(2)", "10", "1");
        requirementsBuilder.addLine("9", "35", "1 Purity(2)", "10", "1");
        requirementsBuilder.addLine("10", "44", "1 Purity(3)", "15", "1");
        requirementsBuilder.addLine("11", "54", "1 Purity(3)", "15", "1");
        requirementsBuilder.addLine("12", "63", "1 Purity(4)", "20", "1");
        requirementsBuilder.addLine("13", "72", "2 Purity(4)", "20", "1");
        requirementsBuilder.addLine("14", "92", "2 Purity(5)", "25", "1");
        requirementsBuilder.setHeadline(UtilLib.translate(base + "leveling.infusion.req"));
        PageHolderWithLinks requirementTable = new PageHolderWithLinks((IPage)requirementsBuilder.build());
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.humanHeart"));
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.vampireBook"));
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.pureBlood"));
        levelingPages.add(requirementTable);
        levelingPages.add((IPage)new PageTextImage(UtilLib.translate(base + "leveling.infusion.image1"), new ResourceLocation("vampirismguide:textures/images/infusion1.png"), false));
        levelingPages.add((IPage)new PageTextImage(UtilLib.translate(base + "leveling.infusion.image2"), new ResourceLocation("vampirismguide:textures/images/infusion2.png"), false));
        levelingPages.add((IPage)new PageTextImage(UtilLib.translate(base + "leveling.infusion.image3"), new ResourceLocation("vampirismguide:textures/images/infusion3.png"), false));
        levelingPages.add((IPage)new PageTextImage(UtilLib.translate(base + "leveling.infusion.image4"), new ResourceLocation("vampirismguide:textures/images/infusion4.png"), false));
        levelingPages.add((IPage)new PageTextImage(UtilLib.translate(base + "leveling.infusion.image5"), new ResourceLocation("vampirismguide:textures/images/infusion5.png"), false));
        entries.put(new ResourceLocation(base + "leveling"), (EntryAbstract)new EntryText(levelingPages, base + "leveling"));
        ArrayList<IPage> skillPages = new ArrayList<IPage>();
        skillPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "skills.text", Keyboard.getKeyName((int)ModKeys.getKeyCode(ModKeys.KEY.SKILL))), (int)300));
        skillPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "skills.actions", Keyboard.getKeyName((int)ModKeys.getKeyCode(ModKeys.KEY.ACTION))), (int)300));
        skillPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "skills.actions2"), (int)300));
        entries.put(new ResourceLocation(base + "skills"), (EntryAbstract)new EntryText(skillPages, base + "skills"));
        ArrayList<IPage> unvampirePages = new ArrayList<IPage>();
        unvampirePages.addAll(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "unvampire.text", ModBlocks.churchAltar.func_149732_F()), (int)300));
        entries.put(new ResourceLocation(base + "unvampire"), (EntryAbstract)new EntryText(unvampirePages, base + "unvampire"));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildHunter() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.hunter.";
        ArrayList<IPage> gettingStarted = new ArrayList<IPage>();
        String become = UtilLib.translateFormatted(base + "gettingStarted.become", UtilLib.translate("entity.vampirism.hunter_trainer.name"), new ItemStack((Item)ModItems.injection, 1, 1).func_82833_r());
        gettingStarted.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((String)become, (int)300), new ResourceLocation("guide.vampirism.items.injection")));
        gettingStarted.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/hunterTrainer.png")));
        gettingStarted.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "gettingStarted.asHunter"), (int)300));
        entries.put(new ResourceLocation(base + "gettingStarted"), (EntryAbstract)new EntryText(gettingStarted, base + "gettingStarted"));
        HunterLevelingConf levelingConf = HunterLevelingConf.instance();
        ArrayList<IPage> levelingPages = new ArrayList<IPage>();
        levelingPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "leveling.intro"), (int)300));
        String train1 = "\u00a7l" + UtilLib.translateFormatted(base + "leveling.toReach", "2-4") + "\u00a7r\n";
        train1 = train1 + UtilLib.translateFormatted(base + "leveling.train1.text", levelingConf.getVampireBloodCountForBasicHunter(2), levelingConf.getVampireBloodCountForBasicHunter(3), levelingConf.getVampireBloodCountForBasicHunter(4));
        levelingPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((String)train1, (int)250), new ResourceLocation("guide.vampirism.items.stake"), new ResourceLocation("guide.vampirism.items.vampireBloodBottle")));
        String train2 = "\u00a7l" + UtilLib.translateFormatted(base + "leveling.toReach", "5+") + "\u00a7r\n";
        train2 = train2 + UtilLib.translateFormatted(base + "leveling.train2.text", ModBlocks.hunterTable.func_149732_F());
        levelingPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((String)train2, (int)250), new ResourceLocation("guide.vampirism.blocks.hunterTable")));
        PageTable.Builder builder = new PageTable.Builder(4);
        builder.addUnlocLine("text.vampirism.level", base + "leveling.train2.fang", ModItems.pureBlood.getLocalizedName(), ModItems.vampireBook.getLocalizedName());
        for (int i = levelingConf.TABLE_MIN_LEVEL; i <= levelingConf.TABLE_MAX_LEVEL; ++i) {
            int[] req = levelingConf.getItemRequirementsForTable(i);
            String pure = "";
            if (req[1] > 0) {
                pure = "" + req[1] + " Purity(" + (req[2] + 1) + ")";
            }
            builder.addLine(i, req[0], pure, req[3]);
        }
        builder.setHeadline(base + "leveling.train2.req");
        PageHolderWithLinks requirementsTable = new PageHolderWithLinks((IPage)builder.build());
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.vampireFang"));
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.pureBlood"));
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.vampireBook"));
        levelingPages.add(requirementsTable);
        entries.put(new ResourceLocation(base + "leveling"), (EntryAbstract)new EntryText(levelingPages, base + "leveling"));
        ArrayList<IPage> skillPages = new ArrayList<IPage>();
        skillPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "skills.intro", Keyboard.getKeyName((int)ModKeys.getKeyCode(ModKeys.KEY.SKILL))), (int)250));
        String bloodPotion = String.format("\u00a7l%s\u00a7r\n", ModBlocks.bloodPotionTable.func_149732_F());
        bloodPotion = bloodPotion + UtilLib.translateFormatted(base + "skills.bloodPotion.text", Keyboard.getKeyName((int)ModKeys.getKeyCode(ModKeys.KEY.BLOOD_POTION)));
        skillPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((String)bloodPotion, (int)250), new ResourceLocation("guide.vampirism.blocks.bloodPotionTable")));
        String weaponTable = String.format("\u00a7l%s\u00a7r\n", ModBlocks.weaponTable.func_149732_F());
        weaponTable = weaponTable + UtilLib.translate(base + "skills.weaponTable.text");
        skillPages.addAll(GuideHelper.addLinks(PageHelper.pagesForLongText((String)weaponTable, (int)250), new ResourceLocation("guide.vampirism.blocks.weaponTable")));
        entries.put(new ResourceLocation(base + "skills"), (EntryAbstract)new EntryText(skillPages, base + "skills"));
        ArrayList<IPage> unHunterPages = new ArrayList<IPage>();
        unHunterPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "unhunter.text", new ItemStack((Item)ModItems.injection, 1, 2).func_82833_r()), (int)250));
        entries.put(new ResourceLocation(base + "unhunter"), (EntryAbstract)new EntryText(unHunterPages, base + "unhunter"));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildCreatures() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.entity.";
        ArrayList<IPage> generalPages = new ArrayList<IPage>();
        generalPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "general.text"), (int)250));
        entries.put(new ResourceLocation(base + "general"), (EntryAbstract)new EntryText(generalPages, base + "general"));
        ArrayList<IPage> hunterPages = new ArrayList<IPage>();
        hunterPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/hunter.png")));
        hunterPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "hunter.text", ModItems.humanHeart.getLocalizedName())));
        entries.put(new ResourceLocation(base + "hunter"), (EntryAbstract)new EntryText(hunterPages, "entity.vampirism.vampireHunter.name"));
        ArrayList<IPage> vampirePages = new ArrayList<IPage>();
        vampirePages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/vampire.png")));
        vampirePages.addAll(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "vampire.text", ModItems.vampireFang.getLocalizedName(), ModItems.vampireBlood.getLocalizedName(), ModItems.stake.getLocalizedName())));
        entries.put(new ResourceLocation(base + "vampire"), (EntryAbstract)new EntryText(vampirePages, "entity.vampirism.vampire.name"));
        ArrayList<IPage> advancedHunterPages = new ArrayList<IPage>();
        advancedHunterPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/advancedHunter.png")));
        advancedHunterPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "advancedHunter.text")));
        entries.put(new ResourceLocation(base + "advancedHunter"), (EntryAbstract)new EntryText(advancedHunterPages, "entity.vampirism.advanced_hunter.name"));
        ArrayList<IPage> advancedVampirePages = new ArrayList<IPage>();
        advancedVampirePages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/advancedVampire.png")));
        advancedVampirePages.addAll(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "advancedVampire.text", ModItems.bloodBottle.getLocalizedName(), ModItems.vampireBlood.getLocalizedName())));
        entries.put(new ResourceLocation(base + "advancedVampire"), (EntryAbstract)new EntryText(advancedVampirePages, "entity.vampirism.advanced_vampire.name"));
        ArrayList<IPage> vampireBaronPages = new ArrayList<IPage>();
        vampireBaronPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/vampireBaron.png")));
        vampireBaronPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translateFormatted(base + "vampireBaron.text", ModItems.pureBlood.getLocalizedName())));
        GuideHelper.addLinks(vampireBaronPages, new ResourceLocation("guide.vampirism.world.vampireForest"));
        entries.put(new ResourceLocation(base + "vampireBaron"), (EntryAbstract)new EntryText(vampireBaronPages, "entity.vampirism.vampireBaron.name"));
        ArrayList<IPage> minionPages = new ArrayList<IPage>();
        minionPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/minion.png")));
        minionPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "minion.text")));
        entries.put(new ResourceLocation(base + "minion"), (EntryAbstract)new EntryText(minionPages, "entity.vampirism.vampireMinionS.name"));
        ArrayList<IPage> ghostPages = new ArrayList<IPage>();
        ghostPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/ghost.png")));
        ghostPages.addAll(PageHelper.pagesForLongText((String)UtilLib.translate(base + "ghost.text")));
        entries.put(new ResourceLocation(base + "ghost"), (EntryAbstract)new EntryText(ghostPages, "entity.vampirism.ghost.name"));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildWorld() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.world.";
        ArrayList<IPage> vampireForestPages = new ArrayList<IPage>();
        vampireForestPages.addAll(PageHelper.pagesForLongText((String)(base + "vampireForest.text"), (int)250));
        entries.put(new ResourceLocation(base + "vampireForest"), (EntryAbstract)new EntryText(vampireForestPages, base + "vampireForest"));
        ArrayList<IPage> wipPages = new ArrayList<IPage>();
        wipPages.addAll(PageHelper.pagesForLongText((String)(base + "wip.text"), (int)250));
        entries.put(new ResourceLocation(base + "wip"), (EntryAbstract)new EntryText(wipPages, base + "wip"));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildItems() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.items.";
        new ItemInfoBuilder(ModItems.vampireFang).build(entries);
        new ItemInfoBuilder((Item)ModItems.humanHeart).build(entries);
        new ItemInfoBuilder(ModItems.pureBlood).setFormats(UtilLib.translate("entity.vampirism.vampireBaron.name")).build(entries);
        new ItemInfoBuilder(ModItems.vampireBlood).setFormats(UtilLib.translate("entity.vampirism.vampire.name"), ModItems.stake.getLocalizedName(), UtilLib.translate("entity.vampirism.advanced_vampire.name")).build(entries);
        new ItemInfoBuilder(ModItems.vampireBook).build(entries);
        new ItemInfoBuilder(new ItemStack((Item)ModItems.bloodBottle, 1, 9), false).build(entries);
        new ItemInfoBuilder(ModItems.injection).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).craftableStacks(new ItemStack((Item)ModItems.injection, 1, 0), new ItemStack((Item)ModItems.injection, 1, 1), new ItemStack((Item)ModItems.injection, 1, 2)).build(entries);
        new ItemInfoBuilder(ModItems.hunterIntel).setLinks(new ResourceLocation("guide.vampirism.blocks.hunterTable")).setFormats(ModBlocks.hunterTable.func_149732_F()).build(entries);
        new ItemInfoBuilder(ModItems.itemGarlic).build(entries);
        new ItemInfoBuilder(ModItems.pitchfork).craftable(GuideHelper.RECIPE_TYPE.WEAPON_TABLE).build(entries);
        new ItemInfoBuilder(ModItems.stake).setFormats((int)(Balance.hps.INSTANT_KILL_SKILL_1_MAX_HEALTH_PERC * 100.0) + "%").craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder(ModItems.basicCrossbow).setFormats(ModItems.crossbowArrow.getLocalizedName(), ModItems.techCrossbowAmmoPackage.getLocalizedName()).setLinks(new ResourceLocation("guide.vampirism.items.crossbowArrow")).craftable(GuideHelper.RECIPE_TYPE.WEAPON_TABLE).craftableStacks(ModItems.basicCrossbow, ModItems.basicDoubleCrossbow, ModItems.enhancedCrossbow, ModItems.enhancedDoubleCrossbow, ModItems.basicTechCrossbow, ModItems.techCrossbowAmmoPackage).setName("crossbows").customName().build(entries);
        new ItemInfoBuilder(ModItems.crossbowArrow).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        GuideHelper.addArmorWithTier(entries, "armorOfSwiftness", ModItems.armorOfSwiftness_helmet, ModItems.armorOfSwiftness_chest, ModItems.armorOfSwiftness_legs, ModItems.armorOfSwiftness_boots, GuideHelper.RECIPE_TYPE.WEAPON_TABLE);
        GuideHelper.addArmorWithTier(entries, "hunterCoat", ModItems.hunterCoat_helmet, ModItems.hunterCoat_chest, ModItems.hunterCoat_legs, ModItems.hunterCoat_boots, GuideHelper.RECIPE_TYPE.WEAPON_TABLE);
        GuideHelper.addItemWithTier(entries, ModItems.hunterAxe, GuideHelper.RECIPE_TYPE.WEAPON_TABLE);
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildBlocks() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.blocks.";
        new ItemInfoBuilder(ModBlocks.castleBlock).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).craftableStacks(new ItemStack((Block)ModBlocks.castleBlock, 1, 0), new ItemStack((Block)ModBlocks.castleBlock, 1, 1)).build(entries);
        new ItemInfoBuilder((Block)ModBlocks.vampirismFlower).build(entries);
        new ItemInfoBuilder((Block)ModBlocks.bloodContainer).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder((Block)ModBlocks.altarInspiration).setLinks(new ResourceLocation("guide.vampirism.vampire.leveling")).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder((Block)ModBlocks.altarInfusion).setLinks(new ResourceLocation("guide.vampirism.vampire.leveling")).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).craftableStacks(new ItemStack((Block)ModBlocks.altarInfusion), new ItemStack((Block)ModBlocks.altarPillar), new ItemStack((Block)ModBlocks.altarTip)).build(entries);
        new ItemInfoBuilder(new ItemStack((Item)ModItems.itemCoffin), true).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder(ModBlocks.churchAltar).build(entries);
        new ItemInfoBuilder(new ItemStack((Item)ModItems.itemMedChair), true).setFormats(new ItemStack((Item)ModItems.injection, 1, 1).func_82833_r(), new ItemStack((Item)ModItems.injection, 1, 2).func_82833_r()).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder(ModBlocks.hunterTable).setFormats(ModItems.hunterIntel.getLocalizedName()).setLinks(new ResourceLocation("guide.vampirism.hunter.leveling"), new ResourceLocation("guide.vampirism.items.hunterIntel")).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder(ModBlocks.weaponTable).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder(ModBlocks.bloodPotionTable).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        links.putAll(entries);
        return entries;
    }

    static {
        links = Maps.newHashMap();
    }
}

