/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IFactionLevelItem;
import de.teamlapen.vampirism.api.items.IFactionSlayerItem;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.items.VampirismItemWeapon;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class VampirismHunterWeapon
extends VampirismItemWeapon
implements IFactionLevelItem,
IFactionSlayerItem {
    public VampirismHunterWeapon(String regName, Item.ToolMaterial material) {
        super(regName, material);
    }

    public VampirismHunterWeapon(String regName, Item.ToolMaterial material, float attackSpeedMod) {
        super(regName, material, attackSpeedMod);
    }

    public VampirismHunterWeapon(String regName, Item.ToolMaterial material, float attackSpeedMod, float attackDamage) {
        super(regName, material, attackSpeedMod, attackDamage);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        if (this.getUsingFaction(stack) != null || this.getMinLevel(stack) > 0 || this.getRequiredSkill(stack) != null) {
            FactionPlayerHandler handler = FactionPlayerHandler.get(playerIn);
            TextFormatting color = Helper.canUseFactionItem(stack, this, handler) ? TextFormatting.BLUE : TextFormatting.DARK_RED;
            tooltip.add(color + UtilLib.translateFormatted(this.getUsingFaction(stack) == null ? "text.vampirism.all" : this.getUsingFaction(stack).getUnlocalizedNamePlural(), new Object[0]) + ": " + this.getMinLevel(stack) + "+");
            ISkill reqSkill = this.getRequiredSkill(stack);
            if (reqSkill != null) {
                tooltip.add(color + UtilLib.translateFormatted("text.vampirism.required_skill", UtilLib.translate(reqSkill.getUnlocalizedName())));
            }
        }
    }

    @Nullable
    public ISkill getRequiredSkill(ItemStack stack) {
        return null;
    }

    @Override
    public IFaction getSlayedFaction() {
        return VReference.VAMPIRE_FACTION;
    }

    public IPlayableFaction getUsingFaction(ItemStack stack) {
        return VReference.HUNTER_FACTION;
    }

    public static class SimpleHunterSword
    extends VampirismHunterWeapon {
        private final int minLevel;
        private final float damageMult;

        public SimpleHunterSword(String regName, Item.ToolMaterial material, int minLevel, float damageMult) {
            super(regName, material);
            this.minLevel = minLevel;
            this.damageMult = damageMult;
        }

        @Override
        public float getDamageMultiplierForFaction(ItemStack stack) {
            return this.damageMult;
        }

        @Override
        public int getMinLevel(ItemStack stack) {
            return this.minLevel;
        }

        public float func_150893_a(ItemStack stack, IBlockState state) {
            Block block = state.func_177230_c();
            if (block == Blocks.field_150321_G) {
                return 15.0f;
            }
            Material material = state.func_185904_a();
            return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && material != Material.field_151584_j && material != Material.field_151572_C ? 1.0f : 1.5f;
        }
    }
}

