/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.entity.EntityCrossbowArrow;
import de.teamlapen.vampirism.items.VampirismItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class ItemCrossbowArrow
extends VampirismItem {
    private static final String regName = "crossbowArrow";

    @Nonnull
    public static EnumArrowType getType(@Nonnull ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("type")) {
            String type = stack.func_77978_p().func_74779_i("type");
            for (EnumArrowType enumType : EnumArrowType.values()) {
                if (!enumType.name.equals(type)) continue;
                return enumType;
            }
        }
        return EnumArrowType.NORMAL;
    }

    @Nonnull
    public static ItemStack setType(@Nonnull ItemStack stack, EnumArrowType type) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74778_a("type", type.name);
        stack.func_77982_d(nbt);
        return stack;
    }

    public ItemCrossbowArrow() {
        super(regName);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        EnumArrowType type = ItemCrossbowArrow.getType(stack);
        if (type != EnumArrowType.NORMAL) {
            tooltip.add(UtilLib.translate("item.vampirism.crossbowArrow." + type.name + ".tooltip"));
        }
    }

    public EntityCrossbowArrow createEntity(ItemStack stack, World world, EntityPlayer player, double heightOffset) {
        EntityCrossbowArrow entity = new EntityCrossbowArrow(world, (EntityLivingBase)player, heightOffset, stack);
        EnumArrowType type = ItemCrossbowArrow.getType(stack);
        entity.func_70239_b(type.baseDamage);
        return entity;
    }

    public String func_77653_i(ItemStack stack) {
        EnumArrowType type = ItemCrossbowArrow.getType(stack);
        if (type != EnumArrowType.NORMAL) {
            return UtilLib.translate("item.vampirism.crossbowArrow." + type.name + ".name");
        }
        return super.func_77653_i(stack);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        for (EnumArrowType type : EnumArrowType.values()) {
            subItems.add(ItemCrossbowArrow.setType(new ItemStack(itemIn), type));
        }
    }

    public boolean isCanBeInfinite(ItemStack stack) {
        EnumArrowType type = ItemCrossbowArrow.getType(stack);
        return type != EnumArrowType.VAMPIRE_KILLER;
    }

    public void onHitEntity(ItemStack arrow, EntityLivingBase entity, EntityArrow arrowEntity, Entity shootingEntity) {
        float max;
        EnumArrowType type = ItemCrossbowArrow.getType(arrow);
        if (type == EnumArrowType.VAMPIRE_KILLER && entity instanceof IVampireMob && (max = entity.func_110138_aP()) < (float)Balance.general.ARROW_VAMPIRE_KILLER_MAX_HEALTH) {
            entity.func_70097_a(DamageSource.func_76353_a((EntityArrow)arrowEntity, (Entity)shootingEntity), max);
        }
    }

    public static enum EnumArrowType {
        NORMAL("normal", 2.0),
        VAMPIRE_KILLER("vampireKiller", 0.5);

        final String name;
        final double baseDamage;

        private EnumArrowType(String name, double baseDamage) {
            this.name = name;
            this.baseDamage = baseDamage;
        }
    }
}

