/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.items.IHunterWeaponRecipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ShapedHunterWeaponRecipe
implements IHunterWeaponRecipe {
    public final int recipeWidth;
    public final int recipeHeight;
    public final ItemStack[] recipeItems;
    private final int requiredHunterLevel;
    @Nonnull
    private final ISkill<IHunterPlayer>[] requiredHunterSkills;
    private final int requiredLavaUnits;
    private final ItemStack recipeOutput;

    public ShapedHunterWeaponRecipe(int width, int height, ItemStack[] input, ItemStack output, int requiredHunterLevel, @Nonnull ISkill<IHunterPlayer>[] requiredHunterSkills, int requiredLavaUnits) {
        this.recipeWidth = width;
        this.recipeHeight = height;
        this.recipeItems = input;
        this.recipeOutput = output;
        this.requiredHunterLevel = requiredHunterLevel;
        this.requiredHunterSkills = requiredHunterSkills;
        this.requiredLavaUnits = requiredLavaUnits;
    }

    @Nullable
    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemStack itemstack = this.func_77571_b().func_77946_l();
        return itemstack;
    }

    @Override
    public int getMinHunterLevel() {
        return this.requiredHunterLevel;
    }

    @Nullable
    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public int func_77570_a() {
        return this.recipeWidth * this.recipeHeight;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        ItemStack[] aitemstack = new ItemStack[inv.func_70302_i_()];
        for (int i = 0; i < aitemstack.length; ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            aitemstack[i] = ForgeHooks.getContainerItem((ItemStack)itemstack);
        }
        return aitemstack;
    }

    @Override
    public int getRequiredLavaUnits() {
        return this.requiredLavaUnits;
    }

    @Override
    @Nonnull
    public ISkill<IHunterPlayer>[] getRequiredSkills() {
        return this.requiredHunterSkills;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        for (int x = 0; x <= 4 - this.recipeWidth; ++x) {
            for (int y = 0; y <= 4 - this.recipeHeight; ++y) {
                if (this.checkMatch(inv, x, y, true)) {
                    return true;
                }
                if (!this.checkMatch(inv, x, y, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inv, int startRow, int startColumn, boolean flip) {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                ItemStack itemstack1;
                int k = x - startRow;
                int l = y - startColumn;
                ItemStack itemStack = null;
                if (k >= 0 && l >= 0 && k < this.recipeWidth && l < this.recipeHeight) {
                    itemStack = flip ? this.recipeItems[this.recipeWidth - k - 1 + l * this.recipeWidth] : this.recipeItems[k + l * this.recipeWidth];
                }
                if ((itemstack1 = inv.func_70463_b(x, y)) == null && itemStack == null) continue;
                if (itemstack1 == null || itemStack == null) {
                    return false;
                }
                if (itemStack.func_77973_b() != itemstack1.func_77973_b()) {
                    return false;
                }
                if (itemStack.func_77960_j() == Short.MAX_VALUE || itemStack.func_77960_j() == itemstack1.func_77960_j()) continue;
                return false;
            }
        }
        return true;
    }
}

