/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.player.hunter.IHunterPlayer;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.api.items.IHunterWeaponCraftingManager;
import de.teamlapen.vampirism.api.items.IHunterWeaponRecipe;
import de.teamlapen.vampirism.inventory.ShapedHunterWeaponRecipe;
import de.teamlapen.vampirism.inventory.ShapelessHunterWeaponRecipe;
import de.teamlapen.vampirism.util.Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class HunterWeaponCraftingManager
implements IHunterWeaponCraftingManager {
    private static final String TAG = "HWCraftingManager";
    private static final HunterWeaponCraftingManager INSTANCE = new HunterWeaponCraftingManager();
    private final List<IHunterWeaponRecipe> recipes = Lists.newLinkedList();

    public static HunterWeaponCraftingManager getInstance() {
        return INSTANCE;
    }

    @Override
    public IHunterWeaponRecipe addRecipe(ItemStack output, int reqLevel, @Nonnull ISkill<IHunterPlayer>[] reqSkills, int reqLava, Object ... recipeComponents) {
        String s = "";
        int i = 0;
        int j = 0;
        int k = 0;
        if (recipeComponents[i] instanceof String[]) {
            String[] astring = (String[])recipeComponents[i++];
            for (int l = 0; l < astring.length; ++l) {
                String s2 = astring[l];
                ++k;
                j = s2.length();
                s = s + s2;
            }
        } else {
            while (recipeComponents[i] instanceof String) {
                String s1 = (String)recipeComponents[i++];
                ++k;
                j = s1.length();
                s = s + s1;
            }
        }
        HashMap map = Maps.newHashMap();
        while (i < recipeComponents.length) {
            Character character = (Character)recipeComponents[i];
            ItemStack itemstack = null;
            if (recipeComponents[i + 1] instanceof Item) {
                itemstack = new ItemStack((Item)recipeComponents[i + 1]);
            } else if (recipeComponents[i + 1] instanceof Block) {
                itemstack = new ItemStack((Block)recipeComponents[i + 1], 1, Short.MAX_VALUE);
            } else if (recipeComponents[i + 1] instanceof ItemStack) {
                itemstack = (ItemStack)recipeComponents[i + 1];
            } else {
                VampirismMod.log.e(TAG, "Cannot add %s to recipe as %s since it is not supported", recipeComponents[i + 1], character);
            }
            map.put(character, itemstack);
            i += 2;
        }
        ItemStack[] aitemstack = new ItemStack[j * k];
        for (int i1 = 0; i1 < j * k; ++i1) {
            char c0 = s.charAt(i1);
            aitemstack[i1] = map.containsKey(Character.valueOf(c0)) ? ((ItemStack)map.get(Character.valueOf(c0))).func_77946_l() : null;
        }
        ShapedHunterWeaponRecipe recipe = new ShapedHunterWeaponRecipe(j, k, aitemstack, output, reqLevel, reqSkills, reqLava);
        this.recipes.add(recipe);
        return recipe;
    }

    @Override
    public IHunterWeaponRecipe addRecipe(ItemStack output, int reqLevel, @Nullable ISkill<IHunterPlayer> reqSkill, int reqLava, Object ... recipeComponents) {
        ISkill[] reqSkills = reqSkill == null ? new ISkill[]{} : new ISkill[]{reqSkill};
        return this.addRecipe(output, reqLevel, reqSkills, reqLava, recipeComponents);
    }

    @Override
    public void addRecipe(IHunterWeaponRecipe recipe) {
        this.recipes.add(recipe);
    }

    @Override
    public IHunterWeaponRecipe addShapelessRecipe(ItemStack output, int reqLevel, @Nullable ISkill<IHunterPlayer> reqSkill, int reqLava, Object ... recipeComponents) {
        ISkill[] reqSkills = reqSkill == null ? new ISkill[]{} : new ISkill[]{reqSkill};
        return this.addRecipe(output, reqLevel, reqSkills, reqLava, recipeComponents);
    }

    @Override
    public IHunterWeaponRecipe addShapelessRecipe(ItemStack output, int reqLevel, @Nonnull ISkill<IHunterPlayer>[] reqSkills, int reqLava, Object ... recipeComponents) {
        ArrayList list = Lists.newArrayList();
        for (Object object : recipeComponents) {
            if (object instanceof ItemStack) {
                list.add(((ItemStack)object).func_77946_l());
                continue;
            }
            if (object instanceof Item) {
                list.add(new ItemStack((Item)object));
                continue;
            }
            if (!(object instanceof Block)) {
                throw new IllegalArgumentException("Invalid shapeless recipe: unknown type " + object.getClass().getName() + "!");
            }
            list.add(new ItemStack((Block)object));
        }
        ShapelessHunterWeaponRecipe recipe = new ShapelessHunterWeaponRecipe(list, output, reqLevel, reqSkills, reqLava);
        this.recipes.add(recipe);
        return recipe;
    }

    @Override
    @Nullable
    public IHunterWeaponRecipe findMatchingRecipe(InventoryCrafting craftMatrix, World world, int playerLevel, ISkillHandler<IHunterPlayer> skillHandler, int lava) {
        for (IHunterWeaponRecipe iRecipe : this.recipes) {
            if (!iRecipe.func_77569_a(craftMatrix, world) || playerLevel < iRecipe.getMinHunterLevel() || lava < iRecipe.getRequiredLavaUnits() || !Helper.areSkillsEnabled(skillHandler, iRecipe.getRequiredSkills())) continue;
            return iRecipe;
        }
        return null;
    }

    @Override
    @Nullable
    public ItemStack findMatchingRecipeResult(InventoryCrafting craftMatrix, World world, int playerLevel, ISkillHandler<IHunterPlayer> skillHandler, int lava) {
        IHunterWeaponRecipe recipe = this.findMatchingRecipe(craftMatrix, world, playerLevel, skillHandler, lava);
        return recipe == null ? null : recipe.func_77572_b(craftMatrix);
    }

    public List<IHunterWeaponRecipe> getRecipes() {
        return this.recipes;
    }

    @Override
    public ItemStack[] getRemainingItems(InventoryCrafting craftMatrix, World world, int playerLevel, ISkillHandler<IHunterPlayer> skillHandler, int lava) {
        IHunterWeaponRecipe recipe = this.findMatchingRecipe(craftMatrix, world, playerLevel, skillHandler, lava);
        if (recipe != null) {
            return recipe.func_179532_b(craftMatrix);
        }
        ItemStack[] aitemstack = new ItemStack[craftMatrix.func_70302_i_()];
        for (int i = 0; i < aitemstack.length; ++i) {
            aitemstack[i] = craftMatrix.func_70301_a(i);
        }
        return aitemstack;
    }
}

