/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.inventory;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.lib.lib.inventory.InventorySlot;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.core.Achievements;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.hunter.skills.HunterSkills;
import de.teamlapen.vampirism.potion.blood.BloodPotions;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BloodPotionTableContainer
extends Container {
    private static final InventorySlot.IItemSelector bloodfilter = new InventorySlot.IItemSelector(){

        @Override
        public boolean isItemAllowed(@Nonnull ItemStack item) {
            return ((Object)((Object)ModItems.vampireBlood)).equals(item.func_77973_b());
        }
    };
    private final BlockPos pos;
    private final HunterPlayer hunterPlayer;
    private final World world;
    private final int max_crafting_time;
    private final boolean portable;
    private final IInventory inventory = new InventoryBasic("vampirism.blood_potion_table", false, 4);
    private int craftingTimer = 0;
    private int prevCraftingTimer = 0;

    public BloodPotionTableContainer(InventoryPlayer playerInventory, BlockPos pos, World world) {
        int crafting_time;
        this.pos = pos;
        this.hunterPlayer = HunterPlayer.get(playerInventory.field_70458_d);
        this.world = world;
        this.portable = !((Object)((Object)ModBlocks.bloodPotionTable)).equals(world.func_180495_p(pos).func_177230_c());
        int n = crafting_time = this.portable ? 500 : 250;
        if (this.hunterPlayer.getSkillHandler().isSkillEnabled(HunterSkills.bloodPotion_fasterCrafting)) {
            crafting_time /= 2;
        }
        this.max_crafting_time = crafting_time;
        this.func_75146_a(new PotionSlot(this.inventory, 0, 115, 55));
        this.func_75146_a(new PotionSlot(this.inventory, 1, 137, 55));
        this.func_75146_a(new InventoryContainer.FilterSlot(this.inventory, 2, 126, 14, new InventorySlot.IItemSelector(){

            @Override
            public boolean isItemAllowed(ItemStack item) {
                return ModItems.itemGarlic.equals(item.func_77973_b());
            }
        }));
        this.func_75146_a(new Slot(this.inventory, 3, 101, 22));
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.func_75146_a(new Slot((IInventory)playerInventory, l, 8 + l * 18, 142));
        }
    }

    public boolean canCurrentlyStartCrafting() {
        return this.craftingTimer <= 0 && this.areRequirementsMet();
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            IContainerListener icontainerlistener = (IContainerListener)this.field_75149_d.get(i);
            if (this.prevCraftingTimer == this.craftingTimer) continue;
            icontainerlistener.func_71112_a((Container)this, 0, this.craftingTimer);
        }
        this.prevCraftingTimer = this.craftingTimer;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public float getCraftingPercentage() {
        return this.craftingTimer == 0 ? 0.0f : 1.0f - (float)this.craftingTimer / (float)this.max_crafting_time;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public List<String> getLocalizedCraftingHint() {
        ItemStack extra = this.inventory.func_70301_a(3);
        if (extra == null) {
            return null;
        }
        if (!this.hunterPlayer.getSkillHandler().isSkillEnabled(HunterSkills.bloodPotion_categoryHint)) {
            return null;
        }
        List<String> hints = BloodPotions.getLocalizedCategoryHint(extra);
        if (hints.isEmpty()) {
            hints.add(UtilLib.translate("text.vampirism.blood_potion.any_effect"));
        } else {
            hints.add(0, UtilLib.translate("text.vampirism.blood_potion.might_cause"));
        }
        return hints;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!this.world.field_72995_K) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.inventory.func_70304_b(i);
                if (itemstack == null) continue;
                playerIn.func_71019_a(itemstack, false);
            }
        }
    }

    public void onCraftingClicked() {
        if (this.canCurrentlyStartCrafting()) {
            this.craftingTimer = this.max_crafting_time;
        }
    }

    public void tick() {
        if (this.craftingTimer > 0) {
            --this.craftingTimer;
            if (this.craftingTimer == 0) {
                this.onCraftingTimerFinished();
            } else if (this.craftingTimer % 5 == 0 && !this.areRequirementsMet()) {
                this.craftingTimer = 0;
            }
        }
    }

    @Nullable
    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        ItemStack itemstack = null;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index >= 0 && index < 4 ? !this.func_75135_a(itemstack1, 3, 39, true) : (index >= 3 && index < 30 ? !this.func_75135_a(itemstack1, 30, 39, false) : (index >= 30 && index < 39 ? !this.func_75135_a(itemstack1, 3, 30, false) : !this.func_75135_a(itemstack1, 3, 39, false)))) {
                return null;
            }
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        if (id == 0 && data >= 0 && data <= this.max_crafting_time) {
            this.craftingTimer = data;
        }
    }

    private boolean areRequirementsMet() {
        ItemStack garlic = this.inventory.func_70301_a(2);
        if (garlic == null || !ModItems.itemGarlic.equals(garlic.func_77973_b())) {
            return false;
        }
        boolean bottle = false;
        ItemStack bottle1 = this.inventory.func_70301_a(0);
        ItemStack bottle2 = this.inventory.func_70301_a(1);
        if (bottle1 != null && bottle1.func_77973_b().equals((Object)ModItems.vampireBlood)) {
            bottle = true;
        }
        if (bottle2 != null && bottle2.func_77973_b().equals((Object)ModItems.vampireBlood)) {
            bottle = true;
        }
        return bottle;
    }

    private void onCraftingTimerFinished() {
        if (!this.areRequirementsMet()) {
            return;
        }
        ItemStack extraItem = this.inventory.func_70301_a(3);
        if (extraItem != null) {
            extraItem = extraItem.func_77946_l();
            extraItem.field_77994_a = 1;
            this.inventory.func_70298_a(3, 1);
        }
        this.inventory.func_70298_a(2, 1);
        ItemStack bottle1 = this.inventory.func_70301_a(0);
        ItemStack bottle2 = this.inventory.func_70301_a(1);
        if (bottle1 != null && bottle1.func_77973_b().equals((Object)ModItems.vampireBlood)) {
            bottle1 = new ItemStack((Item)ModItems.bloodPotion);
            BloodPotions.chooseAndAddEffects(bottle1, this.hunterPlayer, extraItem);
        }
        if (bottle2 != null && bottle2.func_77973_b().equals((Object)ModItems.vampireBlood)) {
            bottle2 = new ItemStack((Item)ModItems.bloodPotion);
            BloodPotions.chooseAndAddEffects(bottle2, this.hunterPlayer, extraItem);
        }
        this.inventory.func_70299_a(0, bottle1);
        this.inventory.func_70299_a(1, bottle2);
        this.hunterPlayer.getRepresentingPlayer().func_71029_a((StatBase)Achievements.bloodTable);
    }

    private class PotionSlot
    extends InventoryContainer.FilterSlot {
        private PotionSlot(IInventory inventory, int index, int xPosition, int yPosition) {
            super(inventory, index, xPosition, yPosition, bloodfilter);
        }

        public int func_75219_a() {
            return 1;
        }
    }
}

