/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumGarlicStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.EntityVampirism;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public abstract class EntityVampireBase
extends EntityVampirism
implements IVampireMob {
    private final boolean countAsMonster;
    protected EnumGarlicStrength garlicResist = EnumGarlicStrength.NONE;
    protected boolean canSuckBloodFromPlayer = false;
    private boolean sundamageCache;
    private EnumGarlicStrength garlicCache = EnumGarlicStrength.NONE;

    public EntityVampireBase(World world, boolean countAsMonster) {
        super(world);
        this.countAsMonster = countAsMonster;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (this.canSuckBloodFromPlayer && !this.field_70170_p.field_72995_K && entity instanceof EntityPlayer && !UtilLib.canReallySee((EntityLivingBase)entity, (EntityLivingBase)this, true) && this.field_70146_Z.nextInt(Balance.mobProps.VAMPIRE_BITE_ATTACK_CHANCE) == 0) {
            int amt = VampirePlayer.get((EntityPlayer)entity).onBite(this);
            this.drinkBlood(amt, 1.0f);
            return true;
        }
        return super.func_70652_k(entity);
    }

    @Override
    public boolean doesResistGarlic(EnumGarlicStrength strength) {
        return !strength.isStrongerThan(this.garlicResist);
    }

    @Override
    public void drinkBlood(int amt, float saturationMod) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, amt * 20));
    }

    @Override
    public boolean func_70601_bi() {
        if (this.isGettingSundamage(true) || this.field_70170_p.func_72935_r() && this.field_70146_Z.nextInt(5) != 0) {
            return false;
        }
        if (this.isGettingGarlicDamage(true) != EnumGarlicStrength.NONE) {
            return false;
        }
        if (this.field_70170_p.func_175714_ae().func_176056_a(this.func_180425_c(), 1) != null) {
            return this.func_70681_au().nextInt(60) == 0 && super.func_70601_bi();
        }
        return super.func_70601_bi();
    }

    public EnumCreatureAttribute func_70668_bt() {
        return super.func_70668_bt();
    }

    @Override
    public IFaction getFaction() {
        return VReference.VAMPIRE_FACTION;
    }

    @Override
    public EntityLivingBase getRepresentingEntity() {
        return this;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.countAsMonster && type == EnumCreatureType.MONSTER) {
            return true;
        }
        return super.isCreatureType(type, forSpawnCount);
    }

    @Override
    public EnumGarlicStrength isGettingGarlicDamage() {
        return this.isGettingGarlicDamage(false);
    }

    @Override
    public EnumGarlicStrength isGettingGarlicDamage(boolean forcerefresh) {
        if (forcerefresh) {
            this.garlicCache = Helper.gettingGarlicDamage((EntityLivingBase)this);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((EntityLivingBase)this);
        return this.sundamageCache;
    }

    @Override
    public boolean isGettingSundamage() {
        return this.isGettingSundamage(false);
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.func_70644_a(ModPotions.sunscreen);
    }

    @Override
    public void func_70636_d() {
        double dmg;
        if (this.field_70173_aa % 40 == 3) {
            this.isGettingGarlicDamage(true);
        }
        if (this.field_70173_aa % 8 == 2) {
            this.isGettingSundamage(true);
        }
        if (!this.field_70170_p.field_72995_K && this.isGettingSundamage() && this.field_70173_aa % 40 == 11 && (dmg = this.func_110148_a(VReference.sunDamage).func_111126_e()) > 0.0) {
            this.func_70097_a(VReference.SUNDAMAGE, (float)dmg);
        }
        super.func_70636_d();
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(VReference.sunDamage).func_111128_a(Balance.mobProps.VAMPIRE_MOB_SUN_DAMAGE);
        this.func_110140_aT().func_111150_b(VReference.garlicDamage).func_111128_a(Balance.mobProps.VAMPIRE_MOB_GARLIC_DAMAGE);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }
}

