/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.minions;

import com.google.common.base.Predicate;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.entity.minions.IMinion;
import de.teamlapen.vampirism.api.entity.minions.IMinionLord;
import de.teamlapen.vampirism.api.entity.minions.ISaveableMinion;
import de.teamlapen.vampirism.api.entity.minions.ISaveableMinionHandler;
import de.teamlapen.vampirism.util.MinionHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class SaveableMinionHandler<T extends ISaveableMinion>
implements ISaveableMinionHandler<T> {
    private static final String TAG = "MinionHandler";
    private final List<T> minions;
    private final IMinionLord lord;
    private final Predicate<EntityLivingBase> entityPredicate;
    private List<T> loadedMinions;

    public SaveableMinionHandler(IMinionLord lord) {
        this.lord = lord;
        this.minions = new ArrayList<T>();
        this.entityPredicate = new Predicate<EntityLivingBase>(){

            public boolean apply(@Nullable EntityLivingBase e) {
                if (e == null) {
                    return false;
                }
                if (e instanceof IMinion && SaveableMinionHandler.this.lord.equals(((IMinion)e).getLord())) {
                    return false;
                }
                return !e.equals((Object)SaveableMinionHandler.this.lord);
            }
        };
    }

    @Override
    public void addLoadedMinions() {
        if (this.loadedMinions == null) {
            return;
        }
        List<T> list = this.loadedMinions;
        this.loadedMinions = null;
        World world = this.lord.getRepresentingEntity().field_70170_p;
        for (ISaveableMinion m : list) {
            EntityCreature entity = MinionHelper.entity(m);
            entity.field_98038_p = true;
            world.func_72838_d((Entity)entity);
            m.setLord(this.lord);
        }
        list.clear();
    }

    @Override
    public void checkMinions() {
        Iterator<T> it = this.minions.iterator();
        while (it.hasNext()) {
            ISaveableMinion m = (ISaveableMinion)it.next();
            if (!MinionHelper.entity((IMinion)m).field_70128_L && this.lord.equals(m.getLord())) continue;
            it.remove();
        }
    }

    @Override
    public int getLeftMinionSlots() {
        return Math.max(this.lord.getMaxMinionCount() - this.getMinionCount(), 0);
    }

    @Override
    public int getMinionCount() {
        return this.minions.size();
    }

    public NBTTagList getMinionsToSave() {
        NBTTagList list = new NBTTagList();
        for (IMinion m : this.minions) {
            EntityCreature e = MinionHelper.entity(m);
            boolean dead = e.field_70128_L;
            e.field_70128_L = false;
            NBTTagCompound nbt = new NBTTagCompound();
            e.func_184198_c(nbt);
            list.func_74742_a((NBTBase)nbt);
            if (!dead) continue;
            e.field_70128_L = true;
        }
        return list;
    }

    @Override
    public Predicate<EntityLivingBase> getNonMinionSelector() {
        return this.entityPredicate;
    }

    @Override
    public void killMinions(boolean instant) {
        for (ISaveableMinion m : this.minions) {
            EntityCreature e = MinionHelper.entity(m);
            if (instant) {
                e.func_70106_y();
                continue;
            }
            e.func_70097_a(DamageSource.field_76376_m, 100.0f);
        }
    }

    public void loadMinions(NBTTagList list) {
        if (list == null || list.func_74745_c() == 0) {
            VampirismMod.log.d(TAG, "Empty minion list to load", new Object[0]);
            return;
        }
        this.loadedMinions = new ArrayList<T>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = list.func_150305_b(i);
            Entity entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)this.lord.getRepresentingEntity().field_70170_p);
            if (entity != null && entity instanceof ISaveableMinion) {
                entity.field_70163_u += (double)entity.field_70131_O;
                this.loadedMinions.add((ISaveableMinion)entity);
                VampirismMod.log.d(TAG, "Loaded minion from nbt", new Object[0]);
                continue;
            }
            VampirismMod.log.d(TAG, "Failed to load minion from NBT", new Object[0]);
        }
    }

    @Override
    public void registerMinion(T m, boolean force) {
        if (force || this.getLeftMinionSlots() > 0) {
            this.minions.add(m);
        }
    }

    @Override
    public void teleportMinionsToLord() {
        EntityCreature e;
        ArrayList<ISaveableMinion> toTeleportDim = new ArrayList<ISaveableMinion>();
        EntityLivingBase e1 = this.lord.getRepresentingEntity();
        Iterator<T> it = this.minions.iterator();
        while (it.hasNext()) {
            ISaveableMinion m = (ISaveableMinion)it.next();
            EntityCreature entityCreature = MinionHelper.entity(m);
            if (e1.field_71093_bK == entityCreature.field_71093_bK) continue;
            toTeleportDim.add(m);
            it.remove();
        }
        for (IMinion iMinion : this.minions) {
            e = MinionHelper.entity(iMinion);
            e.func_82149_j((Entity)e1);
        }
        for (IMinion iMinion : toTeleportDim) {
            e = MinionHelper.entity(iMinion);
            e.func_184204_a(e1.field_71093_bK);
            e.field_71088_bW = e.func_82147_ab();
        }
    }

    public String toString() {
        return "MinionHandler for " + this.lord.toString() + " with " + this.getMinionCount() + " minions";
    }

    @Override
    public void unregisterMinion(T m) {
        this.minions.remove(m);
    }
}

