/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.entity.ISundamageRegistry;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.util.ResourceLocation;

public class SundamageRegistry
implements ISundamageRegistry {
    private HashMap<Integer, Boolean> sundamageDims = new HashMap();
    private HashMap<Integer, Boolean> sundamageConfiguredDims = new HashMap();
    private Set<ResourceLocation> noSundamageBiomes = new CopyOnWriteArraySet<ResourceLocation>();
    private boolean defaultSundamage = false;

    public SundamageRegistry() {
        this.sundamageDims.put(0, true);
        this.sundamageDims.put(-1, false);
        this.sundamageDims.put(1, false);
    }

    @Override
    public void addNoSundamageBiome(ResourceLocation registryName) {
        this.noSundamageBiomes.add(registryName);
    }

    @Override
    public boolean getSundamageInBiome(ResourceLocation registryName) {
        return !this.noSundamageBiomes.contains(registryName);
    }

    @Override
    public boolean getSundamageInDim(int dim) {
        Boolean r = this.sundamageConfiguredDims.get(dim);
        if (r == null) {
            r = this.sundamageDims.get(dim);
        }
        return r == null ? this.defaultSundamage : r;
    }

    public void resetConfiguredSundamgeDims() {
        this.sundamageConfiguredDims.clear();
    }

    public void setDefaultDimsSundamage(boolean val) {
        this.defaultSundamage = val;
    }

    public void specifyConfiguredSundamageForDim(int dimensionId, boolean sundamage) {
        this.sundamageConfiguredDims.put(dimensionId, sundamage);
    }

    @Override
    public void specifySundamageForDim(int dimensionId, boolean sundamage) {
        this.sundamageDims.put(dimensionId, sundamage);
    }
}

