/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.ArrayUtils;

public class VampirismCommand
extends BasicCommand {
    public VampirismCommand() {
        if (VampirismMod.inDev) {
            this.aliases.add("v");
        }
        final IPlayableFaction[] pfactions = VampirismAPI.factionRegistry().getPlayableFactions();
        final String[] pfaction_names = new String[pfactions.length];
        for (int i = 0; i < pfactions.length; ++i) {
            pfaction_names[i] = pfactions[i].name();
        }
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return args.length == 1 ? CommandBase.func_71530_a((String[])args, (String[])this.getCategories()) : Collections.emptyList();
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return !FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S() || sender.func_70003_b(3, this.getCommandName());
            }

            @Override
            public String getCommandName() {
                return "resetBalance";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName() + " <all/[category]/help>";
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                boolean p;
                String cat = args == null || args.length == 0 ? "all" : args[0];
                if ("help".equals(cat)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("You can reset Vampirism balance values to the default values. If you have not modified them, this is recommend after every update of Vampirism"));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Use '/vampirism resetBalance all' to reset all categories or specify a category with '/vampirism resetBalance <category>' (Tab completion is supported)"));
                }
                if (p = Balance.resetAndReload(cat)) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Successfully reset " + cat + " balance category. Please restart MC."));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Did not find " + cat + " balance category."));
                }
            }

            private String[] getCategories() {
                Set<String> categories = Balance.getCategories().keySet();
                String[] result = categories.toArray(new String[categories.size() + 2]);
                result[result.length - 1] = "all";
                result[result.length - 2] = "help";
                return result;
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return args.length == 1 ? CommandBase.func_71530_a((String[])args, (String[])pfaction_names) : Collections.emptyList();
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return VampirismCommand.this.canCommandSenderUseCheatCommand(sender);
            }

            @Override
            public String getCommandName() {
                return "level";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName() + " " + ArrayUtils.toString((Object)pfaction_names) + " <level> [<player>]";
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                int level;
                if (args.length < 2 || args.length > 3) {
                    throw new WrongUsageException(this.getCommandUsage(sender), new Object[0]);
                }
                EntityPlayerMP player = args.length == 3 ? CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]) : CommandBase.func_71521_c((ICommandSender)sender);
                try {
                    level = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    throw new NumberInvalidException();
                }
                for (int i = 0; i < pfaction_names.length; ++i) {
                    if (!pfaction_names[i].equalsIgnoreCase(args[0])) continue;
                    IPlayableFaction newFaction = pfactions[i];
                    FactionPlayerHandler handler = FactionPlayerHandler.get((EntityPlayer)player);
                    if (level == 0 && !handler.canLeaveFaction()) {
                        sender.func_145747_a(new TextComponentTranslation("text.vampirism.faction.cant_leave", new Object[0]).func_150257_a((ITextComponent)new TextComponentString("(" + handler.getCurrentFaction().name() + ")")));
                        return;
                    }
                    if (level > newFaction.getHighestReachableLevel()) {
                        level = newFaction.getHighestReachableLevel();
                    }
                    if (handler.setFactionAndLevel(newFaction, level)) {
                        ITextComponent msg = player.func_145748_c_().func_150257_a((ITextComponent)new TextComponentString(" is now a " + pfaction_names[i] + " level " + level));
                        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148539_a(msg);
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.faction.failed_to_change", new Object[0]));
                    }
                    return;
                }
                throw new CommandException("commands.vampirism.level.faction_not_found", new Object[]{args[0]});
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return null;
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return sender instanceof EntityPlayer;
            }

            @Override
            public String getCommandName() {
                return "eye";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName() + " <id [0-" + 6 + "]> ";
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayer player = (EntityPlayer)sender;
                if (args.length != 1) {
                    throw new WrongUsageException(this.getCommandUsage(sender), new Object[0]);
                }
                try {
                    int type = Integer.parseInt(args[0]);
                    if (!VampirePlayer.get(player).setEyeType(type)) {
                        BasicCommand.sendMessage(sender, "<id> has to be a valid number between 0 and 6");
                    }
                }
                catch (NumberFormatException e) {
                    throw new NumberInvalidException();
                }
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return null;
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return sender instanceof EntityPlayer;
            }

            @Override
            public String getCommandName() {
                return "fang";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName() + " <id [0-" + 5 + "]> ";
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayer player = (EntityPlayer)sender;
                if (args.length != 1) {
                    throw new WrongUsageException(this.getCommandUsage(sender), new Object[0]);
                }
                try {
                    int type = Integer.parseInt(args[0]);
                    if (!VampirePlayer.get(player).setFangType(type)) {
                        BasicCommand.sendMessage(sender, "<id> has to be a valid number between 0 and 5");
                    }
                }
                catch (NumberFormatException e) {
                    throw new NumberInvalidException();
                }
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return Collections.emptyList();
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return VampirismCommand.this.canCommandSenderUseCommand(sender, 4, this.getCommandName());
            }

            @Override
            public String getCommandName() {
                return "checkForVampireBiome";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName() + " <maxRadius in chunks>";
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (Configs.disable_vampireForest) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("The Vampire Biome is disabled in the config file"));
                } else {
                    int maxDist = 150;
                    if (args.length > 0) {
                        try {
                            maxDist = Integer.parseInt(args[0]);
                        }
                        catch (NumberFormatException e) {
                            VampirismMod.log.w("CheckVampireBiome", "Failed to parse max dist %s", args[0]);
                            sender.func_145747_a((ITextComponent)new TextComponentString("Failed to parse max distance. Using " + maxDist));
                        }
                        if (!(maxDist <= 500 || args.length > 1 && "yes".equals(args[1]))) {
                            sender.func_145747_a((ITextComponent)new TextComponentString("This will take a long time. Please use '/" + this.getCommandUsage(sender) + " yes', if you are sure"));
                            return;
                        }
                    }
                    ArrayList<Biome> biomes = new ArrayList<Biome>();
                    biomes.add(ModBiomes.vampireForest);
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.biome.looking_for_biome", new Object[0]));
                    ChunkPos pos = UtilLib.findNearBiome(sender.func_130014_f_(), sender.func_180425_c(), maxDist, biomes, sender);
                    if (pos == null) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("text.vampirism.biome.not_found", new Object[0]));
                    } else {
                        sender.func_145747_a(new TextComponentTranslation("text.vampirism.biome.found", new Object[0]).func_150257_a((ITextComponent)new TextComponentString("[" + (pos.field_77276_a << 4) + "," + (pos.field_77275_b << 4) + "]")));
                    }
                }
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return Collections.emptyList();
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return true;
            }

            @Override
            public String getCommandName() {
                return "changelog";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName();
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (!VampirismMod.instance.getVersionInfo().isNewVersionAvailable()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("There is no new version available"));
                    return;
                }
                VersionChecker.Version newVersion = VampirismMod.instance.getVersionInfo().getNewVersion();
                List<String> changes = newVersion.getChanges();
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Vampirism " + newVersion.name + "(" + "1.10.2" + ")"));
                for (String c : changes) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("-" + c));
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                String template = I18n.func_74838_a((String)"text.vampirism.update_message");
                String homepage = VampirismMod.instance.getVersionInfo().getHomePage();
                template = template.replaceAll("@download@", newVersion.getUrl() == null ? homepage : newVersion.getUrl()).replaceAll("@forum@", homepage);
                ITextComponent component = ITextComponent.Serializer.func_150699_a((String)template);
                sender.func_145747_a(component);
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return Collections.emptyList();
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return true;
            }

            @Override
            public String getCommandName() {
                return "currentDimension";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName();
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                if (sender instanceof EntityPlayer) {
                    EntityPlayer p = (EntityPlayer)sender;
                    if (p.field_70170_p != null) {
                        sender.func_145747_a((ITextComponent)new TextComponentString("Dimension ID: " + p.field_70170_p.field_73011_w.getDimension()));
                    }
                }
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            @Nonnull
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return Collections.emptyList();
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return !FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S() || sender.func_70003_b(3, this.getCommandName());
            }

            @Override
            public String getCommandName() {
                return "debug";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName();
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                boolean enabled = VampirismMod.log.isDebug();
                VampirismMod.log.setDebug(!enabled);
                String msg = enabled ? "Disabled debug mode" : "Enabled debug mode";
                sender.func_145747_a((ITextComponent)new TextComponentString(msg));
            }
        });
    }

    public String func_71517_b() {
        return "vampirism";
    }

    @Override
    protected boolean canCommandSenderUseCheatCommand(ICommandSender sender) {
        if (VampirismMod.inDev) {
            return true;
        }
        return super.canCommandSenderUseCheatCommand(sender);
    }

    protected boolean canCommandSenderUseCommand(ICommandSender sender, int perm, String command) {
        if (VampirismMod.inDev) {
            return true;
        }
        return sender.func_70003_b(perm, command);
    }
}

