/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.BasicCommand;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.skills.ISkill;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillHandler;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.EntityHunterVillager;
import de.teamlapen.vampirism.player.skills.SkillRegistry;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.tests.Tests;
import de.teamlapen.vampirism.tileentity.TileTent;
import de.teamlapen.vampirism.util.VampireBookManager;
import de.teamlapen.vampirism.world.gen.VampirismWorldGen;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerNotFoundException;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class TestCommand
extends BasicCommand {
    public TestCommand() {
        if (VampirismMod.inDev) {
            this.aliases.add("vtest");
        }
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return null;
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return TestCommand.this.canCommandSenderUseCommand(sender, 3, this.getCommandName());
            }

            @Override
            public String getCommandName() {
                return "garlic_profiler";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName();
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Tick"));
                this.print(sender, "tick");
                sender.func_145747_a((ITextComponent)new TextComponentString("Garlic"));
                this.print(sender, "vampirism_checkGarlic");
            }

            private void print(ICommandSender var1, String id) {
                List l = FMLCommonHandler.instance().getMinecraftServerInstance().field_71304_b.func_76321_b(id);
                for (Profiler.Result r : l) {
                    var1.func_145747_a((ITextComponent)new TextComponentString("" + r.field_76331_c + ": " + r.field_76332_a + "|" + r.field_76330_b));
                }
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return args.length == 1 ? CommandBase.func_175762_a((String[])args, (Collection)this.getOptions(sender)) : null;
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return TestCommand.this.canCommandSenderUseCheatCommand(sender) && sender instanceof EntityPlayerMP;
            }

            @Override
            public String getCommandName() {
                return "skill";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName() + " <skillname>";
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                IFactionPlayer factionPlayer = FactionPlayerHandler.get((EntityPlayer)CommandBase.func_71521_c((ICommandSender)sender)).getCurrentFactionPlayer();
                if (factionPlayer == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("You have to be in a faction"));
                    return;
                }
                if (args.length == 0) {
                    throw new WrongUsageException(this.getCommandUsage(sender), new Object[0]);
                }
                if ("list".equals(args[0])) {
                    ((SkillRegistry)VampirismAPI.skillRegistry()).printSkills(factionPlayer.getFaction(), sender);
                    return;
                }
                if ("disableall".equals(args[0])) {
                    factionPlayer.getSkillHandler().resetSkills();
                    return;
                }
                ISkill skill = VampirismAPI.skillRegistry().getSkill(factionPlayer.getFaction(), args[0]);
                if (skill == null) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Skill with id " + args[0] + " could not be found for faction " + factionPlayer.getFaction().name()));
                    return;
                }
                if (factionPlayer.getSkillHandler().isSkillEnabled(skill)) {
                    factionPlayer.getSkillHandler().disableSkill(skill);
                    sender.func_145747_a((ITextComponent)new TextComponentString("Disabled skill"));
                    return;
                }
                ISkillHandler.Result result = factionPlayer.getSkillHandler().canSkillBeEnabled(skill);
                if (result == ISkillHandler.Result.OK) {
                    factionPlayer.getSkillHandler().enableSkill(skill);
                    sender.func_145747_a((ITextComponent)new TextComponentString("Enabled skill"));
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Could not enable skill " + (Object)((Object)result)));
                }
            }

            private List getOptions(ICommandSender sender) {
                ArrayList<String> list = new ArrayList<String>();
                list.add("list");
                list.add("disableall");
                try {
                    IFactionPlayer factionPlayer = FactionPlayerHandler.get((EntityPlayer)CommandBase.func_71521_c((ICommandSender)sender)).getCurrentFactionPlayer();
                    ((SkillRegistry)VampirismAPI.skillRegistry()).addSkills(factionPlayer.getFaction(), list);
                }
                catch (PlayerNotFoundException playerNotFoundException) {
                    // empty catch block
                }
                return list;
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return null;
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return TestCommand.this.canCommandSenderUseCheatCommand(sender) && sender instanceof EntityPlayer;
            }

            @Override
            public String getCommandName() {
                return "emptyBloodBar";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName();
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                VampirePlayer player = VampirePlayer.get((EntityPlayer)CommandBase.func_71521_c((ICommandSender)sender));
                if (player.getLevel() > 0) {
                    player.getBloodStats().setBloodLevel(0);
                }
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return null;
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return TestCommand.this.canCommandSenderUseCheatCommand(sender) && sender instanceof EntityPlayer;
            }

            @Override
            public String getCommandName() {
                return "entity";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName();
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)sender);
                List l = player.field_70170_p.func_72839_b((Entity)player, player.func_174813_aQ().func_72314_b(3.0, 2.0, 3.0));
                for (Object o : l) {
                    if (o instanceof EntityCreature) {
                        String s = EntityList.func_75621_b((Entity)((Entity)o));
                        BasicCommand.sendMessage(sender, s);
                        continue;
                    }
                    BasicCommand.sendMessage(sender, "Not biteable " + o.getClass().getName());
                }
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return null;
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return TestCommand.this.canCommandSenderUseCheatCommand(sender) && sender instanceof EntityPlayer;
            }

            @Override
            public String getCommandName() {
                return "makeVillagerAgressive";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName();
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)sender);
                List l = player.field_70170_p.func_72872_a(EntityVillager.class, player.func_174813_aQ().func_72314_b(3.0, 2.0, 3.0));
                for (EntityVillager v : l) {
                    EntityHunterVillager hunter = EntityHunterVillager.makeHunter(v);
                    v.func_70106_y();
                    v.field_70170_p.func_72838_d((Entity)hunter);
                }
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return null;
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return TestCommand.this.canCommandSenderUseCheatCommand(sender) && sender instanceof EntityPlayer;
            }

            @Override
            public String getCommandName() {
                return "resetActions";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName();
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                IActionHandler handler;
                EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)sender);
                IFactionPlayer factionPlayer = FactionPlayerHandler.get((EntityPlayer)player).getCurrentFactionPlayer();
                if (factionPlayer != null && (handler = factionPlayer.getActionHandler()) != null) {
                    handler.resetTimers();
                    BasicCommand.sendMessage(sender, "Reset Timers");
                }
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return null;
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return TestCommand.this.canCommandSenderUseCheatCommand(sender);
            }

            @Override
            public String getCommandName() {
                return "tent";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName();
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                TileEntity tent;
                EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)sender);
                RayTraceResult result = UtilLib.getPlayerLookingSpot((EntityPlayer)player, 5.0);
                if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && (tent = player.field_70170_p.func_175625_s(result.func_178782_a())) != null && tent instanceof TileTent) {
                    ((TileTent)tent).setSpawn(true);
                    BasicCommand.sendMessage(sender, "Success");
                }
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return null;
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return TestCommand.this.canCommandSenderUseCheatCommand(sender) && sender instanceof EntityPlayer;
            }

            @Override
            public String getCommandName() {
                return "vampireBook";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName();
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP player = CommandBase.func_71521_c((ICommandSender)sender);
                player.field_71071_by.func_70441_a(VampireBookManager.getInstance().getRandomBook(player.func_70681_au()));
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return null;
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return TestCommand.this.canCommandSenderUseCheatCommand(sender);
            }

            @Override
            public String getCommandName() {
                return "debugGen";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName();
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                if (VampirismWorldGen.debug) {
                    VampirismWorldGen.debug = false;
                    BasicCommand.sendMessage(sender, "Disabled world gen debug");
                } else {
                    VampirismWorldGen.debug = true;
                    BasicCommand.sendMessage(sender, "Enabled world gen debug");
                }
            }
        });
        this.addSub(new BasicCommand.SubCommand(){

            @Override
            public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
                return null;
            }

            @Override
            public boolean canSenderUseCommand(ICommandSender sender) {
                return TestCommand.this.canCommandSenderUseCheatCommand(sender) && sender instanceof EntityPlayer;
            }

            @Override
            public String getCommandName() {
                return "runTests";
            }

            @Override
            public String getCommandUsage(ICommandSender sender) {
                return this.getCommandName();
            }

            @Override
            public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                EntityPlayerMP p = CommandBase.func_71521_c((ICommandSender)sender);
                Tests.runTests(p.field_70170_p, (EntityPlayer)p);
            }
        });
    }

    public String func_71517_b() {
        return "vampirism-test";
    }

    @Override
    protected boolean canCommandSenderUseCheatCommand(ICommandSender sender) {
        if (VampirismMod.inDev) {
            return true;
        }
        return super.canCommandSenderUseCheatCommand(sender);
    }

    protected boolean canCommandSenderUseCommand(ICommandSender sender, int perm, String command) {
        if (VampirismMod.inDev) {
            return true;
        }
        return sender.func_70003_b(perm, command);
    }
}

