/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModVillages;
import de.teamlapen.vampirism.potion.FakeNightVisionPotion;
import de.teamlapen.vampirism.util.DaySleepHelper;
import de.teamlapen.vampirism.world.ModWorldEventListener;
import de.teamlapen.vampirism.world.villages.VampirismVillageCollection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IWorldEventListener;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ModEventHandler {
    private static final String TAG = "EventHandler";

    @SubscribeEvent
    public void onConfigurationChanged(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.getModID().equalsIgnoreCase("vampirism")) {
            VampirismMod.log.i(TAG, "Configuration (%s) changed", e.getConfigID());
            Configs.onConfigurationChanged();
            Balance.onConfigurationChanged();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onInitMapGen(InitMapGenEvent event) {
        if (event.getType().equals((Object)InitMapGenEvent.EventType.VILLAGE) && Configs.village_modify) {
            if (event.getNewGen() != event.getOriginalGen()) {
                VampirismMod.log.w("VillageGen", "The village map generator was overwritten by another mod. There might be a problem! \n The new generator class is " + event.getNewGen().getClass().getCanonicalName(), new Object[0]);
            }
            ModVillages.modifyVillageSize(event.getNewGen());
        }
    }

    @SubscribeEvent
    public void onPlayerJoinedWorld(EntityJoinWorldEvent entityJoinWorldEvent) {
        if (entityJoinWorldEvent.getEntity() instanceof EntityPlayer && (VampirismMod.proxy.isClientPlayerNull() || VampirismMod.proxy.isPlayerThePlayer((EntityPlayer)entityJoinWorldEvent.getEntity()))) {
            FakeNightVisionPotion.replaceNightVision();
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        VersionChecker.VersionInfo versionInfo = VampirismMod.instance.getVersionInfo();
        if (!versionInfo.isChecked()) {
            VampirismMod.log.w(TAG, "Version check is not finished yet", new Object[0]);
        }
        if (!Configs.disable_versionCheck && versionInfo.isNewVersionAvailable() && (!FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S() || UtilLib.isPlayerOp(event.player) || event.player.func_70681_au().nextInt(5) == 0) && event.player.func_70681_au().nextInt(4) == 0) {
            VersionChecker.Version newVersion = versionInfo.getNewVersion();
            event.player.func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.outdated", new Object[]{versionInfo.getCurrentVersion().name, newVersion.name}));
            String template = I18n.func_74838_a((String)"text.vampirism.update_message");
            template = template.replaceAll("@download@", newVersion.getUrl() == null ? versionInfo.getHomePage() : newVersion.getUrl()).replaceAll("@forum@", versionInfo.getHomePage());
            ITextComponent component = ITextComponent.Serializer.func_150699_a((String)template);
            event.player.func_146105_b(component);
        }
        if (Configs.updated_vampirism && (!FMLCommonHandler.instance().getMinecraftServerInstance().func_71262_S() || UtilLib.isPlayerOp(event.player))) {
            event.player.func_146105_b((ITextComponent)new TextComponentString("It looks like you have updated Vampirism"));
            event.player.func_146105_b((ITextComponent)new TextComponentString("Please consider resetting the balance values to the updated ones, using " + TextFormatting.DARK_GREEN + "'/vampirism resetBalance all'" + TextFormatting.RESET));
            event.player.func_146105_b((ITextComponent)new TextComponentString("For more information use " + TextFormatting.DARK_GREEN + "'/vampirism resetBalance help'" + TextFormatting.RESET));
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        event.getWorld().func_72954_a((IWorldEventListener)new ModWorldEventListener(event.getWorld().field_73011_w.getDimension()));
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            DaySleepHelper.checkSleepWorld(event.world);
            VampirismVillageCollection.get(event.world).tick();
        }
    }
}

