/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.core;

import de.teamlapen.lib.lib.item.ItemMetaBlock;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.vampirism.blocks.BlockAltarInfusion;
import de.teamlapen.vampirism.blocks.BlockAltarInspiration;
import de.teamlapen.vampirism.blocks.BlockAltarPillar;
import de.teamlapen.vampirism.blocks.BlockAltarTip;
import de.teamlapen.vampirism.blocks.BlockBloodContainer;
import de.teamlapen.vampirism.blocks.BlockBloodPotionTable;
import de.teamlapen.vampirism.blocks.BlockCastleBlock;
import de.teamlapen.vampirism.blocks.BlockChurchAltar;
import de.teamlapen.vampirism.blocks.BlockCoffin;
import de.teamlapen.vampirism.blocks.BlockCursedEarth;
import de.teamlapen.vampirism.blocks.BlockFirePlace;
import de.teamlapen.vampirism.blocks.BlockFluidBlood;
import de.teamlapen.vampirism.blocks.BlockGarlic;
import de.teamlapen.vampirism.blocks.BlockHunterTable;
import de.teamlapen.vampirism.blocks.BlockMedChair;
import de.teamlapen.vampirism.blocks.BlockSunscreenBeacon;
import de.teamlapen.vampirism.blocks.BlockTent;
import de.teamlapen.vampirism.blocks.BlockTentMain;
import de.teamlapen.vampirism.blocks.BlockWeaponTable;
import de.teamlapen.vampirism.blocks.VampirismFlower;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.tileentity.TileAltarInfusion;
import de.teamlapen.vampirism.tileentity.TileAltarInspiration;
import de.teamlapen.vampirism.tileentity.TileBloodContainer;
import de.teamlapen.vampirism.tileentity.TileCoffin;
import de.teamlapen.vampirism.tileentity.TileSunscreenBeacon;
import de.teamlapen.vampirism.tileentity.TileTent;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ModBlocks {
    public static BlockFluidBlood fluidBlood;
    public static BlockCastleBlock castleBlock;
    public static BlockCursedEarth cursedEarth;
    public static VampirismFlower vampirismFlower;
    public static BlockTent tent;
    public static BlockTentMain tentMain;
    public static BlockCoffin coffin;
    public static BlockAltarInfusion altarInfusion;
    public static BlockAltarPillar altarPillar;
    public static BlockAltarTip altarTip;
    public static BlockHunterTable hunterTable;
    public static BlockMedChair medChair;
    public static BlockGarlic garlic;
    public static BlockChurchAltar churchAltar;
    public static BlockBloodContainer bloodContainer;
    public static BlockAltarInspiration altarInspiration;
    public static BlockFirePlace firePlace;
    public static BlockWeaponTable weaponTable;
    public static BlockBloodPotionTable bloodPotionTable;
    public static BlockSunscreenBeacon sunscreenBeacon;

    public static void onInitStep(IInitListener.Step step, FMLStateEvent event) {
        switch (step) {
            case PRE_INIT: {
                ModBlocks.registerBlocks();
                ModBlocks.registerTiles();
                break;
            }
            case INIT: {
                ModBlocks.registerCraftingRecipes();
                break;
            }
        }
    }

    private static void registerTiles() {
        GameRegistry.registerTileEntity(TileTent.class, (String)"VampirismTent");
        GameRegistry.registerTileEntity(TileCoffin.class, (String)"VampirismCoffin");
        GameRegistry.registerTileEntity(TileAltarInfusion.class, (String)"VampirismAltarInfusion");
        GameRegistry.registerTileEntity(TileBloodContainer.class, (String)"VampirismBloodContainer");
        GameRegistry.registerTileEntity(TileAltarInspiration.class, (String)"VampirismAltarInspiration");
        GameRegistry.registerTileEntity(TileSunscreenBeacon.class, (String)"VampirismSunscreenBeacon");
    }

    private static void registerBlocks() {
        fluidBlood = ModBlocks.registerBlock(new BlockFluidBlood());
        castleBlock = new BlockCastleBlock();
        ModBlocks.registerBlock(castleBlock, (Item)new ItemMetaBlock(castleBlock));
        cursedEarth = ModBlocks.registerBlock(new BlockCursedEarth());
        vampirismFlower = new VampirismFlower();
        ModBlocks.registerBlock(vampirismFlower, (Item)new ItemMetaBlock((Block)vampirismFlower));
        tent = ModBlocks.registerBlock(new BlockTent(), null);
        tentMain = ModBlocks.registerBlock(new BlockTentMain(), null);
        coffin = ModBlocks.registerBlock(new BlockCoffin(), null);
        altarInfusion = ModBlocks.registerBlock(new BlockAltarInfusion());
        altarPillar = ModBlocks.registerBlock(new BlockAltarPillar());
        altarTip = ModBlocks.registerBlock(new BlockAltarTip());
        hunterTable = ModBlocks.registerBlock(new BlockHunterTable());
        medChair = ModBlocks.registerBlock(new BlockMedChair(), null);
        garlic = ModBlocks.registerBlock(new BlockGarlic(), null);
        churchAltar = ModBlocks.registerBlock(new BlockChurchAltar());
        bloodContainer = new BlockBloodContainer();
        ItemBlock itemBloodContainer = new ItemBlock((Block)bloodContainer);
        itemBloodContainer.setRegistryName(bloodContainer.getRegistryName());
        itemBloodContainer.func_77625_d(1);
        ModBlocks.registerBlock(bloodContainer, (Item)itemBloodContainer);
        altarInspiration = ModBlocks.registerBlock(new BlockAltarInspiration());
        firePlace = ModBlocks.registerBlock(new BlockFirePlace());
        weaponTable = ModBlocks.registerBlock(new BlockWeaponTable());
        bloodPotionTable = ModBlocks.registerBlock(new BlockBloodPotionTable());
        sunscreenBeacon = ModBlocks.registerBlock(new BlockSunscreenBeacon());
    }

    private static void registerCraftingRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)altarInfusion, 1), (Object[])new Object[]{"   ", "YZY", "ZZZ", Character.valueOf('Y'), Items.field_151043_k, Character.valueOf('Z'), Blocks.field_150343_Z});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)altarPillar, 4), (Object[])new Object[]{"X X", "   ", "XXX", Character.valueOf('X'), Blocks.field_150417_aV});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)altarTip, 2), (Object[])new Object[]{"   ", " X ", "XYX", Character.valueOf('X'), Items.field_151042_j, Character.valueOf('Y'), Blocks.field_150339_S});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)castleBlock, 1, 0), (Object[])new Object[]{"XXX", "XYX", "XXX", Character.valueOf('X'), Blocks.field_150417_aV, Character.valueOf('Y'), new ItemStack((Block)vampirismFlower, 1, VampirismFlower.EnumFlowerType.ORCHID.getMeta())});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack((Block)castleBlock, 8, 1), (Object[])new Object[]{castleBlock, castleBlock, castleBlock, castleBlock, castleBlock, castleBlock, castleBlock, castleBlock, new ItemStack(Items.field_151100_aR, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)hunterTable), (Object[])new Object[]{"XYW", "ZZZ", "Z Z", Character.valueOf('X'), ModItems.vampireFang, Character.valueOf('Y'), Items.field_151122_aG, Character.valueOf('Z'), Blocks.field_150344_f, Character.valueOf('W'), ModItems.itemGarlic});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)bloodContainer), (Object[])new Object[]{"XYX", "YZY", "XYX", Character.valueOf('X'), Blocks.field_150344_f, Character.valueOf('Y'), Blocks.field_150359_w, Character.valueOf('Z'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)altarInspiration, 1), (Object[])new Object[]{" X ", "XYX", "ZZZ", Character.valueOf('X'), Blocks.field_150359_w, Character.valueOf('Y'), Items.field_151069_bo, Character.valueOf('Z'), Items.field_151042_j});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)firePlace, 1), (Object[])new Object[]{"   ", " X ", "XYX", Character.valueOf('X'), Blocks.field_150364_r, Character.valueOf('Y'), Items.field_151044_h});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)weaponTable, 1), (Object[])new Object[]{"X  ", "YYY", " Z ", Character.valueOf('X'), Items.field_151133_ar, Character.valueOf('Y'), Items.field_151042_j, Character.valueOf('Z'), Blocks.field_150339_S});
        GameRegistry.addRecipe((ItemStack)new ItemStack((Block)bloodPotionTable, 1), (Object[])new Object[]{"XXX", "Y Y", "ZZZ", Character.valueOf('X'), Items.field_151069_bo, Character.valueOf('Y'), Blocks.field_150344_f, Character.valueOf('Z'), Items.field_151042_j});
    }

    private static <T extends Block> T registerBlock(T block, Item item) {
        GameRegistry.register(block);
        if (item != null) {
            GameRegistry.register((IForgeRegistryEntry)item);
        }
        return block;
    }

    private static <T extends Block> T registerBlock(T block) {
        ItemBlock item = new ItemBlock(block);
        item.setRegistryName(block.getRegistryName());
        return ModBlocks.registerBlock(block, (Item)item);
    }
}

