/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.config;

import de.teamlapen.lib.lib.config.BalanceValues;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.config.BalanceGeneral;
import de.teamlapen.vampirism.config.BalanceHunterPlayer;
import de.teamlapen.vampirism.config.BalanceHunterSkills;
import de.teamlapen.vampirism.config.BalanceLeveling;
import de.teamlapen.vampirism.config.BalanceMobProps;
import de.teamlapen.vampirism.config.BalanceVampireActions;
import de.teamlapen.vampirism.config.BalanceVampirePlayer;
import de.teamlapen.vampirism.config.BalanceVampireSkills;
import de.teamlapen.vampirism.config.BalanceVillage;
import de.teamlapen.vampirism.config.Configs;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class Balance {
    private static final String TAG = "Balance";
    private static final Map<String, BalanceValues> categories = new HashMap<String, BalanceValues>();
    public static BalanceLeveling leveling;
    public static BalanceMobProps mobProps;
    public static BalanceVampirePlayer vp;
    public static BalanceHunterPlayer hp;
    public static BalanceVampireActions vpa;
    public static BalanceVampireSkills vps;
    public static BalanceGeneral general;
    public static BalanceVillage village;
    public static BalanceHunterSkills hps;

    public static void init(File configDir, boolean inDev) {
        File balanceDir = new File(configDir, "balance");
        leveling = Balance.addBalance(new BalanceLeveling(balanceDir));
        mobProps = Balance.addBalance(new BalanceMobProps(balanceDir));
        vp = Balance.addBalance(new BalanceVampirePlayer(balanceDir));
        hp = Balance.addBalance(new BalanceHunterPlayer(balanceDir));
        vpa = Balance.addBalance(new BalanceVampireActions(balanceDir));
        general = Balance.addBalance(new BalanceGeneral(balanceDir));
        vps = Balance.addBalance(new BalanceVampireSkills(balanceDir));
        village = Balance.addBalance(new BalanceVillage(balanceDir));
        hps = Balance.addBalance(new BalanceHunterSkills(balanceDir));
        if (inDev && Configs.resetConfigurationInDev) {
            Balance.resetAndReload(null);
        } else {
            Balance.loadConfiguration();
        }
        VampirismMod.log.i(TAG, "Loaded balance configuration", new Object[0]);
    }

    private static <T extends BalanceValues> T addBalance(T cat) {
        categories.put(cat.getName(), cat);
        return cat;
    }

    private static void loadConfiguration() {
        for (BalanceValues values : categories.values()) {
            values.loadBalance();
        }
    }

    public static void onConfigurationChanged() {
        VampirismMod.log.i(TAG, "Reloading changed balance configuration", new Object[0]);
        Balance.loadConfiguration();
    }

    public static boolean resetAndReload(String category) {
        if (category == null || category.equals("all")) {
            for (BalanceValues values : categories.values()) {
                values.resetAndReload();
            }
            return true;
        }
        BalanceValues values = categories.get(category);
        if (values != null) {
            values.resetAndReload();
            return true;
        }
        return false;
    }

    public static Map<String, BalanceValues> getCategories() {
        return categories;
    }
}

