/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.converted.EntityConvertedCreature;
import de.teamlapen.vampirism.items.ItemHunterCoat;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.util.Helper;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Sphere;

@SideOnly(value=Side.CLIENT)
public class RenderHandler {
    private static final ResourceLocation saturation1 = new ResourceLocation("vampirism:shaders/saturation1.json");
    private final Minecraft mc;
    private final int BLOOD_VISION_FADE_TICKS = 80;
    private final int ENTITY_RADIUS;
    private final int ENTITY_MIN_SQ_RADIUS = 25;
    private final int VAMPIRE_BIOME_FADE_TICKS = 160;
    private final int COMPILE_ENTITY_COOLDOWN;
    private final int ENTITY_NEAR_SQ_DISTANCE = 100;
    private int entityCooldownTicks;
    private int entityDisplayListId = 0;
    private int entitySphereListId = 0;
    private EntityBat entityBat;
    private int vampireBiomeTicks = 0;
    private int bloodVisionTicks = 0;
    private float vampireBiomeFogDistanceMultiplier = 1.0f;
    private boolean doShaders = true;

    public RenderHandler(Minecraft mc) {
        this.mc = mc;
        this.COMPILE_ENTITY_COOLDOWN = Configs.blood_vision_recompile_ticks;
        this.ENTITY_RADIUS = Balance.vps.BLOOD_VISION_DISTANCE;
        this.entityDisplayListId = GlStateManager.func_187442_t((int)2);
        this.entitySphereListId = this.entityDisplayListId + 1;
        this.buildEntitySphere();
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71441_e == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        VampirePlayer vampire = VampirePlayer.get((EntityPlayer)this.mc.field_71439_g);
        if (vampire.getSpecialAttributes().blood_vision && !VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).isGettingSundamage()) {
            if (this.bloodVisionTicks < 80) {
                ++this.bloodVisionTicks;
            }
            --this.entityCooldownTicks;
            if (this.entityCooldownTicks < 1) {
                this.compileEntitys();
                this.entityCooldownTicks = this.COMPILE_ENTITY_COOLDOWN;
            }
        } else {
            if (this.bloodVisionTicks > 0) {
                this.bloodVisionTicks -= 2;
            }
            if (this.vampireBiomeTicks > 10 && this.bloodVisionTicks == 15) {
                this.bloodVisionTicks = 0;
            }
        }
        if (Configs.renderVampireForestFog && VReference.castleDimId != this.mc.field_71441_e.field_73011_w.getDimension() && Helper.isEntityInVampireBiome((Entity)this.mc.field_71439_g)) {
            if (this.vampireBiomeTicks < 160) {
                ++this.vampireBiomeTicks;
            }
            this.vampireBiomeFogDistanceMultiplier = vampire.getSpecialAttributes().increasedVampireFogDistance ? 2.0f : 1.0f;
        } else if (this.vampireBiomeTicks > 0) {
            --this.vampireBiomeTicks;
        }
        if (OpenGlHelper.func_153193_b() && this.doShaders && this.mc.field_71439_g != null && this.mc.field_71439_g.func_70681_au().nextInt(10) == 3) {
            PotionEffect pe = this.mc.field_71439_g.func_70660_b(ModPotions.saturation);
            boolean active = pe != null && pe.func_76458_c() >= 2;
            EntityRenderer renderer = this.mc.field_71460_t;
            if (active && !renderer.func_147702_a()) {
                try {
                    Method method = ReflectionHelper.findMethod(EntityRenderer.class, (Object)renderer, (String[])new String[]{"loadShader", "func_175069_a"}, (Class[])new Class[]{ResourceLocation.class});
                    method.invoke((Object)renderer, saturation1);
                }
                catch (Exception e) {
                    this.doShaders = false;
                    VampirismMod.log.e("RenderHandler", e, "Failed to activate saturation shader", new Object[0]);
                }
            } else if (!active && renderer.func_147702_a() && renderer.func_147706_e().func_148022_b().equals(saturation1.toString())) {
                renderer.func_181022_b();
            }
        }
    }

    @SubscribeEvent
    public void onFogDensity(EntityViewRenderEvent.FogDensity event) {
        if (event.getEntity() instanceof EntityPlayer && (this.vampireBiomeTicks > 10 || this.bloodVisionTicks > 0)) {
            event.setDensity(1.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
        if (VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).getActionHandler().isActionActive(VampireActions.batAction)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        if (VampirePlayer.get(event.getEntityPlayer()).getActionHandler().isActionActive(VampireActions.batAction)) {
            event.setCanceled(true);
            if (this.entityBat == null) {
                this.entityBat = new EntityBat(event.getEntity().field_70170_p);
                this.entityBat.func_82236_f(false);
            }
            EntityPlayer player = event.getEntityPlayer();
            float parTick = event.getPartialRenderTick();
            Render renderer = this.mc.func_175598_ae().func_78713_a((Entity)this.entityBat);
            this.entityBat.field_70760_ar = player.field_70760_ar;
            this.entityBat.field_70761_aq = player.field_70761_aq;
            this.entityBat.field_70173_aa = player.field_70173_aa;
            this.entityBat.field_70125_A = player.field_70125_A;
            this.entityBat.field_70177_z = player.field_70177_z;
            this.entityBat.field_70759_as = player.field_70759_as;
            this.entityBat.field_70126_B = player.field_70126_B;
            this.entityBat.field_70127_C = player.field_70127_C;
            this.entityBat.field_70758_at = player.field_70758_at;
            this.entityBat.func_82142_c(player.func_82150_aj());
            float f1 = this.entityBat.field_70126_B + (this.entityBat.field_70177_z - this.entityBat.field_70126_B) * parTick;
            double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)parTick;
            double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)parTick;
            double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)parTick;
            Entity entity = this.mc.func_175606_aa();
            double d3 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)parTick;
            double d4 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)parTick;
            double d5 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)parTick;
            this.mc.func_175598_ae().func_188391_a((Entity)this.entityBat, d0 - d3, d1 - d4, d2 - d5, f1, event.getPartialRenderTick(), false);
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (this.mc.field_71441_e == null) {
            return;
        }
        if (this.bloodVisionTicks > 40) {
            double doubleX = this.mc.field_71439_g.field_70142_S + (this.mc.field_71439_g.field_70165_t - this.mc.field_71439_g.field_70142_S) * (double)event.getPartialTicks();
            double doubleY = this.mc.field_71439_g.field_70137_T + (this.mc.field_71439_g.field_70163_u - this.mc.field_71439_g.field_70137_T) * (double)event.getPartialTicks();
            double doubleZ = this.mc.field_71439_g.field_70136_U + (this.mc.field_71439_g.field_70161_v - this.mc.field_71439_g.field_70136_U) * (double)event.getPartialTicks();
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
            GlStateManager.func_179148_o((int)this.entityDisplayListId);
            GlStateManager.func_179121_F();
        }
        if (this.bloodVisionTicks > 0) {
            this.renderBloodVisionFog(this.bloodVisionTicks);
        }
        if (this.vampireBiomeTicks > 0) {
            this.renderVampireBiomeFog(this.vampireBiomeTicks);
        }
    }

    private void buildEntitySphere() {
        Sphere sphere = new Sphere();
        sphere.setDrawStyle(100012);
        sphere.setNormals(100000);
        sphere.setOrientation(100020);
        GlStateManager.func_187423_f((int)this.entitySphereListId, (int)4864);
        sphere.draw(0.5f, 32, 32);
        GL11.glEndList();
    }

    private void compileEntitys() {
        GlStateManager.func_187423_f((int)this.entityDisplayListId, (int)4864);
        GlStateManager.func_179090_x();
        GL11.glDisable((int)2929);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179103_j((int)7425);
        WorldClient world = this.mc.field_71441_e;
        EntityPlayerSP player = this.mc.field_71439_g;
        if (world == null || player == null) {
            return;
        }
        List list = world.func_72839_b((Entity)player, player.func_174813_aQ().func_72314_b((double)this.ENTITY_RADIUS, (double)this.ENTITY_RADIUS, (double)this.ENTITY_RADIUS));
        for (Object o : list) {
            if (!(o instanceof EntityCreature) && !(o instanceof EntityPlayer)) continue;
            EntityLivingBase e = (EntityLivingBase)o;
            if (o instanceof EntityPlayer && ItemHunterCoat.isFullyEquipped((EntityPlayer)o)) continue;
            int distance = (int)e.func_70068_e((Entity)player);
            if (distance <= 100 && distance >= 25) {
                this.renderEntitySphere(e, ((float)distance - 25.0f) / 75.0f);
                continue;
            }
            if (distance <= 100) continue;
            this.renderEntitySphere(e, 1.0f);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179098_w();
        GL11.glEnable((int)2929);
        GlStateManager.func_187415_K();
    }

    private void renderBloodVisionFog(int ticks) {
        float f = 80.0f / (float)ticks;
        GlStateManager.func_179094_E();
        boolean fog = GL11.glIsEnabled((int)2912);
        if (!fog) {
            GlStateManager.func_179127_m();
        }
        GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
        GlStateManager.func_179102_b((float)(4.0f * f));
        GlStateManager.func_179153_c((float)(5.5f * f));
        GlStateManager.func_187432_a((float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179095_a((float)1.0f);
        if (!fog) {
            GlStateManager.func_179106_n();
        }
        GlStateManager.func_179121_F();
    }

    private void renderEntitySphere(EntityLivingBase entity, float f) {
        float red = 1.0f;
        float green = 0.0f;
        float blue = 0.0f;
        if (entity instanceof EntityCreature) {
            if (entity instanceof EntityConvertedCreature) {
                red = 0.23127f;
                green = 0.04313f;
                blue = 0.04313f;
            } else if (ExtendedCreature.get((EntityCreature)entity).getBlood() <= 0) {
                red = 0.039215f;
                green = 0.0745f;
                blue = 0.1647f;
            }
        } else if (entity instanceof EntityPlayer && VampirePlayer.get((EntityPlayer)entity).getLevel() > 0) {
            red = 0.039215f;
            green = 0.0745f;
            blue = 0.1647f;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)entity.field_70165_t, (double)(entity.field_70163_u + (double)(entity.field_70131_O / 2.0f)), (double)entity.field_70161_v);
        GlStateManager.func_179152_a((float)(entity.field_70130_N * 1.5f), (float)(entity.field_70131_O * 1.5f), (float)(entity.field_70130_N * 1.5f));
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)(0.5f * f));
        GlStateManager.func_179148_o((int)this.entitySphereListId);
        GlStateManager.func_179121_F();
    }

    private void renderVampireBiomeFog(int ticks) {
        float f = 160.0f / (float)ticks / 1.5f;
        f *= this.vampireBiomeFogDistanceMultiplier;
        GlStateManager.func_179094_E();
        boolean fog = GL11.glIsEnabled((int)2912);
        if (!fog) {
            GlStateManager.func_179127_m();
        }
        GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
        GlStateManager.func_179102_b((float)(6.0f * f));
        GlStateManager.func_179153_c((float)(75.0f * f));
        GlStateManager.func_187432_a((float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179095_a((float)1.0f);
        if (!fog) {
            GlStateManager.func_179106_n();
        }
        GlStateManager.func_179121_F();
    }
}

