/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.model.blocks;

import de.teamlapen.vampirism.blocks.BlockBloodContainer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fluids.FluidStack;

public class BakedBloodContainerModel
implements IBakedModel {
    public static final int FLUID_LEVELS = 14;
    public static final HashMap<String, IBakedModel>[] FLUID_MODELS = new HashMap[14];
    private static final ItemOverrideList overrideList = new CustomItemOverride();
    private final IBakedModel baseModel;
    private String fluidNameItem;
    private int fluidLevelItem;

    public BakedBloodContainerModel(IBakedModel baseModel) {
        this.baseModel = baseModel;
    }

    public BakedBloodContainerModel(IBakedModel baseModel, String fluidName, int fluidLevel) {
        this(baseModel);
        this.fluidNameItem = fluidName;
        this.fluidLevelItem = fluidLevel;
    }

    public ItemCameraTransforms func_177552_f() {
        return this.baseModel.func_177552_f();
    }

    public ItemOverrideList func_188617_f() {
        return overrideList;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        try {
            HashMap<String, IBakedModel> fluidModels;
            IExtendedBlockState extendedState = (IExtendedBlockState)state;
            String fluidName = extendedState == null ? this.fluidNameItem : (String)extendedState.getValue(BlockBloodContainer.FLUID_NAME);
            int fluidLevel = extendedState == null ? this.fluidLevelItem : (Integer)extendedState.getValue(BlockBloodContainer.FLUID_LEVEL);
            quads.addAll(this.baseModel.func_188616_a(state, side, rand));
            if (fluidLevel > 0 && fluidLevel <= 14 && (fluidModels = FLUID_MODELS[fluidLevel - 1]).containsKey(fluidName)) {
                quads.addAll(fluidModels.get(fluidName).func_188616_a(state, side, rand));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return quads;
    }

    public boolean func_177555_b() {
        return this.baseModel.func_177555_b();
    }

    public boolean func_188618_c() {
        return this.baseModel.func_188618_c();
    }

    public boolean func_177556_c() {
        return this.baseModel.func_177556_c();
    }

    static {
        for (int x = 0; x < 14; ++x) {
            BakedBloodContainerModel.FLUID_MODELS[x] = new HashMap();
        }
    }

    private static class CustomItemOverride
    extends ItemOverrideList {
        public CustomItemOverride() {
            super(new LinkedList());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            FluidStack fluid;
            if (originalModel instanceof BakedBloodContainerModel && stack.func_77942_o() && stack.func_77978_p().func_74764_b("fluid") && (fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("fluid"))) != null) {
                float amount = (float)fluid.amount / 900.0f;
                return new BakedBloodContainerModel(originalModel, fluid.getFluid().getName(), amount > 0.0f && amount < 1.0f ? 1 : (int)amount);
            }
            return originalModel;
        }
    }
}

