/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.lib.lib.config.BalanceValues;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.config.Configs;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class ModConfigGui
extends GuiConfig {
    private static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(Configs.getMainConfig().getCategory("general")).getChildElements());
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("village", "category.vampirism.village", new ConfigElement(Configs.getMainConfig().getCategory("village_settings")).getChildElements()));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("disable", "category.vampirism.disable", new ConfigElement(Configs.getMainConfig().getCategory("disabled")).getChildElements()));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("assets/teamlapen-lib/gui", "category.vampirism.gui", new ConfigElement(Configs.getMainConfig().getCategory("gui")).getChildElements()));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("balance", "category.vampirism.balance", BalanceEntry.class));
        return list;
    }

    public ModConfigGui(GuiScreen parentScreen) {
        super(parentScreen, ModConfigGui.getConfigElements(), "vampirism", true, true, "Vampirism", "Main Configuration");
    }

    public static class BalanceEntry
    extends GuiConfigEntries.CategoryEntry {
        private static List<IConfigElement> getConfigElements() {
            ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
            Collection<BalanceValues> categories = Balance.getCategories().values();
            for (BalanceValues values : categories) {
                list.add((IConfigElement)BalanceEntry.createDummyElement(values));
            }
            return list;
        }

        private static DummyConfigElement.DummyCategoryElement createDummyElement(BalanceValues balance) {
            return new DummyConfigElement.DummyCategoryElement("balance_" + balance.getName(), "category.vampirism.balance_" + balance.getName(), new ConfigElement(balance.getConfigCategory()).getChildElements());
        }

        public BalanceEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement prop) {
            super(owningScreen, owningEntryList, prop);
        }

        protected GuiScreen buildChildScreen() {
            return new GuiConfig((GuiScreen)this.owningScreen, BalanceEntry.getConfigElements(), this.owningScreen.modID, "balance", true, true, this.owningScreen.title, (this.owningScreen.titleLine2 == null ? "" : this.owningScreen.titleLine2) + " > " + this.name);
        }
    }
}

