/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.core;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.lib.util.InventoryRenderHelper;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.event.FMLStateEvent;

public class ModItemsRender {
    public static void onInitStep(IInitListener.Step step, FMLStateEvent event) {
        switch (step) {
            case PRE_INIT: {
                ModItemsRender.registerRenderers();
                break;
            }
            case INIT: {
                ModItemsRender.registerColors();
            }
        }
    }

    private static void registerColors() {
        Minecraft.func_71410_x().getItemColors().func_186730_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (tintIndex == 0) {
                    return ((ItemArmor)stack.func_77973_b()).func_82814_b(stack);
                }
                switch (ModItems.armorOfSwiftness_boots.getTier(stack)) {
                    case ENHANCED: {
                        return 31999;
                    }
                    case ULTIMATE: {
                        return 522495;
                    }
                }
                return 0xFFF100;
            }
        }, new Item[]{ModItems.armorOfSwiftness_boots, ModItems.armorOfSwiftness_chest, ModItems.armorOfSwiftness_helmet, ModItems.armorOfSwiftness_legs});
    }

    private static void registerRenderers() {
        VampirismMod.log.d("ModItemsRender", "Registering renderer", new Object[0]);
        InventoryRenderHelper renderHelper = new InventoryRenderHelper("vampirism");
        renderHelper.registerRender(ModItems.vampireFang, "normal");
        renderHelper.registerRender((Item)ModItems.humanHeart, "normal");
        renderHelper.registerRender((Item)ModItems.humanHeartWeak, "normal");
        renderHelper.registerRender(ModItems.itemTent, "normal");
        renderHelper.registerRenderAllMeta((Item)ModItems.bloodBottle, 10);
        renderHelper.registerRender(ModItems.battleAxe, "normal");
        renderHelper.registerRender(ModItems.itemCoffin, "normal");
        renderHelper.registerRenderAllMeta((Item)ModItems.pureBlood, 5);
        renderHelper.registerRenderAllMeta(ModItems.hunterIntel, HunterLevelingConf.instance().HUNTER_INTEL_COUNT, "normal");
        renderHelper.registerRender(ModItems.itemGarlic, "normal");
        renderHelper.registerRenderAllMeta((Item)ModItems.injection, 3);
        renderHelper.registerRender(ModItems.itemMedChair, "normal");
        renderHelper.registerRender(ModItems.pitchfork, "normal");
        renderHelper.registerRender(ModItems.basicCrossbow, "normal");
        renderHelper.registerRender(ModItems.crossbowArrow, "normal");
        renderHelper.registerRender(ModItems.basicDoubleCrossbow, "normal");
        renderHelper.registerRender(ModItems.enhancedCrossbow, "normal");
        renderHelper.registerRender(ModItems.enhancedDoubleCrossbow, "normal");
        renderHelper.registerRender(ModItems.stake, "normal");
        renderHelper.registerRender(ModItems.vampireBlood, "normal");
        renderHelper.registerRender(ModItems.bloodPotion, "normal");
        renderHelper.registerRender(ModItems.basicTechCrossbow, "normal");
        renderHelper.registerRender(ModItems.enhancedTechCrossbow, "normal");
        renderHelper.registerRender(ModItems.techCrossbowAmmoPackage, "normal");
        renderHelper.registerRender(ModItems.vampireBook, "normal");
        renderHelper.registerRender((Item)ModItems.hunterHat0, "normal");
        renderHelper.registerRender((Item)ModItems.hunterHat1, "normal");
        ModItemsRender.registerSimpleItemWithTier(ModItems.hunterAxe);
        ModItemsRender.registerArmorItemWithTier(ModItems.armorOfSwiftness_helmet, "swiftnessArmor");
        ModItemsRender.registerArmorItemWithTier(ModItems.armorOfSwiftness_chest, "swiftnessArmor");
        ModItemsRender.registerArmorItemWithTier(ModItems.armorOfSwiftness_legs, "swiftnessArmor");
        ModItemsRender.registerArmorItemWithTier(ModItems.armorOfSwiftness_boots, "swiftnessArmor");
        ModItemsRender.registerArmorItemWithTier(ModItems.hunterCoat_helmet, "hunterCoat");
        ModItemsRender.registerArmorItemWithTier(ModItems.hunterCoat_chest, "hunterCoat");
        ModItemsRender.registerArmorItemWithTier(ModItems.hunterCoat_legs, "hunterCoat");
        ModItemsRender.registerArmorItemWithTier(ModItems.hunterCoat_boots, "hunterCoat");
    }

    private static void registerSimpleItemWithTier(IItemWithTier itemWithTier) {
        Item item = (Item)itemWithTier;
        ResourceLocation loc = new ResourceLocation("vampirism", "item/" + item.getRegistryName().func_110623_a());
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new IItemWithTier.SimpleMeshDefinition(loc));
        for (IItemWithTier.TIER s : IItemWithTier.TIER.values()) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(loc, "tier=" + s.func_176610_l())});
        }
    }

    private static void registerArmorItemWithTier(IItemWithTier armorWithTier, String baseName) {
        ItemArmor item = (ItemArmor)armorWithTier;
        ResourceLocation loc = new ResourceLocation("vampirism", "item/" + baseName);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new IItemWithTier.ArmorMeshDefinition(loc));
        for (IItemWithTier.TIER s : IItemWithTier.TIER.values()) {
            ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(loc, "part=" + item.field_77881_a.func_188450_d() + "_" + s.func_176610_l())});
        }
    }
}

