/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.blocks.VampirismBlockContainer;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.tileentity.TileCoffin;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCoffin
extends VampirismBlockContainer {
    public static final String name = "blockCoffin";
    public static final Material material = Material.field_151575_d;
    public static final PropertyEnum<EnumPartType> PART = PropertyEnum.func_177709_a((String)"part", EnumPartType.class);
    public static final PropertyBool OCCUPIED = PropertyBool.func_177716_a((String)"occupied");
    private static final String TAG = "BlockCoffin";

    public static boolean isOccupied(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)OCCUPIED);
    }

    public static void setCoffinOccupied(World world, BlockPos pos, boolean value) {
        IBlockState state = world.func_180495_p(pos);
        world.func_180501_a(pos, state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(value)), 4);
    }

    public static boolean isHead(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_177229_b(PART) == EnumPartType.HEAD;
    }

    public BlockCoffin() {
        super(name, material);
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.TRUE).func_177226_a(PART, (Comparable)((Object)EnumPartType.FOOT)));
        this.setHasFacing();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileCoffin();
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        if (state.func_177229_b(PART) == EnumPartType.FOOT) {
            super.func_180653_a(worldIn, pos, state, chance, 0);
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState iblockstate;
        if (state.func_177229_b(PART) == EnumPartType.FOOT && (iblockstate = worldIn.func_180495_p(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)))).func_177230_c() == this) {
            state = state.func_177226_a((IProperty)OCCUPIED, iblockstate.func_177229_b((IProperty)OCCUPIED));
        }
        return state;
    }

    public EnumFacing getBedDirection(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (EnumFacing)this.func_176221_a(state, world, pos).func_177229_b((IProperty)FACING);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((Item)ModItems.itemCoffin);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return state.func_177229_b(PART) == EnumPartType.HEAD ? null : ModItems.itemCoffin;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        if (state.func_177229_b(PART) == EnumPartType.HEAD) {
            i |= 8;
            if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.HEAD)).func_177226_a((IProperty)FACING, (Comparable)enumfacing).func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf((meta & 4) > 0)) : this.func_176223_P().func_177226_a(PART, (Comparable)((Object)EnumPartType.FOOT)).func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, Entity player) {
        return true;
    }

    public boolean isBedFoot(IBlockAccess world, BlockPos pos) {
        return this.func_176221_a(world.func_180495_p(pos), world, pos).func_177229_b(PART) == EnumPartType.FOOT;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (state.func_177229_b(PART) == EnumPartType.HEAD) {
            if (worldIn.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d())).func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            }
        } else if (worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c() != this) {
            worldIn.func_175698_g(pos);
            if (!worldIn.field_72995_K) {
                this.func_176226_b(worldIn, pos, state, 0);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (heldItem != null && heldItem.func_77973_b() instanceof ItemDye) {
            TileEntity other;
            TileCoffin tile = (TileCoffin)worldIn.func_175625_s(pos);
            TileEntity tileEntity = other = state.func_177229_b(PART) == EnumPartType.HEAD ? worldIn.func_175625_s(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d())) : worldIn.func_175625_s(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
            if (!(other instanceof TileCoffin)) {
                return true;
            }
            tile.changeColor(heldItem.func_77960_j());
            ((TileCoffin)other).changeColor(heldItem.func_77960_j());
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --heldItem.field_77994_a;
            }
            return true;
        }
        if (state.func_177229_b(PART) != EnumPartType.HEAD && (state = worldIn.func_180495_p(pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)))).func_177230_c() != this) {
            return true;
        }
        if (VampirePlayer.get(playerIn).getLevel() == 0) {
            playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.coffin.cant_use", new Object[0]));
            return true;
        }
        if (worldIn.field_73011_w.func_76567_e() && worldIn.func_180494_b(pos) != Biomes.field_76778_j) {
            IVampirePlayer vampire;
            EntityPlayer.SleepResult entityplayer$enumstatus;
            if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
                EntityPlayer entityplayer = this.getPlayerInCoffin(worldIn, pos);
                if (entityplayer != null) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.coffin.occupied", new Object[0]));
                    return true;
                }
                state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.FALSE);
                worldIn.func_180501_a(pos, state, 2);
            }
            if ((entityplayer$enumstatus = (vampire = VReference.VAMPIRE_FACTION.getPlayerCapability(playerIn)).trySleep(pos)) == EntityPlayer.SleepResult.OK) {
                state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.TRUE);
                worldIn.func_180501_a(pos, state, 2);
                return true;
            }
            if (entityplayer$enumstatus == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.coffin.noSleep", new Object[0]));
            } else if (entityplayer$enumstatus == EntityPlayer.SleepResult.NOT_SAFE) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]));
            }
            return true;
        }
        playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("text.vampirism.coffin.wrong_dimension", new Object[0]));
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos;
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b(PART) == EnumPartType.HEAD && worldIn.func_180495_p(blockpos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d())).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
    }

    public void setBedOccupied(IBlockAccess world, BlockPos pos, EntityPlayer player, boolean occupied) {
        if (world instanceof World) {
            IBlockState state = world.func_180495_p(pos);
            state = state.func_177230_c().func_176221_a(state, world, pos);
            state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(occupied));
            ((World)world).func_180501_a(pos, state, 2);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, PART, OCCUPIED});
    }

    private EntityPlayer getPlayerInCoffin(World worldIn, BlockPos pos) {
        for (EntityPlayer entityplayer : worldIn.field_73010_i) {
            if (!VampirePlayer.get(entityplayer).isPlayerSleeping() || !entityplayer.field_71081_bT.equals((Object)pos)) continue;
            return entityplayer;
        }
        return null;
    }

    public static enum EnumPartType implements IStringSerializable
    {
        HEAD("head"),
        FOOT("foot");

        private final String name;

        private EnumPartType(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

