/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.blocks;

import de.teamlapen.vampirism.blocks.VampirismBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAltarPillar
extends VampirismBlock {
    public static final PropertyEnum<EnumPillarType> typeProperty = PropertyEnum.func_177709_a((String)"type", EnumPillarType.class);
    private static final String name = "altarPillar";

    public BlockAltarPillar() {
        super(name, Material.field_151576_e);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(0.9f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(typeProperty, (Comparable)((Object)EnumPillarType.NONE)));
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack(Item.func_150898_a((Block)this), 1));
        EnumPillarType type = (EnumPillarType)((Object)state.func_177229_b(typeProperty));
        if (type != EnumPillarType.NONE) {
            list.add(new ItemStack(Item.func_150898_a((Block)type.fillerBlock), 1));
        }
        return list;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumPillarType)((Object)state.func_177229_b(BlockAltarPillar.typeProperty))).meta;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(typeProperty, (Comparable)((Object)EnumPillarType.byMetadata(meta)));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        EnumPillarType type = (EnumPillarType)((Object)state.func_177229_b(typeProperty));
        if (type != EnumPillarType.NONE && heldItem == null) {
            if (!playerIn.field_71075_bZ.field_75098_d) {
                playerIn.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, new ItemStack(Item.func_150898_a((Block)type.fillerBlock)));
            }
            worldIn.func_175656_a(pos, state.func_177226_a(typeProperty, (Comparable)((Object)EnumPillarType.NONE)));
            return true;
        }
        if (type == EnumPillarType.NONE && heldItem != null) {
            ItemStack stack = heldItem;
            for (EnumPillarType t : EnumPillarType.values()) {
                if (!stack.func_77973_b().equals(Item.func_150898_a((Block)t.fillerBlock))) continue;
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                worldIn.func_175656_a(pos, state.func_177226_a(typeProperty, (Comparable)((Object)t)));
                return true;
            }
        }
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{typeProperty});
    }

    public static enum EnumPillarType implements IStringSerializable
    {
        NONE(0, "none", 0.0f, Blocks.field_150350_a),
        STONE(1, "stone", 1.0f, Blocks.field_150417_aV),
        IRON(2, "iron", 2.0f, Blocks.field_150339_S),
        GOLD(3, "gold", 3.0f, Blocks.field_150340_R),
        BONE(4, "bone", 1.5f, Blocks.field_189880_di);

        private static final EnumPillarType[] METADATA_LOOKUP;
        public final String name;
        public final Block fillerBlock;
        public final int meta;
        private final float value;

        public static EnumPillarType byMetadata(int metadata) {
            if (metadata < 0 || metadata >= METADATA_LOOKUP.length) {
                metadata = 0;
            }
            return METADATA_LOOKUP[metadata];
        }

        private EnumPillarType(int meta, String name, float value, Block fillerBlock) {
            this.meta = meta;
            this.name = name;
            this.fillerBlock = fillerBlock;
            this.value = value;
        }

        public String func_176610_l() {
            return this.name;
        }

        public float getValue() {
            return this.value;
        }

        static {
            METADATA_LOOKUP = new EnumPillarType[EnumPillarType.values().length];
            EnumPillarType[] enumPillarTypeArray = EnumPillarType.values();
            int n = enumPillarTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumPillarType type;
                EnumPillarType.METADATA_LOOKUP[type.meta] = type = enumPillarTypeArray[i];
            }
        }
    }
}

