/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.api;

import de.teamlapen.vampirism.api.entity.IBiteableRegistry;
import de.teamlapen.vampirism.api.entity.IExtendedCreatureVampirism;
import de.teamlapen.vampirism.api.entity.ISundamageRegistry;
import de.teamlapen.vampirism.api.entity.factions.IFactionPlayerHandler;
import de.teamlapen.vampirism.api.entity.factions.IFactionRegistry;
import de.teamlapen.vampirism.api.entity.player.actions.IActionRegistry;
import de.teamlapen.vampirism.api.entity.player.skills.ISkillRegistry;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampireVisionRegistry;
import de.teamlapen.vampirism.api.items.IBloodPotionRegistry;
import de.teamlapen.vampirism.api.items.IHunterWeaponCraftingManager;
import de.teamlapen.vampirism.api.world.IVampirismVillageProvider;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public class VampirismAPI {
    @CapabilityInject(value=IExtendedCreatureVampirism.class)
    private static final Capability<IExtendedCreatureVampirism> CAP_CREATURE = null;
    @CapabilityInject(value=IFactionPlayerHandler.class)
    private static final Capability<IFactionPlayerHandler> CAP_FACTION_HANDLER_PLAYER = null;
    private static IFactionRegistry factionRegistry;
    private static ISundamageRegistry sundamageRegistry;
    private static IBiteableRegistry biteableRegistry;
    private static IActionRegistry actionRegistry;
    private static ISkillRegistry skillRegistry;
    private static IVampireVisionRegistry vampireVisionRegistry;
    private static IVampirismVillageProvider.IProviderProvider vampirismVillageProviders;
    private static IHunterWeaponCraftingManager weaponCraftingManager;
    private static IBloodPotionRegistry bloodPotionRegistry;

    public static IVampireVisionRegistry vampireVisionRegistry() {
        return vampireVisionRegistry;
    }

    public static IFactionRegistry factionRegistry() {
        return factionRegistry;
    }

    public static ISundamageRegistry sundamageRegistry() {
        return sundamageRegistry;
    }

    public static IBiteableRegistry biteableRegistry() {
        return biteableRegistry;
    }

    public static ISkillRegistry skillRegistry() {
        return skillRegistry;
    }

    public static IActionRegistry actionRegistry() {
        return actionRegistry;
    }

    public static IHunterWeaponCraftingManager weaponCraftingManager() {
        return weaponCraftingManager;
    }

    public static IBloodPotionRegistry bloodPotionRegistry() {
        return bloodPotionRegistry;
    }

    public static void setUpRegistries(IFactionRegistry factionReg, ISundamageRegistry sundamageReg, IBiteableRegistry biteableReg, IActionRegistry actionReg, ISkillRegistry skillReg, IVampireVisionRegistry vampireVisionReg, IBloodPotionRegistry bloodPotionReg) {
        factionRegistry = factionReg;
        sundamageRegistry = sundamageReg;
        biteableRegistry = biteableReg;
        actionRegistry = actionReg;
        skillRegistry = skillReg;
        vampireVisionRegistry = vampireVisionReg;
        bloodPotionRegistry = bloodPotionReg;
    }

    public static void setUpAccessors(IVampirismVillageProvider.IProviderProvider villagePro, IHunterWeaponCraftingManager weaponCraftingMan) {
        vampirismVillageProviders = villagePro;
        weaponCraftingManager = weaponCraftingMan;
    }

    public static IFactionPlayerHandler getFactionPlayerHandler(EntityPlayer player) {
        return (IFactionPlayerHandler)player.getCapability(CAP_FACTION_HANDLER_PLAYER, null);
    }

    public static IExtendedCreatureVampirism getExtendedCreatureVampirism(EntityCreature creature) {
        return (IExtendedCreatureVampirism)creature.getCapability(CAP_CREATURE, null);
    }

    public static IVampirismVillageProvider getVampirismVillageProvider(World world) {
        return vampirismVillageProviders.getProviderForWorld(world);
    }
}

