/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.network;

import com.google.common.collect.ImmutableCollection;
import de.teamlapen.lib.HelperRegistry;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.network.AbstractPacketDispatcher;
import de.teamlapen.lib.lib.network.ISyncable;
import de.teamlapen.vampirism.network.AbstractClientMessageHandler;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class UpdateEntityPacket
implements IMessage {
    private static final String TAG = "UpdateEntityPacket";
    private int id;
    private NBTTagCompound data;
    private NBTTagCompound caps;

    public static UpdateEntityPacket create(ISyncable.ISyncableEntityCapabilityInst cap) {
        NBTTagCompound data = new NBTTagCompound();
        cap.writeFullUpdateToNBT(data);
        return UpdateEntityPacket.create(cap, data);
    }

    public static UpdateEntityPacket create(EntityLiving entity, ISyncable.ISyncableEntityCapabilityInst ... caps) {
        if (!(entity instanceof ISyncable)) {
            throw new IllegalArgumentException("You cannot use this packet to sync this entity. The entity has to implement ISyncable");
        }
        UpdateEntityPacket packet = UpdateEntityPacket.create(caps);
        packet.data = new NBTTagCompound();
        ((ISyncable)entity).writeFullUpdateToNBT(packet.data);
        return packet;
    }

    public static UpdateEntityPacket create(ISyncable.ISyncableEntityCapabilityInst ... caps) {
        UpdateEntityPacket packet = new UpdateEntityPacket();
        packet.id = caps[0].getTheEntityID();
        packet.caps = new NBTTagCompound();
        for (int i = 0; i < caps.length; ++i) {
            NBTTagCompound data = new NBTTagCompound();
            caps[i].writeFullUpdateToNBT(data);
            packet.caps.func_74782_a(caps[i].getCapKey().toString(), (NBTBase)data);
        }
        return packet;
    }

    public static UpdateEntityPacket create(ISyncable.ISyncableEntityCapabilityInst cap, NBTTagCompound data) {
        UpdateEntityPacket packet = new UpdateEntityPacket();
        packet.id = cap.getTheEntityID();
        packet.caps = new NBTTagCompound();
        packet.caps.func_74782_a(cap.getCapKey().toString(), (NBTBase)data);
        return packet;
    }

    public static UpdateEntityPacket create(Entity entity) {
        if (!(entity instanceof ISyncable)) {
            throw new IllegalArgumentException("You cannot use this packet to sync this entity. The entity has to implement ISyncable");
        }
        UpdateEntityPacket packet = new UpdateEntityPacket();
        packet.id = entity.func_145782_y();
        packet.data = new NBTTagCompound();
        ((ISyncable)entity).writeFullUpdateToNBT(packet.data);
        return packet;
    }

    public static UpdateEntityPacket create(Entity entity, NBTTagCompound data) {
        if (!(entity instanceof ISyncable)) {
            throw new IllegalArgumentException("You cannot use this packet to sync this entity. The entity has to implement ISyncable");
        }
        UpdateEntityPacket packet = new UpdateEntityPacket();
        packet.id = entity.func_145782_y();
        packet.data = data;
        return packet;
    }

    public static UpdateEntityPacket createJoinWorldPacket(Entity entity) {
        ArrayList<ISyncable.ISyncableEntityCapabilityInst> capsToSync = null;
        ImmutableCollection allCaps = null;
        if (entity instanceof EntityCreature) {
            allCaps = HelperRegistry.getSyncableEntityCaps().values();
        } else if (entity instanceof EntityPlayer) {
            allCaps = HelperRegistry.getSyncablePlayerCaps().values();
        }
        if (allCaps != null && allCaps.size() > 0) {
            capsToSync = new ArrayList<ISyncable.ISyncableEntityCapabilityInst>();
            for (Capability cap : allCaps) {
                ISyncable.ISyncableEntityCapabilityInst p = (ISyncable.ISyncableEntityCapabilityInst)entity.getCapability(cap, null);
                if (p == null) continue;
                capsToSync.add(p);
            }
        }
        if (capsToSync != null) {
            if (entity instanceof ISyncable) {
                return UpdateEntityPacket.create((EntityLiving)entity, capsToSync.toArray(new ISyncable.ISyncableEntityCapabilityInst[capsToSync.size()]));
            }
            return UpdateEntityPacket.create(capsToSync.toArray(new ISyncable.ISyncableEntityCapabilityInst[capsToSync.size()]));
        }
        if (entity instanceof ISyncable) {
            return UpdateEntityPacket.create(entity);
        }
        VampLib.log.w("RequestUpdatePacket", "There is nothing to update for entity %s", entity);
        return null;
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.id = tag.func_74762_e("id");
        if (tag.func_74764_b("data")) {
            this.data = tag.func_74775_l("data");
        }
        if (tag.func_74764_b("caps")) {
            this.caps = tag.func_74775_l("caps");
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("id", this.id);
        if (this.data != null) {
            tag.func_74782_a("data", (NBTBase)this.data);
        }
        if (this.caps != null) {
            tag.func_74782_a("caps", (NBTBase)this.caps);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    extends AbstractClientMessageHandler<UpdateEntityPacket> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, UpdateEntityPacket message, MessageContext ctx) {
            if (player.field_70170_p == null) {
                VampLib.log.w(UpdateEntityPacket.TAG, "World not loaded yet", new Object[0]);
                return null;
            }
            Entity e = player.field_70170_p.func_73045_a(message.id);
            if (e == null) {
                VampLib.log.e(UpdateEntityPacket.TAG, "Did not find entity %s", message.id);
                return null;
            }
            if (message.data != null) {
                ISyncable syncable;
                try {
                    syncable = (ISyncable)e;
                }
                catch (ClassCastException ex) {
                    VampLib.log.w(UpdateEntityPacket.TAG, "Target entity %s does not implement ISyncable (%s)", e, ex);
                    return null;
                }
                syncable.loadUpdateFromNBT(message.data);
            }
            if (message.caps != null) {
                for (String key : message.caps.func_150296_c()) {
                    this.handleCapability(e, new ResourceLocation(key), message.caps.func_74775_l(key));
                }
            }
            return null;
        }

        @Override
        protected AbstractPacketDispatcher getDispatcher() {
            return VampLib.dispatcher;
        }

        @Override
        protected boolean handleOnMainThread() {
            return true;
        }

        private void handleCapability(Entity e, ResourceLocation key, NBTTagCompound data) {
            ISyncable syncable;
            Capability cap = (Capability)HelperRegistry.getSyncableEntityCaps().get((Object)key);
            if (cap == null && e instanceof EntityPlayer) {
                cap = (Capability)HelperRegistry.getSyncablePlayerCaps().get((Object)key);
            }
            if (cap == null) {
                VampLib.log.w(UpdateEntityPacket.TAG, "Capability with key %s is not registered in the HelperRegistry", key);
            }
            try {
                syncable = (ISyncable)e.getCapability(cap, null);
            }
            catch (ClassCastException ex) {
                VampLib.log.w(UpdateEntityPacket.TAG, "Target entity's capability %s (%s)does not implement ISyncable (%s)", e.getCapability(cap, null), cap, ex);
                return;
            }
            if (syncable == null) {
                VampLib.log.w(UpdateEntityPacket.TAG, "Target entity %s does not have capability %s", e, cap);
            } else {
                syncable.loadUpdateFromNBT(data);
            }
        }
    }
}

