/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import de.teamlapen.lib.lib.util.UtilLib;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class SimpleSpawnerLogic {
    private String entityName = "Pig";
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 800;
    private int activateRange = 16;
    private int spawnCount = 1;
    private int maxNearbyEntities = 4;
    private int spawnRange = 4;
    private int spawnDelay = 20;

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public abstract BlockPos getSpawnerPosition();

    public abstract World getSpawnerWorld();

    public boolean isActivated() {
        BlockPos blockpos = this.getSpawnerPosition();
        return this.getSpawnerWorld().func_175636_b((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, (double)this.activateRange);
    }

    public void readFromNbt(NBTTagCompound nbt) {
        this.entityName = nbt.func_74779_i("entity_name");
        this.minSpawnDelay = nbt.func_74762_e("min_delay");
        this.maxSpawnDelay = nbt.func_74762_e("max_delay");
        this.maxNearbyEntities = nbt.func_74762_e("max_nearby");
        this.spawnDelay = nbt.func_74762_e("delay");
        this.activateRange = nbt.func_74762_e("activate_range");
        this.spawnRange = nbt.func_74762_e("spawn_range");
        this.spawnCount = nbt.func_74762_e("spawn_count");
    }

    public void setActivateRange(int activateRange) {
        this.activateRange = activateRange;
    }

    public boolean setDelayToMin(int p_98268_1_) {
        if (p_98268_1_ == 1 && this.getSpawnerWorld().field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    public void setMaxNearbyEntities(int maxNearbyEntities) {
        this.maxNearbyEntities = maxNearbyEntities;
    }

    public void setMaxSpawnDelay(int maxSpawnDelay) {
        this.maxSpawnDelay = maxSpawnDelay;
    }

    public void setMinSpawnDelay(int minSpawnDelay) {
        this.minSpawnDelay = minSpawnDelay;
    }

    public void setSpawnCount(int spawnCount) {
        this.spawnCount = spawnCount;
    }

    public void setSpawnRange(int spawnRange) {
        this.spawnRange = spawnRange;
    }

    public void updateSpawner() {
        if (this.isActivated()) {
            BlockPos blockpos = this.getSpawnerPosition();
            if (!this.getSpawnerWorld().field_72995_K) {
                Entity entity;
                if (this.spawnDelay == -1) {
                    this.resetTimer();
                }
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                    return;
                }
                boolean flag = false;
                for (int i = 0; i < this.spawnCount && (entity = EntityList.func_75620_a((String)this.getEntityName(), (World)this.getSpawnerWorld())) != null; ++i) {
                    int j = this.getSpawnerWorld().func_72872_a(entity.getClass(), this.getSpawningBox()).size();
                    if (j >= this.maxNearbyEntities) {
                        this.resetTimer();
                        break;
                    }
                    if (!UtilLib.spawnEntityInWorld(this.getSpawnerWorld(), this.getSpawningBox(), entity, 1)) continue;
                    this.onSpawned(entity);
                    flag = true;
                }
                if (flag) {
                    this.resetTimer();
                }
            }
        }
    }

    public void writeToNbt(NBTTagCompound nbt) {
        nbt.func_74778_a("entity_name", this.entityName);
        nbt.func_74768_a("min_delay", this.minSpawnDelay);
        nbt.func_74768_a("max_delay", this.maxSpawnDelay);
        nbt.func_74768_a("max_nearby", this.maxNearbyEntities);
        nbt.func_74768_a("delay", this.spawnDelay);
        nbt.func_74768_a("activate_range", this.activateRange);
        nbt.func_74768_a("spawn_range", this.spawnRange);
        nbt.func_74768_a("spawn_count", this.spawnCount);
    }

    protected AxisAlignedBB getSpawningBox() {
        BlockPos blockpos = this.getSpawnerPosition();
        return new AxisAlignedBB((double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), (double)(blockpos.func_177958_n() + 1), (double)(blockpos.func_177956_o() + 1), (double)(blockpos.func_177952_p() + 1)).func_72314_b((double)this.spawnRange, (double)this.spawnRange, (double)this.spawnRange);
    }

    protected abstract void onReset();

    protected void onSpawned(Entity e) {
        if (e instanceof EntityLiving) {
            ((EntityLiving)e).func_70656_aK();
        }
    }

    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.getSpawnerWorld().field_73012_v.nextInt(i);
        }
        this.onReset();
    }
}

