/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.lib.util.IModCompat;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;

public class ModCompatLoader
implements IInitListener {
    private static final String TAG = "ModCompat";
    private final String configName;
    @Nullable
    private List<IModCompat> availableModCompats = new LinkedList<IModCompat>();
    private List<IModCompat> loadedModCompats;

    public ModCompatLoader(String configName) {
        this.configName = configName;
    }

    public void addModCompat(IModCompat compat) {
        if (this.availableModCompats == null) {
            throw new IllegalStateException("Add mod compats BEFORE pre-init (" + compat.getModID() + ")");
        }
        this.availableModCompats.add(compat);
    }

    public List<IModCompat> getAvailableModCompats() {
        return this.availableModCompats;
    }

    @Override
    public void onInitStep(IInitListener.Step step, FMLStateEvent event) {
        if (step == IInitListener.Step.PRE_INIT) {
            this.prepareModCompats(((FMLPreInitializationEvent)event).getModConfigurationDirectory());
        }
        Iterator<IModCompat> it = this.loadedModCompats.iterator();
        while (it.hasNext()) {
            IModCompat next = it.next();
            try {
                next.onInitStep(step, event);
            }
            catch (Exception e) {
                VampLib.log.e(TAG, "---------------------------------------------------------", new Object[0]);
                VampLib.log.e(TAG, e, "Mod Compat %s threw an exception during %s. Unloading.", new Object[]{next.getModID(), step});
                VampLib.log.e(TAG, "---------------------------------------------------------", new Object[0]);
                it.remove();
            }
        }
    }

    private boolean isModLoaded(IModCompat modCompat) {
        return Loader.isModLoaded((String)modCompat.getModID());
    }

    private void prepareModCompats(File configDir) {
        if (this.availableModCompats == null) {
            VampLib.log.w(TAG, "Trying to load mod compat twice", new Object[0]);
            return;
        }
        Configuration config = new Configuration(new File(configDir, this.configName));
        LinkedList<IModCompat> loaded = new LinkedList<IModCompat>();
        for (IModCompat modCompat : this.availableModCompats) {
            if (!this.isModLoaded(modCompat)) continue;
            ConfigCategory compatCat = config.getCategory(modCompat.getModID());
            if (!config.getBoolean("enable_compat_" + modCompat.getModID(), compatCat.getName(), true, "If the compatibility for this mod should be loaded")) continue;
            modCompat.loadConfigs(config, compatCat);
            loaded.add(modCompat);
            VampLib.log.d(TAG, "Prepared %s compatibility", modCompat.getModID());
        }
        this.loadedModCompats = loaded;
        this.availableModCompats = null;
    }
}

