/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class Logger {
    private final org.apache.logging.log4j.Logger logger;
    private final Throwable stackInfo = new Throwable();
    private final String packagename;
    private final String modid;
    private boolean debug = false;
    private boolean displayId = false;

    public Logger(String modid, String packagename) {
        this.logger = LogManager.getLogger((String)modid);
        this.packagename = packagename;
        this.modid = modid;
    }

    public void d(String tag, String format, Object ... data) {
        if (this.debug) {
            this.log(Level.INFO, tag, format, data);
        } else {
            this.log(Level.DEBUG, tag, format, data);
        }
    }

    public void e(String tag, String format, Object ... data) {
        this.log(Level.ERROR, tag, format, data);
    }

    public void e(String tag, Throwable t, String format, Object ... data) {
        this.log(Level.ERROR, tag, format, data);
        this.logger.catching(Level.ERROR, t);
    }

    public void i(String tag, String format, Object ... data) {
        this.log(Level.INFO, tag, format, data);
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void t(String format, Object ... data) {
        this.log(Level.INFO, "Test", format, data);
    }

    public void w(String tag, String format, Object ... data) {
        this.log(Level.WARN, tag, format, data);
    }

    private String getLogLocation(Throwable t) {
        StackTraceElement[] stack = t.getStackTrace();
        if (stack.length < 3) {
            return "";
        }
        StackTraceElement caller = stack[2];
        String msg = caller.getClassName() + "." + caller.getMethodName() + "(" + caller.getFileName() + ":" + caller.getLineNumber() + ")";
        return msg.replace(this.packagename, "{" + this.modid + "}");
    }

    private void log(Level level, String tag, String format, Object ... data) {
        if (tag == null) {
            tag = this.getLogLocation(this.stackInfo.fillInStackTrace());
        }
        this.logger.log(level, (this.displayId ? '[' + this.modid + ']' : "") + '[' + tag + ']' + String.format(format, data));
    }
}

