/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.util;

import de.teamlapen.lib.VampLib;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.ArrayUtils;

public abstract class BasicCommand
extends CommandBase {
    protected final int PERMISSION_LEVEL_CHEAT = 2;
    protected final int PERMISSION_LEVEL_ADMIN = 3;
    protected final int PERMISSION_LEVEL_FULL = 4;
    protected List aliases = new ArrayList();
    private List<SubCommand> subCommands = new ArrayList<SubCommand>();
    private SubCommand unknown = new SubCommand(){

        @Override
        public List addTabCompletionOptions(ICommandSender sender, String[] args, BlockPos pos) {
            return null;
        }

        @Override
        public boolean canSenderUseCommand(ICommandSender sender) {
            return true;
        }

        @Override
        public String getCommandName() {
            return "unknown";
        }

        @Override
        public String getCommandUsage(ICommandSender sender) {
            return BasicCommand.this.func_71518_a(sender);
        }

        @Override
        public void processCommand(MinecraftServer server, ICommandSender sender, String[] args) {
            BasicCommand.sendMessage(sender, "Unknown command");
        }
    };

    public static void sendMessage(ICommandSender target, String message) {
        String[] lines;
        for (String line : lines = message.split("\\n")) {
            target.func_145747_a((ITextComponent)new TextComponentString(line));
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] param) throws CommandException {
        if (param == null || param.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if ("help".equals(param[0])) {
            if (param.length > 1) {
                BasicCommand.sendMessage(sender, String.format("/%s %s", this.func_71517_b(), this.getSub(param[1]).getCommandUsage(sender)));
            } else {
                String t = "Available subcommands: ";
                for (SubCommand s : this.subCommands) {
                    t = t + s.getCommandName() + ", ";
                }
                t = t + "Use /" + this.func_71517_b() + " help <subcommand> to get more informations";
                BasicCommand.sendMessage(sender, t);
            }
            return;
        }
        SubCommand cmd = this.getSub(param[0]);
        if (cmd.canSenderUseCommand(sender)) {
            try {
                cmd.processCommand(server, sender, (String[])ArrayUtils.subarray((Object[])param, (int)1, (int)param.length));
            }
            catch (CommandException e) {
                throw e;
            }
            catch (Exception e) {
                VampLib.log.e("BasicCommand", e, "Failed to execute command %s with params %s", cmd, Arrays.toString(ArrayUtils.subarray((Object[])param, (int)1, (int)param.length)));
                throw new CommandException("commands.vampirism.failed_to_execute", new Object[0]);
            }
        } else {
            TextComponentTranslation textcomponenttranslation1 = new TextComponentTranslation("commands.generic.permission", new Object[0]);
            textcomponenttranslation1.func_150256_b().func_150238_a(TextFormatting.RED);
            sender.func_145747_a((ITextComponent)textcomponenttranslation1);
        }
    }

    public List func_71514_a() {
        return this.aliases;
    }

    public String func_71518_a(ICommandSender p_71518_1_) {
        return String.format("/%s <subcommand> <params> | Use /%s help to get all available subcommands", this.func_71517_b(), this.func_71517_b());
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        return args.length == 1 ? BasicCommand.func_71530_a((String[])args, (String[])this.getSubNames()) : this.getSubcommandTabCompletion(sender, args, pos);
    }

    public boolean func_82358_a(String[] p_82358_1_, int p_82358_2_) {
        return false;
    }

    protected void addSub(SubCommand s) {
        this.subCommands.add(s);
    }

    protected boolean canCommandSenderUseCheatCommand(ICommandSender sender) {
        return sender.func_70003_b(2, this.func_71517_b()) || sender instanceof EntityPlayer && ((EntityPlayer)sender).field_71075_bZ.field_75098_d;
    }

    private SubCommand getSub(String name) {
        for (SubCommand s : this.subCommands) {
            if (!s.getCommandName().equals(name)) continue;
            return s;
        }
        return this.unknown;
    }

    private String[] getSubNames() {
        String[] names = new String[this.subCommands.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.subCommands.get(i).getCommandName();
        }
        return names;
    }

    @Nonnull
    private List getSubcommandTabCompletion(ICommandSender sender, String[] args, BlockPos pos) {
        if (args.length < 2) {
            return Collections.EMPTY_LIST;
        }
        List options = this.getSub(args[0]).addTabCompletionOptions(sender, (String[])ArrayUtils.subarray((Object[])args, (int)1, (int)args.length), pos);
        return options == null ? Collections.emptyList() : options;
    }

    public static interface SubCommand {
        public List addTabCompletionOptions(ICommandSender var1, String[] var2, BlockPos var3);

        public boolean canSenderUseCommand(ICommandSender var1);

        public String getCommandName();

        public String getCommandUsage(ICommandSender var1);

        public void processCommand(MinecraftServer var1, ICommandSender var2, String[] var3) throws CommandException;
    }
}

