/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.tile;

import de.teamlapen.lib.lib.inventory.InventoryContainer;
import de.teamlapen.lib.lib.inventory.InventorySlot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class InventoryTileEntity
extends TileEntity
implements IInventory,
InventorySlot.IInventorySlotInventory {
    protected final int MAX_DIST_SQRT = 40;
    private InventorySlot[] slots;

    public InventoryTileEntity(InventorySlot[] slots) {
        this.slots = slots;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public ItemStack func_70298_a(int slot, int amt) {
        ItemStack stack = this.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
            return stack;
        }
        return null;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public int func_174890_g() {
        return 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public Container getNewInventoryContainer(InventoryPlayer inv) {
        return new InventoryContainer(inv, this);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    @Override
    public InventorySlot[] getSlots() {
        return this.slots;
    }

    public ItemStack func_70301_a(int slot) {
        return this.slots[slot].stack;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.slots[slot].itemSelector != null && stack != null) {
            return this.slots[slot].itemSelector.isItemAllowed(stack);
        }
        return true;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_174818_b(this.func_174877_v()) < 40.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i].stack = null;
        }
        NBTTagList tagList = tagCompound.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.slots.length) continue;
            this.slots[slot].stack = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
    }

    public ItemStack func_70304_b(int index) {
        if (this.slots[index] != null) {
            ItemStack itemstack = this.slots[index].stack;
            this.slots[index].stack = null;
            return itemstack;
        }
        return null;
    }

    public void func_174885_b(int id, int value) {
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.slots[slot].stack = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound nbt = super.func_189515_b(compound);
        NBTTagList itemList = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            ItemStack stack = this.slots[i].stack;
            if (stack == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            itemList.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("Inventory", (NBTBase)itemList);
        return nbt;
    }
}

