/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib;

import com.google.common.collect.ImmutableMap;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.entity.IPlayerEventListener;
import de.teamlapen.lib.lib.network.ISyncable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;

public class HelperRegistry {
    private static final String TAG = "HelperRegistry";
    private static Map<ResourceLocation, Capability> syncablePlayerCaps = new HashMap<ResourceLocation, Capability>();
    private static Map<ResourceLocation, Capability> syncableEntityCaps = new HashMap<ResourceLocation, Capability>();
    private static List<Capability> playerEventListenerCaps = new ArrayList<Capability>();
    private static Capability[] playerEventListenerCapsFinal;
    private static ImmutableMap<ResourceLocation, Capability> syncablePlayerCapsFinal;
    private static ImmutableMap<ResourceLocation, Capability> syncableEntityCapsFinal;

    public static Capability[] getEventListenerCaps() {
        return playerEventListenerCapsFinal;
    }

    public static ImmutableMap<ResourceLocation, Capability> getSyncablePlayerCaps() {
        return syncablePlayerCapsFinal;
    }

    public static ImmutableMap<ResourceLocation, Capability> getSyncableEntityCaps() {
        return syncableEntityCapsFinal;
    }

    public static void registerSyncableEntityCapability(Capability capability, ResourceLocation key, Class<? extends ISyncable.ISyncableEntityCapabilityInst> clz) {
        if (syncableEntityCaps == null) {
            VampLib.log.e(TAG, "You have to register the syncable property %s (%s) before post init", clz, capability);
            return;
        }
        syncableEntityCaps.put(key, capability);
    }

    public static void registerSyncablePlayerCapability(Capability capability, ResourceLocation key, Class<? extends ISyncable.ISyncableEntityCapabilityInst> clz) {
        if (syncablePlayerCaps == null) {
            VampLib.log.e(TAG, "You have to register the syncable property %s (%s) before post init", clz, capability);
            return;
        }
        syncablePlayerCaps.put(key, capability);
    }

    public static void registerPlayerEventReceivingCapability(Capability capability, Class<? extends IPlayerEventListener> clz) {
        if (playerEventListenerCaps == null) {
            VampLib.log.e(TAG, "You have to register PlayerEventReceiver BEFORE post init. (" + capability + ")", new Object[0]);
        } else {
            playerEventListenerCaps.add(capability);
        }
    }

    public static void finish() {
        syncableEntityCapsFinal = ImmutableMap.copyOf(syncableEntityCaps);
        syncableEntityCaps = null;
        syncablePlayerCapsFinal = ImmutableMap.copyOf(syncablePlayerCaps);
        syncablePlayerCaps = null;
        playerEventListenerCapsFinal = playerEventListenerCaps.toArray(new Capability[playerEventListenerCaps.size()]);
        playerEventListenerCaps = null;
    }
}

