/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.util.LinkedList;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.internal.KDCOptions;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.PAForUserEnc;
import sun.security.krb5.internal.PaPacOptions;
import sun.security.krb5.internal.ReferralsCache;
import sun.security.krb5.internal.Ticket;
import sun.security.util.DerValue;

public class CredentialsUtil {
    private static boolean DEBUG = Krb5.DEBUG;

    public static Credentials acquireS4U2selfCreds(PrincipalName principalName, Credentials credentials) throws KrbException, IOException {
        Credentials credentials2;
        String string;
        if (!credentials.isForwardable()) {
            throw new KrbException("S4U2self needs a FORWARDABLE ticket");
        }
        PrincipalName principalName2 = credentials.getClient();
        String string2 = principalName.getRealmString();
        if (!string2.equals(string = credentials.getClient().getRealmString())) {
            if (Config.DISABLE_REFERRALS) {
                throw new KrbException("Cross-realm S4U2Self request not possible when referrals are disabled.");
            }
            if (credentials.getClientAlias() != null) {
                principalName2 = credentials.getClientAlias();
            }
            principalName2 = new PrincipalName(principalName2.getNameType(), principalName2.getNameStrings(), new Realm(string2));
        }
        if (!(credentials2 = CredentialsUtil.serviceCreds(KDCOptions.with(1), credentials, credentials.getClient(), principalName2, null, new PAData[]{new PAData(129, new PAForUserEnc(principalName, credentials.getSessionKey()).asn1Encode()), new PAData(167, new PaPacOptions().setResourceBasedConstrainedDelegation(true).setClaims(true).asn1Encode())}, S4U2Type.SELF)).getClient().equals(principalName)) {
            throw new KrbException("S4U2self request not honored by KDC");
        }
        if (!credentials2.isForwardable()) {
            throw new KrbException("S4U2self ticket must be FORWARDABLE");
        }
        return credentials2;
    }

    public static Credentials acquireS4U2proxyCreds(String string, Ticket ticket, PrincipalName principalName, Credentials credentials) throws KrbException, IOException {
        Credentials credentials2;
        String string2;
        PrincipalName principalName2 = new PrincipalName(string);
        String string3 = principalName2.getRealmString();
        if (!string3.equals(string2 = credentials.getClient().getRealmString())) {
            if (Config.DISABLE_REFERRALS) {
                throw new KrbException("Cross-realm S4U2Proxy request not possible when referrals are disabled.");
            }
            principalName2 = new PrincipalName(principalName2.getNameType(), principalName2.getNameStrings(), new Realm(string2));
        }
        if (!(credentials2 = CredentialsUtil.serviceCreds(KDCOptions.with(14, 1), credentials, credentials.getClient(), principalName2, new Ticket[]{ticket}, new PAData[]{new PAData(167, new PaPacOptions().setResourceBasedConstrainedDelegation(true).setClaims(true).asn1Encode())}, S4U2Type.PROXY)).getClient().equals(principalName)) {
            throw new KrbException("S4U2proxy request not honored by KDC");
        }
        return credentials2;
    }

    public static Credentials acquireServiceCreds(String string, Credentials credentials) throws KrbException, IOException {
        PrincipalName principalName = new PrincipalName(string, 0);
        return CredentialsUtil.serviceCreds(principalName, credentials);
    }

    private static Credentials getTGTforRealm(String string, String string2, Credentials credentials, boolean[] blArray) throws KrbException {
        String[] stringArray = Realm.getRealmsList(string, string2);
        int n = 0;
        int n2 = 0;
        Credentials credentials2 = null;
        Credentials credentials3 = null;
        Credentials credentials4 = null;
        PrincipalName principalName = null;
        String string3 = null;
        blArray[0] = true;
        credentials2 = credentials;
        n = 0;
        while (n < stringArray.length) {
            principalName = PrincipalName.tgsService(string2, stringArray[n]);
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: main loop: [" + n + "] tempService=" + principalName);
            }
            try {
                credentials3 = CredentialsUtil.serviceCreds(principalName, credentials2);
            }
            catch (Exception exception) {
                credentials3 = null;
            }
            if (credentials3 == null) {
                if (DEBUG) {
                    System.out.println(">>> Credentials acquireServiceCreds: no tgt; searching thru capath");
                }
                credentials3 = null;
                for (n2 = n + 1; credentials3 == null && n2 < stringArray.length; ++n2) {
                    principalName = PrincipalName.tgsService(stringArray[n2], stringArray[n]);
                    if (DEBUG) {
                        System.out.println(">>> Credentials acquireServiceCreds: inner loop: [" + n2 + "] tempService=" + principalName);
                    }
                    try {
                        credentials3 = CredentialsUtil.serviceCreds(principalName, credentials2);
                        continue;
                    }
                    catch (Exception exception) {
                        credentials3 = null;
                    }
                }
            }
            if (credentials3 == null) {
                if (!DEBUG) break;
                System.out.println(">>> Credentials acquireServiceCreds: no tgt; cannot get creds");
                break;
            }
            string3 = credentials3.getServer().getInstanceComponent();
            if (blArray[0] && !credentials3.checkDelegate()) {
                if (DEBUG) {
                    System.out.println(">>> Credentials acquireServiceCreds: global OK-AS-DELEGATE turned off at " + credentials3.getServer());
                }
                blArray[0] = false;
            }
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: got tgt");
            }
            if (string3.equals(string2)) {
                credentials4 = credentials3;
                break;
            }
            for (n2 = n + 1; n2 < stringArray.length && !string3.equals(stringArray[n2]); ++n2) {
            }
            if (n2 >= stringArray.length) break;
            n = n2;
            credentials2 = credentials3;
            if (!DEBUG) continue;
            System.out.println(">>> Credentials acquireServiceCreds: continuing with main loop counter reset to " + n);
        }
        return credentials4;
    }

    private static Credentials serviceCreds(PrincipalName principalName, Credentials credentials) throws KrbException, IOException {
        return CredentialsUtil.serviceCreds(new KDCOptions(), credentials, credentials.getClient(), principalName, null, null, S4U2Type.NONE);
    }

    private static Credentials serviceCreds(KDCOptions kDCOptions, Credentials credentials, PrincipalName principalName, PrincipalName principalName2, Ticket[] ticketArray, PAData[] pADataArray, S4U2Type s4U2Type) throws KrbException, IOException {
        if (!Config.DISABLE_REFERRALS) {
            try {
                return CredentialsUtil.serviceCredsReferrals(kDCOptions, credentials, principalName, principalName2, s4U2Type, ticketArray, pADataArray);
            }
            catch (KrbException krbException) {
                // empty catch block
            }
        }
        return CredentialsUtil.serviceCredsSingle(kDCOptions, credentials, principalName, credentials.getClientAlias(), principalName2, principalName2, s4U2Type, ticketArray, pADataArray);
    }

    private static Credentials serviceCredsReferrals(KDCOptions kDCOptions, Credentials credentials, PrincipalName principalName, PrincipalName principalName2, S4U2Type s4U2Type, Ticket[] ticketArray, PAData[] pADataArray) throws KrbException, IOException {
        kDCOptions = new KDCOptions(kDCOptions.toBooleanArray());
        kDCOptions.set(15, true);
        PrincipalName principalName3 = principalName2;
        PrincipalName principalName4 = principalName2;
        Credentials credentials2 = null;
        boolean bl = false;
        LinkedList<String> linkedList = new LinkedList<String>();
        PrincipalName principalName5 = credentials.getClientAlias();
        while (linkedList.size() <= Config.MAX_REFERRALS) {
            Credentials[] credentialsArray;
            ReferralsCache.ReferralCacheEntry referralCacheEntry = ReferralsCache.get(principalName, principalName2, principalName4.getRealmString());
            String string = null;
            if (referralCacheEntry == null) {
                String[] stringArray;
                credentials2 = CredentialsUtil.serviceCredsSingle(kDCOptions, credentials, principalName, principalName5, principalName4, principalName3, s4U2Type, ticketArray, pADataArray);
                credentialsArray = credentials2.getServer();
                if (!principalName4.equals(credentialsArray) && (stringArray = credentialsArray.getNameStrings()).length == 2 && stringArray[0].equals("krbtgt") && !principalName4.getRealmAsString().equals(stringArray[1])) {
                    if (s4U2Type == S4U2Type.NONE) {
                        ReferralsCache.put(principalName, principalName2, credentialsArray.getRealmString(), stringArray[1], credentials2);
                    }
                    string = stringArray[1];
                    bl = true;
                }
            } else {
                credentials2 = referralCacheEntry.getCreds();
                string = referralCacheEntry.getToRealm();
                bl = true;
            }
            if (!bl) break;
            if (s4U2Type == S4U2Type.PROXY) {
                credentialsArray = new Credentials[]{credentials2, null};
                string = CredentialsUtil.handleS4U2ProxyReferral(credentials, credentialsArray, principalName2);
                credentials2 = credentialsArray[0];
                if (ticketArray == null || ticketArray.length == 0 || credentialsArray[1] == null) {
                    throw new KrbException("Additional tickets expected for S4U2Proxy.");
                }
                ticketArray[0] = credentialsArray[1].getTicket();
            } else if (s4U2Type == S4U2Type.SELF) {
                CredentialsUtil.handleS4U2SelfReferral(pADataArray, credentials, credentials2);
            }
            if (linkedList.contains(string)) {
                return null;
            }
            credentials = credentials2;
            principalName4 = new PrincipalName(principalName4.getNameString(), principalName4.getNameType(), string);
            linkedList.add(string);
            bl = false;
        }
        return credentials2;
    }

    private static Credentials serviceCredsSingle(KDCOptions kDCOptions, Credentials object, PrincipalName principalName, PrincipalName principalName2, PrincipalName principalName3, PrincipalName principalName4, S4U2Type s4U2Type, Ticket[] ticketArray, PAData[] pADataArray) throws KrbException, IOException {
        Object object2;
        Credentials credentials = null;
        boolean[] blArray = new boolean[]{true};
        String[] stringArray = ((Credentials)object).getServer().getNameStrings();
        String string = stringArray[1];
        String string2 = principalName3.getRealmString();
        if (!string2.equals(string)) {
            if (DEBUG) {
                System.out.println(">>> serviceCredsSingle: cross-realm authentication");
                System.out.println(">>> serviceCredsSingle: obtaining credentials from " + string + " to " + string2);
            }
            if ((object2 = CredentialsUtil.getTGTforRealm(string, string2, (Credentials)object, blArray)) == null) {
                throw new KrbApErrException(63, "No service creds");
            }
            if (DEBUG) {
                System.out.println(">>> Cross-realm TGT Credentials serviceCredsSingle: ");
                Credentials.printDebug((Credentials)object2);
            }
            if (s4U2Type == S4U2Type.SELF) {
                CredentialsUtil.handleS4U2SelfReferral(pADataArray, (Credentials)object, (Credentials)object2);
            }
            object = object2;
            principalName = ((Credentials)object).getClient();
        } else if (DEBUG) {
            System.out.println(">>> Credentials serviceCredsSingle: same realm");
        }
        object2 = new KrbTgsReq(kDCOptions, (Credentials)object, principalName, principalName2, principalName3, principalName4, ticketArray, pADataArray);
        credentials = ((KrbTgsReq)object2).sendAndGetCreds();
        if (credentials != null) {
            if (DEBUG) {
                System.out.println(">>> TGS credentials serviceCredsSingle:");
                Credentials.printDebug(credentials);
            }
            if (!blArray[0]) {
                credentials.resetDelegate();
            }
        }
        return credentials;
    }

    private static void handleS4U2SelfReferral(PAData[] pADataArray, Credentials credentials, Credentials credentials2) throws Asn1Exception, KrbException, IOException {
        if (DEBUG) {
            System.out.println(">>> Handling S4U2Self referral");
        }
        for (int i = 0; i < pADataArray.length; ++i) {
            PAData pAData = pADataArray[i];
            if (pAData.getType() != 129) continue;
            PAForUserEnc pAForUserEnc = new PAForUserEnc(new DerValue(pAData.getValue()), credentials.getSessionKey());
            pADataArray[i] = new PAData(129, new PAForUserEnc(pAForUserEnc.getName(), credentials2.getSessionKey()).asn1Encode());
            break;
        }
    }

    private static String handleS4U2ProxyReferral(Credentials credentials, Credentials[] credentialsArray, PrincipalName principalName) throws KrbException, IOException {
        if (DEBUG) {
            System.out.println(">>> Handling S4U2Proxy referral");
        }
        Credentials credentials2 = null;
        Credentials credentials3 = CredentialsUtil.serviceCreds(principalName, credentials);
        String string = credentials3.getServer().getRealmString();
        String string2 = credentialsArray[0].getServer().getNameStrings()[1];
        credentials2 = !string2.equals(string) ? CredentialsUtil.getTGTforRealm(string2, string, credentialsArray[0], new boolean[1]) : credentialsArray[0];
        credentialsArray[0] = CredentialsUtil.getTGTforRealm(credentials.getClient().getRealmString(), string, credentials, new boolean[1]);
        credentialsArray[1] = credentials2;
        return string;
    }

    private static enum S4U2Type {
        NONE,
        SELF,
        PROXY;

    }
}

